/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.activity;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.transport.activity.ActivityManager;
import org.thingsboard.server.common.transport.activity.ActivityReportCallback;
import org.thingsboard.server.common.transport.activity.ActivityState;
import org.thingsboard.server.common.transport.activity.strategy.ActivityStrategy;
import org.thingsboard.server.queue.scheduler.SchedulerComponent;

public abstract class AbstractActivityManager<Key, Metadata>
implements ActivityManager<Key, Metadata> {
    private static final Logger log = LoggerFactory.getLogger(AbstractActivityManager.class);
    private final ConcurrentMap<Key, ActivityStateWrapper> states = new ConcurrentHashMap<Key, ActivityStateWrapper>();
    @Autowired
    protected SchedulerComponent scheduler;

    protected void init() {
        long reportingPeriodMillis = this.getReportingPeriodMillis();
        this.scheduler.scheduleAtFixedRate(this::onReportingPeriodEnd, (long)new Random().nextInt((int)reportingPeriodMillis), reportingPeriodMillis, TimeUnit.MILLISECONDS);
    }

    protected abstract long getReportingPeriodMillis();

    protected abstract ActivityStrategy getStrategy();

    protected abstract ActivityState<Metadata> updateState(Key var1, ActivityState<Metadata> var2);

    protected abstract boolean hasExpired(long var1);

    protected abstract void onStateExpiry(Key var1, Metadata var2);

    protected abstract void reportActivity(Key var1, Metadata var2, long var3, ActivityReportCallback<Key> var5);

    @Override
    public void onActivity(Key key, Metadata metadata, long newLastRecordedTime) {
        if (key == null) {
            log.error("Failed to process activity event: provided activity key is null.");
            return;
        }
        log.debug("Received activity event for key: [{}]. Event time: [{}].", key, (Object)newLastRecordedTime);
        AtomicBoolean shouldReport = new AtomicBoolean(false);
        final AtomicLong lastRecordedTime = new AtomicLong();
        AtomicLong lastReportedTime = new AtomicLong();
        this.states.compute(key, (__, stateWrapper) -> {
            if (stateWrapper == null) {
                ActivityState newState = new ActivityState();
                stateWrapper = new ActivityStateWrapper();
                stateWrapper.setState(newState);
                stateWrapper.setStrategy(this.getStrategy());
            }
            ActivityState<Object> state = stateWrapper.getState();
            state.setMetadata(metadata);
            if (state.getLastRecordedTime() < newLastRecordedTime) {
                state.setLastRecordedTime(newLastRecordedTime);
            }
            shouldReport.set(stateWrapper.getStrategy().onActivity());
            lastRecordedTime.set(state.getLastRecordedTime());
            lastReportedTime.set(stateWrapper.getLastReportedTime());
            return stateWrapper;
        });
        if (shouldReport.get() && lastReportedTime.get() < lastRecordedTime.get()) {
            log.debug("Going to report first activity event for key: [{}]. Event time: [{}].", key, (Object)lastRecordedTime.get());
            this.reportActivity(key, metadata, lastRecordedTime.get(), new ActivityReportCallback<Key>(){

                @Override
                public void onSuccess(Key key, long reportedTime) {
                    AbstractActivityManager.this.updateLastReportedTime(key, reportedTime);
                }

                @Override
                public void onFailure(Key key, Throwable t) {
                    log.debug("Failed to report first activity event for key: [{}]. Event time: [{}].", new Object[]{key, lastRecordedTime.get(), t});
                }
            });
        }
    }

    @Override
    public void onReportingPeriodEnd() {
        log.debug("Going to end reporting period.");
        for (Map.Entry entry : this.states.entrySet()) {
            Object key = entry.getKey();
            ActivityStateWrapper stateWrapper = (ActivityStateWrapper)entry.getValue();
            try {
                this.reportLastEvent(key, stateWrapper);
            }
            catch (Exception e) {
                log.error("Failed to report last activity event on reporting period end for key: [{}]. State: [{}].", new Object[]{key, stateWrapper, e});
            }
        }
    }

    private void reportLastEvent(Key key, ActivityStateWrapper stateWrapper) {
        boolean shouldReport;
        boolean hasExpired;
        ActivityState currentState = stateWrapper.getState();
        long lastRecordedTime = currentState.getLastRecordedTime();
        long lastReportedTime = stateWrapper.getLastReportedTime();
        Object metadata = currentState.getMetadata();
        ActivityState updatedState = this.updateState(key, currentState);
        if (updatedState != null) {
            stateWrapper.setState(updatedState);
            lastRecordedTime = updatedState.getLastRecordedTime();
            metadata = updatedState.getMetadata();
            hasExpired = this.hasExpired(lastRecordedTime);
            shouldReport = stateWrapper.getStrategy().onReportingPeriodEnd();
        } else {
            this.states.remove(key);
            hasExpired = false;
            shouldReport = true;
        }
        if (hasExpired) {
            this.states.remove(key);
            this.onStateExpiry(key, metadata);
            shouldReport = true;
        }
        if (shouldReport && lastReportedTime < lastRecordedTime) {
            final long timeToReport = lastRecordedTime;
            log.debug("Going to report last activity event for key: [{}]. Event time: [{}].", key, (Object)timeToReport);
            this.reportActivity(key, metadata, timeToReport, new ActivityReportCallback<Key>(){

                @Override
                public void onSuccess(Key key, long reportedTime) {
                    AbstractActivityManager.this.updateLastReportedTime(key, reportedTime);
                }

                @Override
                public void onFailure(Key key, Throwable t) {
                    log.debug("Failed to report last activity event for key: [{}]. Event time: [{}].", new Object[]{key, timeToReport, t});
                }
            });
        }
    }

    @Override
    public long getLastRecordedTime(Key key) {
        ActivityStateWrapper stateWrapper = (ActivityStateWrapper)this.states.get(key);
        return stateWrapper == null ? 0L : stateWrapper.getState().getLastRecordedTime();
    }

    private void updateLastReportedTime(Key key, long newLastReportedTime) {
        this.states.computeIfPresent(key, (__, stateWrapper) -> {
            stateWrapper.setLastReportedTime(Math.max(stateWrapper.getLastReportedTime(), newLastReportedTime));
            return stateWrapper;
        });
    }

    private class ActivityStateWrapper {
        private volatile ActivityState<Metadata> state;
        private volatile long lastReportedTime;
        private volatile ActivityStrategy strategy;

        public ActivityState<Metadata> getState() {
            return this.state;
        }

        public long getLastReportedTime() {
            return this.lastReportedTime;
        }

        public ActivityStrategy getStrategy() {
            return this.strategy;
        }

        public void setState(ActivityState<Metadata> state) {
            this.state = state;
        }

        public void setLastReportedTime(long lastReportedTime) {
            this.lastReportedTime = lastReportedTime;
        }

        public void setStrategy(ActivityStrategy strategy) {
            this.strategy = strategy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActivityStateWrapper)) {
                return false;
            }
            ActivityStateWrapper other = (ActivityStateWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLastReportedTime() != other.getLastReportedTime()) {
                return false;
            }
            ActivityState this$state = this.getState();
            ActivityState other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            ActivityStrategy this$strategy = this.getStrategy();
            ActivityStrategy other$strategy = other.getStrategy();
            return !(this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ActivityStateWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lastReportedTime = this.getLastReportedTime();
            result = result * 59 + (int)($lastReportedTime >>> 32 ^ $lastReportedTime);
            ActivityState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            ActivityStrategy $strategy = this.getStrategy();
            result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractActivityManager.ActivityStateWrapper(state=" + this.getState() + ", lastReportedTime=" + this.getLastReportedTime() + ", strategy=" + this.getStrategy() + ")";
        }
    }
}

