/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.TenantProfileId;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportTenantProfileCache;
import org.thingsboard.server.common.transport.limits.TransportRateLimitService;
import org.thingsboard.server.common.transport.profile.TenantProfileUpdateResult;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.DataDecodingEncodingService;
import org.thingsboard.server.queue.util.TbTransportComponent;

@Component
@TbTransportComponent
public class DefaultTransportTenantProfileCache
implements TransportTenantProfileCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransportTenantProfileCache.class);
    private final Lock tenantProfileFetchLock = new ReentrantLock();
    private final ConcurrentMap<TenantProfileId, TenantProfile> profiles = new ConcurrentHashMap<TenantProfileId, TenantProfile>();
    private final ConcurrentMap<TenantId, TenantProfileId> tenantIds = new ConcurrentHashMap<TenantId, TenantProfileId>();
    private final ConcurrentMap<TenantProfileId, Set<TenantId>> tenantProfileIds = new ConcurrentHashMap<TenantProfileId, Set<TenantId>>();
    private final DataDecodingEncodingService dataDecodingEncodingService;
    private TransportRateLimitService rateLimitService;
    private TransportService transportService;

    @Lazy
    @Autowired
    public void setRateLimitService(TransportRateLimitService rateLimitService) {
        this.rateLimitService = rateLimitService;
    }

    @Lazy
    @Autowired
    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    public DefaultTransportTenantProfileCache(DataDecodingEncodingService dataDecodingEncodingService) {
        this.dataDecodingEncodingService = dataDecodingEncodingService;
    }

    @Override
    public TenantProfile get(TenantId tenantId) {
        return this.getTenantProfile(tenantId);
    }

    @Override
    public TenantProfileUpdateResult put(ByteString profileBody) {
        Optional profileOpt = this.dataDecodingEncodingService.decode(profileBody.toByteArray());
        if (profileOpt.isPresent()) {
            TenantProfile newProfile = (TenantProfile)profileOpt.get();
            log.trace("[{}] put: {}", (Object)newProfile.getId(), (Object)newProfile);
            this.profiles.put(newProfile.getId(), newProfile);
            Set<TenantId> affectedTenants = (Set<TenantId>)this.tenantProfileIds.get(newProfile.getId());
            return new TenantProfileUpdateResult(newProfile, affectedTenants != null ? affectedTenants : Collections.emptySet());
        }
        log.warn("Failed to decode profile: {}", (Object)profileBody.toString());
        return new TenantProfileUpdateResult(null, Collections.emptySet());
    }

    @Override
    public boolean put(TenantId tenantId, TenantProfileId profileId) {
        log.trace("[{}] put: {}", (Object)tenantId, (Object)profileId);
        TenantProfileId oldProfileId = (TenantProfileId)this.tenantIds.get(tenantId);
        if (oldProfileId != null && !oldProfileId.equals((Object)profileId)) {
            this.tenantProfileIds.computeIfAbsent(oldProfileId, id -> ConcurrentHashMap.newKeySet()).remove(tenantId);
            this.tenantIds.put(tenantId, profileId);
            this.tenantProfileIds.computeIfAbsent(profileId, id -> ConcurrentHashMap.newKeySet()).add(tenantId);
            return true;
        }
        return false;
    }

    @Override
    public Set<TenantId> remove(TenantProfileId profileId) {
        Set tenants = (Set)this.tenantProfileIds.remove(profileId);
        if (tenants != null) {
            tenants.forEach(this.tenantIds::remove);
        }
        this.profiles.remove(profileId);
        return tenants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TenantProfile getTenantProfile(TenantId tenantId) {
        TenantProfile profile = null;
        TenantProfileId tenantProfileId = (TenantProfileId)this.tenantIds.get(tenantId);
        if (tenantProfileId != null) {
            profile = (TenantProfile)this.profiles.get(tenantProfileId);
        }
        if (profile == null) {
            this.tenantProfileFetchLock.lock();
            try {
                tenantProfileId = (TenantProfileId)this.tenantIds.get(tenantId);
                if (tenantProfileId != null) {
                    profile = (TenantProfile)this.profiles.get(tenantProfileId);
                }
                if (profile == null) {
                    TransportProtos.GetEntityProfileRequestMsg msg = TransportProtos.GetEntityProfileRequestMsg.newBuilder().setEntityType(EntityType.TENANT.name()).setEntityIdMSB(tenantId.getId().getMostSignificantBits()).setEntityIdLSB(tenantId.getId().getLeastSignificantBits()).build();
                    TransportProtos.GetEntityProfileResponseMsg entityProfileMsg = this.transportService.getEntityProfile(msg);
                    Optional profileOpt = this.dataDecodingEncodingService.decode(entityProfileMsg.getData().toByteArray());
                    if (profileOpt.isPresent()) {
                        profile = (TenantProfile)profileOpt.get();
                        TenantProfile existingProfile = (TenantProfile)this.profiles.get(profile.getId());
                        if (existingProfile != null) {
                            profile = existingProfile;
                        } else {
                            this.profiles.put(profile.getId(), profile);
                        }
                    } else {
                        log.warn("[{}] Can't decode tenant profile: {}", (Object)tenantId, (Object)entityProfileMsg.getData());
                        throw new RuntimeException("Can't decode tenant profile!");
                    }
                    this.tenantProfileIds.computeIfAbsent(profile.getId(), id -> ConcurrentHashMap.newKeySet()).add(tenantId);
                    this.tenantIds.put(tenantId, profile.getId());
                    Optional apiStateOpt = this.dataDecodingEncodingService.decode(entityProfileMsg.getApiState().toByteArray());
                    apiStateOpt.ifPresent(apiUsageState -> this.rateLimitService.update(tenantId, apiUsageState.isTransportEnabled()));
                }
            }
            finally {
                this.tenantProfileFetchLock.unlock();
            }
        }
        return profile;
    }
}

