/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import com.google.protobuf.ByteString;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.transport.TransportDeviceProfileCache;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.DataDecodingEncodingService;
import org.thingsboard.server.queue.util.TbTransportComponent;

@Component
@TbTransportComponent
public class DefaultTransportDeviceProfileCache
implements TransportDeviceProfileCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransportDeviceProfileCache.class);
    private final Lock deviceProfileFetchLock = new ReentrantLock();
    private final ConcurrentMap<DeviceProfileId, DeviceProfile> deviceProfiles = new ConcurrentHashMap<DeviceProfileId, DeviceProfile>();
    private final DataDecodingEncodingService dataDecodingEncodingService;
    private TransportService transportService;

    @Lazy
    @Autowired
    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    public DefaultTransportDeviceProfileCache(DataDecodingEncodingService dataDecodingEncodingService) {
        this.dataDecodingEncodingService = dataDecodingEncodingService;
    }

    @Override
    public DeviceProfile getOrCreate(DeviceProfileId id, ByteString profileBody) {
        Optional deviceProfile;
        DeviceProfile profile = (DeviceProfile)this.deviceProfiles.get(id);
        if (profile == null && (deviceProfile = this.dataDecodingEncodingService.decode(profileBody.toByteArray())).isPresent()) {
            profile = (DeviceProfile)deviceProfile.get();
            this.deviceProfiles.put(id, profile);
        }
        return profile;
    }

    @Override
    public DeviceProfile get(DeviceProfileId id) {
        return this.getDeviceProfile(id);
    }

    @Override
    public void put(DeviceProfile profile) {
        this.deviceProfiles.put(profile.getId(), profile);
    }

    @Override
    public DeviceProfile put(ByteString profileBody) {
        Optional deviceProfile = this.dataDecodingEncodingService.decode(profileBody.toByteArray());
        if (deviceProfile.isPresent()) {
            this.put((DeviceProfile)deviceProfile.get());
            return (DeviceProfile)deviceProfile.get();
        }
        return null;
    }

    @Override
    public void evict(DeviceProfileId id) {
        this.deviceProfiles.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceProfile getDeviceProfile(DeviceProfileId id) {
        DeviceProfile profile;
        block5: {
            profile = (DeviceProfile)this.deviceProfiles.get(id);
            if (profile == null) {
                this.deviceProfileFetchLock.lock();
                try {
                    TransportProtos.GetEntityProfileRequestMsg msg = TransportProtos.GetEntityProfileRequestMsg.newBuilder().setEntityType(EntityType.DEVICE_PROFILE.name()).setEntityIdMSB(id.getId().getMostSignificantBits()).setEntityIdLSB(id.getId().getLeastSignificantBits()).build();
                    TransportProtos.GetEntityProfileResponseMsg entityProfileMsg = this.transportService.getEntityProfile(msg);
                    Optional profileOpt = this.dataDecodingEncodingService.decode(entityProfileMsg.getData().toByteArray());
                    if (profileOpt.isPresent()) {
                        profile = (DeviceProfile)profileOpt.get();
                        this.put(profile);
                        break block5;
                    }
                    log.warn("[{}] Can't find device profile: {}", (Object)id, (Object)entityProfileMsg.getData());
                    throw new RuntimeException("Can't find device profile!");
                }
                finally {
                    this.deviceProfileFetchLock.unlock();
                }
            }
        }
        return profile;
    }
}

