/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.config.ssl;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.transport.config.ssl.KeystoreSslCredentials;
import org.thingsboard.server.common.transport.config.ssl.PemSslCredentials;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.common.transport.config.ssl.SslCredentialsType;

public class SslCredentialsConfig {
    private static final Logger log = LoggerFactory.getLogger(SslCredentialsConfig.class);
    private boolean enabled = true;
    private SslCredentialsType type;
    private PemSslCredentials pem;
    private KeystoreSslCredentials keystore;
    private SslCredentials credentials;
    private final String name;
    private final boolean trustsOnly;

    public SslCredentialsConfig(String name, boolean trustsOnly) {
        this.name = name;
        this.trustsOnly = trustsOnly;
    }

    @PostConstruct
    public void init() {
        if (this.enabled) {
            log.info("{}: Initializing SSL credentials.", (Object)this.name);
            if (SslCredentialsType.PEM.equals((Object)this.type) && this.pem.canUse()) {
                this.credentials = this.pem;
            } else if (this.keystore.canUse()) {
                if (SslCredentialsType.PEM.equals((Object)this.type)) {
                    log.warn("{}: Specified PEM configuration is not valid. Using SSL keystore configuration as fallback.", (Object)this.name);
                }
                this.credentials = this.keystore;
            } else {
                throw new RuntimeException(this.name + ": Invalid SSL credentials configuration. None of the PEM or KEYSTORE configurations can be used!");
            }
            try {
                this.credentials.init(this.trustsOnly);
            }
            catch (Exception e) {
                throw new RuntimeException(this.name + ": Failed to init SSL credentials configuration.", e);
            }
        } else {
            log.info("{}: Skipping initialization of disabled SSL credentials.", (Object)this.name);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SslCredentialsType getType() {
        return this.type;
    }

    public PemSslCredentials getPem() {
        return this.pem;
    }

    public KeystoreSslCredentials getKeystore() {
        return this.keystore;
    }

    public SslCredentials getCredentials() {
        return this.credentials;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTrustsOnly() {
        return this.trustsOnly;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setType(SslCredentialsType type) {
        this.type = type;
    }

    public void setPem(PemSslCredentials pem) {
        this.pem = pem;
    }

    public void setKeystore(KeystoreSslCredentials keystore) {
        this.keystore = keystore;
    }

    public void setCredentials(SslCredentials credentials) {
        this.credentials = credentials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SslCredentialsConfig)) {
            return false;
        }
        SslCredentialsConfig other = (SslCredentialsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isTrustsOnly() != other.isTrustsOnly()) {
            return false;
        }
        SslCredentialsType this$type = this.getType();
        SslCredentialsType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        PemSslCredentials this$pem = this.getPem();
        PemSslCredentials other$pem = other.getPem();
        if (this$pem == null ? other$pem != null : !((Object)this$pem).equals(other$pem)) {
            return false;
        }
        KeystoreSslCredentials this$keystore = this.getKeystore();
        KeystoreSslCredentials other$keystore = other.getKeystore();
        if (this$keystore == null ? other$keystore != null : !((Object)this$keystore).equals(other$keystore)) {
            return false;
        }
        SslCredentials this$credentials = this.getCredentials();
        SslCredentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SslCredentialsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isTrustsOnly() ? 79 : 97);
        SslCredentialsType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        PemSslCredentials $pem = this.getPem();
        result = result * 59 + ($pem == null ? 43 : ((Object)$pem).hashCode());
        KeystoreSslCredentials $keystore = this.getKeystore();
        result = result * 59 + ($keystore == null ? 43 : ((Object)$keystore).hashCode());
        SslCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "SslCredentialsConfig(enabled=" + this.isEnabled() + ", type=" + this.getType() + ", pem=" + this.getPem() + ", keystore=" + this.getKeystore() + ", credentials=" + this.getCredentials() + ", name=" + this.getName() + ", trustsOnly=" + this.isTrustsOnly() + ")";
    }
}

