/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.cache.ota.OtaPackageDataCache;
import org.thingsboard.server.common.transport.TransportResourceCache;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.limits.TransportRateLimitService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.scheduler.SchedulerComponent;

public abstract class TransportContext {
    private static final Logger log = LoggerFactory.getLogger(TransportContext.class);
    protected final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    protected TransportService transportService;
    @Autowired
    private TbServiceInfoProvider serviceInfoProvider;
    @Autowired
    private SchedulerComponent scheduler;
    private ExecutorService executor;
    @Autowired
    private OtaPackageDataCache otaPackageDataCache;
    @Autowired
    private TransportResourceCache transportResourceCache;
    @Autowired
    protected TransportRateLimitService rateLimitService;

    @PostConstruct
    public void init() {
        this.executor = ThingsBoardExecutors.newWorkStealingPool((int)50, this.getClass());
    }

    @PreDestroy
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public String getNodeId() {
        return this.serviceInfoProvider.getServiceId();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public TransportService getTransportService() {
        return this.transportService;
    }

    public TbServiceInfoProvider getServiceInfoProvider() {
        return this.serviceInfoProvider;
    }

    public SchedulerComponent getScheduler() {
        return this.scheduler;
    }

    public TransportResourceCache getTransportResourceCache() {
        return this.transportResourceCache;
    }

    public TransportRateLimitService getRateLimitService() {
        return this.rateLimitService;
    }

    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    public void setServiceInfoProvider(TbServiceInfoProvider serviceInfoProvider) {
        this.serviceInfoProvider = serviceInfoProvider;
    }

    public void setScheduler(SchedulerComponent scheduler) {
        this.scheduler = scheduler;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setOtaPackageDataCache(OtaPackageDataCache otaPackageDataCache) {
        this.otaPackageDataCache = otaPackageDataCache;
    }

    public void setTransportResourceCache(TransportResourceCache transportResourceCache) {
        this.transportResourceCache = transportResourceCache;
    }

    public void setRateLimitService(TransportRateLimitService rateLimitService) {
        this.rateLimitService = rateLimitService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransportContext)) {
            return false;
        }
        TransportContext other = (TransportContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        TransportService this$transportService = this.getTransportService();
        TransportService other$transportService = other.getTransportService();
        if (this$transportService == null ? other$transportService != null : !this$transportService.equals(other$transportService)) {
            return false;
        }
        TbServiceInfoProvider this$serviceInfoProvider = this.getServiceInfoProvider();
        TbServiceInfoProvider other$serviceInfoProvider = other.getServiceInfoProvider();
        if (this$serviceInfoProvider == null ? other$serviceInfoProvider != null : !this$serviceInfoProvider.equals(other$serviceInfoProvider)) {
            return false;
        }
        SchedulerComponent this$scheduler = this.getScheduler();
        SchedulerComponent other$scheduler = other.getScheduler();
        if (this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        OtaPackageDataCache this$otaPackageDataCache = this.getOtaPackageDataCache();
        OtaPackageDataCache other$otaPackageDataCache = other.getOtaPackageDataCache();
        if (this$otaPackageDataCache == null ? other$otaPackageDataCache != null : !this$otaPackageDataCache.equals(other$otaPackageDataCache)) {
            return false;
        }
        TransportResourceCache this$transportResourceCache = this.getTransportResourceCache();
        TransportResourceCache other$transportResourceCache = other.getTransportResourceCache();
        if (this$transportResourceCache == null ? other$transportResourceCache != null : !this$transportResourceCache.equals(other$transportResourceCache)) {
            return false;
        }
        TransportRateLimitService this$rateLimitService = this.getRateLimitService();
        TransportRateLimitService other$rateLimitService = other.getRateLimitService();
        return !(this$rateLimitService == null ? other$rateLimitService != null : !this$rateLimitService.equals(other$rateLimitService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransportContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        TransportService $transportService = this.getTransportService();
        result = result * 59 + ($transportService == null ? 43 : $transportService.hashCode());
        TbServiceInfoProvider $serviceInfoProvider = this.getServiceInfoProvider();
        result = result * 59 + ($serviceInfoProvider == null ? 43 : $serviceInfoProvider.hashCode());
        SchedulerComponent $scheduler = this.getScheduler();
        result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        OtaPackageDataCache $otaPackageDataCache = this.getOtaPackageDataCache();
        result = result * 59 + ($otaPackageDataCache == null ? 43 : $otaPackageDataCache.hashCode());
        TransportResourceCache $transportResourceCache = this.getTransportResourceCache();
        result = result * 59 + ($transportResourceCache == null ? 43 : $transportResourceCache.hashCode());
        TransportRateLimitService $rateLimitService = this.getRateLimitService();
        result = result * 59 + ($rateLimitService == null ? 43 : $rateLimitService.hashCode());
        return result;
    }

    public String toString() {
        return "TransportContext(mapper=" + this.getMapper() + ", transportService=" + this.getTransportService() + ", serviceInfoProvider=" + this.getServiceInfoProvider() + ", scheduler=" + this.getScheduler() + ", executor=" + this.getExecutor() + ", otaPackageDataCache=" + this.getOtaPackageDataCache() + ", transportResourceCache=" + this.getTransportResourceCache() + ", rateLimitService=" + this.getRateLimitService() + ")";
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public OtaPackageDataCache getOtaPackageDataCache() {
        return this.otaPackageDataCache;
    }
}

