/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.transport.TransportTenantProfileCache;
import org.thingsboard.server.queue.discovery.TenantRoutingInfo;
import org.thingsboard.server.queue.discovery.TenantRoutingInfoService;

@Service
@ConditionalOnExpression(value="'${service.type:null}'=='tb-transport'")
public class TransportTenantRoutingInfoService
implements TenantRoutingInfoService {
    private static final Logger log = LoggerFactory.getLogger(TransportTenantRoutingInfoService.class);
    private TransportTenantProfileCache tenantProfileCache;

    public TransportTenantRoutingInfoService(TransportTenantProfileCache tenantProfileCache) {
        this.tenantProfileCache = tenantProfileCache;
    }

    public TenantRoutingInfo getRoutingInfo(TenantId tenantId) {
        TenantProfile profile = this.tenantProfileCache.get(tenantId);
        return new TenantRoutingInfo(tenantId, profile.isIsolatedTbRuleEngine());
    }
}

