/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.auth;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.transport.TransportContext;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;

public class SessionInfoCreator {
    private static final Logger log = LoggerFactory.getLogger(SessionInfoCreator.class);

    public static TransportProtos.SessionInfoProto create(ValidateDeviceCredentialsResponse msg, TransportContext context, UUID sessionId) {
        return SessionInfoCreator.getSessionInfoProto(msg, context.getNodeId(), sessionId);
    }

    public static TransportProtos.SessionInfoProto create(ValidateDeviceCredentialsResponse msg, String nodeId, UUID sessionId) {
        return SessionInfoCreator.getSessionInfoProto(msg, nodeId, sessionId);
    }

    private static TransportProtos.SessionInfoProto getSessionInfoProto(ValidateDeviceCredentialsResponse msg, String nodeId, UUID sessionId) {
        return TransportProtos.SessionInfoProto.newBuilder().setNodeId(nodeId).setSessionIdMSB(sessionId.getMostSignificantBits()).setSessionIdLSB(sessionId.getLeastSignificantBits()).setDeviceIdMSB(msg.getDeviceInfo().getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceInfo().getDeviceId().getId().getLeastSignificantBits()).setTenantIdMSB(msg.getDeviceInfo().getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getDeviceInfo().getTenantId().getId().getLeastSignificantBits()).setCustomerIdMSB(msg.getDeviceInfo().getCustomerId().getId().getMostSignificantBits()).setCustomerIdLSB(msg.getDeviceInfo().getCustomerId().getId().getLeastSignificantBits()).setDeviceName(msg.getDeviceInfo().getDeviceName()).setDeviceType(msg.getDeviceInfo().getDeviceType()).setDeviceProfileIdMSB(msg.getDeviceInfo().getDeviceProfileId().getId().getMostSignificantBits()).setDeviceProfileIdLSB(msg.getDeviceInfo().getDeviceProfileId().getId().getLeastSignificantBits()).build();
    }
}

