/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.session;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.UUID;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.transport.auth.TransportDeviceInfo;
import org.thingsboard.server.common.transport.session.SessionContext;
import org.thingsboard.server.gen.transport.TransportProtos;

public abstract class DeviceAwareSessionContext
implements SessionContext {
    protected final UUID sessionId;
    private volatile DeviceId deviceId;
    protected volatile TransportDeviceInfo deviceInfo;
    protected volatile DeviceProfile deviceProfile;
    private volatile TransportProtos.SessionInfoProto sessionInfo;
    private volatile boolean connected;

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceInfo(TransportDeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
        this.deviceId = deviceInfo.getDeviceId();
    }

    @Override
    public void onDeviceProfileUpdate(TransportProtos.SessionInfoProto sessionInfo, DeviceProfile deviceProfile) {
        this.sessionInfo = sessionInfo;
        this.deviceProfile = deviceProfile;
        this.deviceInfo.setDeviceType(deviceProfile.getName());
    }

    @Override
    public void onDeviceUpdate(TransportProtos.SessionInfoProto sessionInfo, Device device, Optional<DeviceProfile> deviceProfileOpt) {
        this.sessionInfo = sessionInfo;
        this.deviceInfo.setDeviceProfileId(device.getDeviceProfileId());
        this.deviceInfo.setDeviceType(device.getType());
        deviceProfileOpt.ifPresent(profile -> {
            this.deviceProfile = profile;
        });
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setDisconnected() {
        this.connected = false;
    }

    @ConstructorProperties(value={"sessionId"})
    public DeviceAwareSessionContext(UUID sessionId) {
        this.sessionId = sessionId;
    }

    public void setDeviceId(DeviceId deviceId) {
        this.deviceId = deviceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceAwareSessionContext)) {
            return false;
        }
        DeviceAwareSessionContext other = (DeviceAwareSessionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isConnected() != other.isConnected()) {
            return false;
        }
        UUID this$sessionId = this.getSessionId();
        UUID other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        TransportDeviceInfo this$deviceInfo = this.getDeviceInfo();
        TransportDeviceInfo other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !((Object)this$deviceInfo).equals(other$deviceInfo)) {
            return false;
        }
        DeviceProfile this$deviceProfile = this.getDeviceProfile();
        DeviceProfile other$deviceProfile = other.getDeviceProfile();
        if (this$deviceProfile == null ? other$deviceProfile != null : !this$deviceProfile.equals(other$deviceProfile)) {
            return false;
        }
        TransportProtos.SessionInfoProto this$sessionInfo = this.getSessionInfo();
        TransportProtos.SessionInfoProto other$sessionInfo = other.getSessionInfo();
        return !(this$sessionInfo == null ? other$sessionInfo != null : !this$sessionInfo.equals(other$sessionInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceAwareSessionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConnected() ? 79 : 97);
        UUID $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        TransportDeviceInfo $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : ((Object)$deviceInfo).hashCode());
        DeviceProfile $deviceProfile = this.getDeviceProfile();
        result = result * 59 + ($deviceProfile == null ? 43 : $deviceProfile.hashCode());
        TransportProtos.SessionInfoProto $sessionInfo = this.getSessionInfo();
        result = result * 59 + ($sessionInfo == null ? 43 : $sessionInfo.hashCode());
        return result;
    }

    public String toString() {
        return "DeviceAwareSessionContext(sessionId=" + this.getSessionId() + ", deviceId=" + this.getDeviceId() + ", deviceInfo=" + this.getDeviceInfo() + ", deviceProfile=" + this.getDeviceProfile() + ", sessionInfo=" + this.getSessionInfo() + ", connected=" + this.isConnected() + ")";
    }

    @Override
    public UUID getSessionId() {
        return this.sessionId;
    }

    public TransportDeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public DeviceProfile getDeviceProfile() {
        return this.deviceProfile;
    }

    public void setDeviceProfile(DeviceProfile deviceProfile) {
        this.deviceProfile = deviceProfile;
    }

    public TransportProtos.SessionInfoProto getSessionInfo() {
        return this.sessionInfo;
    }

    public void setSessionInfo(TransportProtos.SessionInfoProto sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }
}

