/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.QueueRoutingInfo;
import org.thingsboard.server.queue.discovery.QueueRoutingInfoService;

@Service
@ConditionalOnExpression(value="'${service.type:null}'=='tb-transport'")
public class TransportQueueRoutingInfoService
implements QueueRoutingInfoService {
    private static final Logger log = LoggerFactory.getLogger(TransportQueueRoutingInfoService.class);
    private final TransportService transportService;

    public TransportQueueRoutingInfoService(@Lazy TransportService transportService) {
        this.transportService = transportService;
    }

    public List<QueueRoutingInfo> getAllQueuesRoutingInfo() {
        TransportProtos.GetAllQueueRoutingInfoRequestMsg msg = TransportProtos.GetAllQueueRoutingInfoRequestMsg.newBuilder().build();
        return this.transportService.getQueueRoutingInfo(msg).stream().map(QueueRoutingInfo::new).collect(Collectors.toList());
    }
}

