/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.auth;

import org.thingsboard.server.common.data.id.DeviceId;

public class DeviceAuthResult {
    private final boolean success;
    private final DeviceId deviceId;
    private final String errorMsg;

    public static DeviceAuthResult of(DeviceId deviceId) {
        return new DeviceAuthResult(true, deviceId, null);
    }

    public static DeviceAuthResult of(String errorMsg) {
        return new DeviceAuthResult(false, null, errorMsg);
    }

    private DeviceAuthResult(boolean success, DeviceId deviceId, String errorMsg) {
        this.success = success;
        this.deviceId = deviceId;
        this.errorMsg = errorMsg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String toString() {
        return "DeviceAuthResult [success=" + this.success + ", deviceId=" + this.deviceId + ", errorMsg=" + this.errorMsg + "]";
    }
}

