/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.TenantRoutingInfo;
import org.thingsboard.server.queue.discovery.TenantRoutingInfoService;

@Service
@ConditionalOnExpression(value="'${service.type:null}'=='tb-transport'")
public class TransportTenantRoutingInfoService
implements TenantRoutingInfoService {
    private static final Logger log = LoggerFactory.getLogger(TransportTenantRoutingInfoService.class);
    private TransportService transportService;

    @Lazy
    @Autowired
    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    public TenantRoutingInfo getRoutingInfo(TenantId tenantId) {
        TransportProtos.GetTenantRoutingInfoRequestMsg msg = TransportProtos.GetTenantRoutingInfoRequestMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).build();
        TransportProtos.GetTenantRoutingInfoResponseMsg routingInfo = this.transportService.getRoutingInfo(msg);
        return new TenantRoutingInfo(tenantId, routingInfo.getIsolatedTbCore(), routingInfo.getIsolatedTbRuleEngine());
    }
}

