/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.adaptor;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.StringUtils;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.kv.AttributeKey;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.msg.kv.AttributesKVMsg;
import org.thingsboard.server.gen.transport.TransportProtos;

public class JsonConverter {
    private static final Gson GSON = new Gson();
    private static final String CAN_T_PARSE_VALUE = "Can't parse value: ";
    private static final String DEVICE_PROPERTY = "device";
    private static boolean isTypeCastEnabled = true;
    private static int maxStringValueLength = 0;

    public static TransportProtos.PostTelemetryMsg convertToTelemetryProto(JsonElement jsonElement) throws JsonSyntaxException {
        TransportProtos.PostTelemetryMsg.Builder builder = TransportProtos.PostTelemetryMsg.newBuilder();
        JsonConverter.convertToTelemetry(jsonElement, System.currentTimeMillis(), null, builder);
        return builder.build();
    }

    private static void convertToTelemetry(JsonElement jsonElement, long systemTs, Map<Long, List<KvEntry>> result, TransportProtos.PostTelemetryMsg.Builder builder) {
        if (jsonElement.isJsonObject()) {
            JsonConverter.parseObject(systemTs, result, builder, jsonElement.getAsJsonObject());
        } else if (jsonElement.isJsonArray()) {
            jsonElement.getAsJsonArray().forEach(je -> {
                if (!je.isJsonObject()) {
                    throw new JsonSyntaxException(CAN_T_PARSE_VALUE + je);
                }
                JsonConverter.parseObject(systemTs, result, builder, je.getAsJsonObject());
            });
        } else {
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + jsonElement);
        }
    }

    private static void parseObject(long systemTs, Map<Long, List<KvEntry>> result, TransportProtos.PostTelemetryMsg.Builder builder, JsonObject jo) {
        if (result != null) {
            JsonConverter.parseObject(result, systemTs, jo);
        } else {
            JsonConverter.parseObject(builder, systemTs, jo);
        }
    }

    public static TransportProtos.ClaimDeviceMsg convertToClaimDeviceProto(DeviceId deviceId, String json) {
        long durationMs = 0L;
        if (json != null && !json.isEmpty()) {
            return JsonConverter.convertToClaimDeviceProto(deviceId, new JsonParser().parse(json));
        }
        return JsonConverter.buildClaimDeviceMsg(deviceId, "", durationMs);
    }

    public static TransportProtos.ClaimDeviceMsg convertToClaimDeviceProto(DeviceId deviceId, JsonElement jsonElement) {
        String secretKey = "";
        long durationMs = 0L;
        if (jsonElement.isJsonObject()) {
            JsonObject jo = jsonElement.getAsJsonObject();
            if (jo.has("secretKey")) {
                secretKey = jo.get("secretKey").getAsString();
            }
            if (jo.has("durationMs")) {
                durationMs = jo.get("durationMs").getAsLong();
            }
        } else {
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + jsonElement);
        }
        return JsonConverter.buildClaimDeviceMsg(deviceId, secretKey, durationMs);
    }

    private static TransportProtos.ClaimDeviceMsg buildClaimDeviceMsg(DeviceId deviceId, String secretKey, long durationMs) {
        TransportProtos.ClaimDeviceMsg.Builder result = TransportProtos.ClaimDeviceMsg.newBuilder();
        return result.setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setSecretKey(secretKey).setDurationMs(durationMs).build();
    }

    public static TransportProtos.PostAttributeMsg convertToAttributesProto(JsonElement jsonObject) throws JsonSyntaxException {
        if (jsonObject.isJsonObject()) {
            TransportProtos.PostAttributeMsg.Builder result = TransportProtos.PostAttributeMsg.newBuilder();
            List<TransportProtos.KeyValueProto> keyValueList = JsonConverter.parseProtoValues(jsonObject.getAsJsonObject());
            result.addAllKv(keyValueList);
            return result.build();
        }
        throw new JsonSyntaxException(CAN_T_PARSE_VALUE + jsonObject);
    }

    public static JsonElement toJson(TransportProtos.ToDeviceRpcRequestMsg msg, boolean includeRequestId) {
        JsonObject result = new JsonObject();
        if (includeRequestId) {
            result.addProperty("id", (Number)msg.getRequestId());
        }
        result.addProperty("method", msg.getMethodName());
        result.add("params", new JsonParser().parse(msg.getParams()));
        return result;
    }

    private static void parseObject(TransportProtos.PostTelemetryMsg.Builder builder, long systemTs, JsonObject jo) {
        if (jo.has("ts") && jo.has("values")) {
            JsonConverter.parseWithTs(builder, jo);
        } else {
            JsonConverter.parseWithoutTs(builder, systemTs, jo);
        }
    }

    private static void parseWithoutTs(TransportProtos.PostTelemetryMsg.Builder request, long systemTs, JsonObject jo) {
        TransportProtos.TsKvListProto.Builder builder = TransportProtos.TsKvListProto.newBuilder();
        builder.setTs(systemTs);
        builder.addAllKv(JsonConverter.parseProtoValues(jo));
        request.addTsKvList(builder.build());
    }

    private static void parseWithTs(TransportProtos.PostTelemetryMsg.Builder request, JsonObject jo) {
        TransportProtos.TsKvListProto.Builder builder = TransportProtos.TsKvListProto.newBuilder();
        builder.setTs(jo.get("ts").getAsLong());
        builder.addAllKv(JsonConverter.parseProtoValues(jo.get("values").getAsJsonObject()));
        request.addTsKvList(builder.build());
    }

    private static List<TransportProtos.KeyValueProto> parseProtoValues(JsonObject valuesObject) {
        ArrayList<TransportProtos.KeyValueProto> result = new ArrayList<TransportProtos.KeyValueProto>();
        for (Map.Entry valueEntry : valuesObject.entrySet()) {
            JsonElement element = (JsonElement)valueEntry.getValue();
            if (element.isJsonPrimitive()) {
                JsonPrimitive value = element.getAsJsonPrimitive();
                if (value.isString()) {
                    if (maxStringValueLength > 0 && value.getAsString().length() > maxStringValueLength) {
                        String message = String.format("String value length [%d] for key [%s] is greater than maximum allowed [%d]", value.getAsString().length(), valueEntry.getKey(), maxStringValueLength);
                        throw new JsonSyntaxException(message);
                    }
                    if (isTypeCastEnabled && NumberUtils.isParsable((String)value.getAsString())) {
                        try {
                            result.add(JsonConverter.buildNumericKeyValueProto(value, (String)valueEntry.getKey()));
                        }
                        catch (RuntimeException th) {
                            result.add(TransportProtos.KeyValueProto.newBuilder().setKey((String)valueEntry.getKey()).setType(TransportProtos.KeyValueType.STRING_V).setStringV(value.getAsString()).build());
                        }
                        continue;
                    }
                    result.add(TransportProtos.KeyValueProto.newBuilder().setKey((String)valueEntry.getKey()).setType(TransportProtos.KeyValueType.STRING_V).setStringV(value.getAsString()).build());
                    continue;
                }
                if (value.isBoolean()) {
                    result.add(TransportProtos.KeyValueProto.newBuilder().setKey((String)valueEntry.getKey()).setType(TransportProtos.KeyValueType.BOOLEAN_V).setBoolV(value.getAsBoolean()).build());
                    continue;
                }
                if (value.isNumber()) {
                    result.add(JsonConverter.buildNumericKeyValueProto(value, (String)valueEntry.getKey()));
                    continue;
                }
                if (value.isJsonNull()) continue;
                throw new JsonSyntaxException(CAN_T_PARSE_VALUE + value);
            }
            if (element.isJsonNull()) continue;
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + element);
        }
        return result;
    }

    private static TransportProtos.KeyValueProto buildNumericKeyValueProto(JsonPrimitive value, String key) {
        if (value.getAsString().contains(".")) {
            return TransportProtos.KeyValueProto.newBuilder().setKey(key).setType(TransportProtos.KeyValueType.DOUBLE_V).setDoubleV(value.getAsDouble()).build();
        }
        try {
            long longValue = Long.parseLong(value.getAsString());
            return TransportProtos.KeyValueProto.newBuilder().setKey(key).setType(TransportProtos.KeyValueType.LONG_V).setLongV(longValue).build();
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException("Big integer values are not supported!");
        }
    }

    public static TransportProtos.ToServerRpcRequestMsg convertToServerRpcRequest(JsonElement json, int requestId) throws JsonSyntaxException {
        JsonObject object = json.getAsJsonObject();
        return TransportProtos.ToServerRpcRequestMsg.newBuilder().setRequestId(requestId).setMethodName(object.get("method").getAsString()).setParams(GSON.toJson(object.get("params"))).build();
    }

    private static void parseNumericValue(List<KvEntry> result, Map.Entry<String, JsonElement> valueEntry, JsonPrimitive value) {
        if (value.getAsString().contains(".")) {
            result.add((KvEntry)new DoubleDataEntry(valueEntry.getKey(), Double.valueOf(value.getAsDouble())));
        } else {
            try {
                long longValue = Long.parseLong(value.getAsString());
                result.add((KvEntry)new LongDataEntry(valueEntry.getKey(), Long.valueOf(longValue)));
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException("Big integer values are not supported!");
            }
        }
    }

    public static JsonObject toJson(TransportProtos.GetAttributeResponseMsg payload) {
        JsonObject attrObject;
        JsonObject result = new JsonObject();
        if (payload.getClientAttributeListCount() > 0) {
            attrObject = new JsonObject();
            payload.getClientAttributeListList().forEach(JsonConverter.addToObjectFromProto(attrObject));
            result.add("client", (JsonElement)attrObject);
        }
        if (payload.getSharedAttributeListCount() > 0) {
            attrObject = new JsonObject();
            payload.getSharedAttributeListList().forEach(JsonConverter.addToObjectFromProto(attrObject));
            result.add("shared", (JsonElement)attrObject);
        }
        if (payload.getDeletedAttributeKeysCount() > 0) {
            attrObject = new JsonArray();
            payload.getDeletedAttributeKeysList().forEach(arg_0 -> ((JsonArray)attrObject).add(arg_0));
            result.add("deleted", (JsonElement)attrObject);
        }
        return result;
    }

    public static JsonElement toJson(TransportProtos.AttributeUpdateNotificationMsg payload) {
        JsonObject result = new JsonObject();
        if (payload.getSharedUpdatedCount() > 0) {
            payload.getSharedUpdatedList().forEach(JsonConverter.addToObjectFromProto(result));
        }
        if (payload.getSharedDeletedCount() > 0) {
            JsonArray attrObject = new JsonArray();
            payload.getSharedDeletedList().forEach(arg_0 -> ((JsonArray)attrObject).add(arg_0));
            result.add("deleted", (JsonElement)attrObject);
        }
        return result;
    }

    public static JsonObject toJson(AttributesKVMsg payload, boolean asMap) {
        JsonObject attrObject;
        JsonObject result = new JsonObject();
        if (asMap) {
            if (!payload.getClientAttributes().isEmpty()) {
                attrObject = new JsonObject();
                payload.getClientAttributes().forEach(JsonConverter.addToObject(attrObject));
                result.add("client", (JsonElement)attrObject);
            }
            if (!payload.getSharedAttributes().isEmpty()) {
                attrObject = new JsonObject();
                payload.getSharedAttributes().forEach(JsonConverter.addToObject(attrObject));
                result.add("shared", (JsonElement)attrObject);
            }
        } else {
            payload.getClientAttributes().forEach(JsonConverter.addToObject(result));
            payload.getSharedAttributes().forEach(JsonConverter.addToObject(result));
        }
        if (!payload.getDeletedAttributes().isEmpty()) {
            attrObject = new JsonArray();
            payload.getDeletedAttributes().forEach(JsonConverter.addToObject((JsonArray)attrObject));
            result.add("deleted", (JsonElement)attrObject);
        }
        return result;
    }

    public static JsonObject getJsonObjectForGateway(String deviceName, TransportProtos.GetAttributeResponseMsg responseMsg) {
        JsonObject result = new JsonObject();
        result.addProperty("id", (Number)responseMsg.getRequestId());
        result.addProperty(DEVICE_PROPERTY, deviceName);
        if (responseMsg.getClientAttributeListCount() > 0) {
            JsonConverter.addValues(result, responseMsg.getClientAttributeListList());
        }
        if (responseMsg.getSharedAttributeListCount() > 0) {
            JsonConverter.addValues(result, responseMsg.getSharedAttributeListList());
        }
        return result;
    }

    public static JsonObject getJsonObjectForGateway(String deviceName, TransportProtos.AttributeUpdateNotificationMsg notificationMsg) {
        JsonObject result = new JsonObject();
        result.addProperty(DEVICE_PROPERTY, deviceName);
        result.add("data", JsonConverter.toJson(notificationMsg));
        return result;
    }

    private static void addValues(JsonObject result, List<TransportProtos.TsKvProto> kvList) {
        if (kvList.size() == 1) {
            JsonConverter.addValueToJson(result, "value", kvList.get(0).getKv());
        } else {
            JsonObject values;
            if (result.has("values")) {
                values = result.get("values").getAsJsonObject();
            } else {
                values = new JsonObject();
                result.add("values", (JsonElement)values);
            }
            kvList.forEach(value -> JsonConverter.addValueToJson(values, value.getKv().getKey(), value.getKv()));
        }
    }

    private static void addValueToJson(JsonObject json, String name, TransportProtos.KeyValueProto entry) {
        switch (entry.getType()) {
            case BOOLEAN_V: {
                json.addProperty(name, Boolean.valueOf(entry.getBoolV()));
                break;
            }
            case STRING_V: {
                json.addProperty(name, entry.getStringV());
                break;
            }
            case DOUBLE_V: {
                json.addProperty(name, (Number)entry.getDoubleV());
                break;
            }
            case LONG_V: {
                json.addProperty(name, (Number)entry.getLongV());
            }
        }
    }

    private static Consumer<AttributeKey> addToObject(JsonArray result) {
        return key -> result.add(key.getAttributeKey());
    }

    private static Consumer<TransportProtos.TsKvProto> addToObjectFromProto(JsonObject result) {
        return de -> {
            JsonPrimitive value;
            switch (de.getKv().getType()) {
                case BOOLEAN_V: {
                    value = new JsonPrimitive(Boolean.valueOf(de.getKv().getBoolV()));
                    break;
                }
                case DOUBLE_V: {
                    value = new JsonPrimitive((Number)de.getKv().getDoubleV());
                    break;
                }
                case LONG_V: {
                    value = new JsonPrimitive((Number)de.getKv().getLongV());
                    break;
                }
                case STRING_V: {
                    value = new JsonPrimitive(de.getKv().getStringV());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type: " + (Object)((Object)de.getKv().getType()));
                }
            }
            result.add(de.getKv().getKey(), (JsonElement)value);
        };
    }

    private static Consumer<AttributeKvEntry> addToObject(JsonObject result) {
        return de -> {
            JsonPrimitive value;
            switch (de.getDataType()) {
                case BOOLEAN: {
                    value = new JsonPrimitive((Boolean)de.getBooleanValue().get());
                    break;
                }
                case DOUBLE: {
                    value = new JsonPrimitive((Number)de.getDoubleValue().get());
                    break;
                }
                case LONG: {
                    value = new JsonPrimitive((Number)de.getLongValue().get());
                    break;
                }
                case STRING: {
                    value = new JsonPrimitive((String)de.getStrValue().get());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type: " + de.getDataType());
                }
            }
            result.add(de.getKey(), (JsonElement)value);
        };
    }

    public static JsonElement toJson(TransportProtos.ToServerRpcResponseMsg msg) {
        if (StringUtils.isEmpty((Object)msg.getError())) {
            return new JsonParser().parse(msg.getPayload());
        }
        JsonObject errorMsg = new JsonObject();
        errorMsg.addProperty("error", msg.getError());
        return errorMsg;
    }

    public static JsonElement toErrorJson(String errorMsg) {
        JsonObject error = new JsonObject();
        error.addProperty("error", errorMsg);
        return error;
    }

    public static JsonElement toGatewayJson(String deviceName, TransportProtos.ToDeviceRpcRequestMsg rpcRequest) {
        JsonObject result = new JsonObject();
        result.addProperty(DEVICE_PROPERTY, deviceName);
        result.add("data", JsonConverter.toJson(rpcRequest, true));
        return result;
    }

    public static Set<AttributeKvEntry> convertToAttributes(JsonElement element) {
        HashSet<AttributeKvEntry> result = new HashSet<AttributeKvEntry>();
        long ts = System.currentTimeMillis();
        result.addAll(JsonConverter.parseValues(element.getAsJsonObject()).stream().map(kv -> new BaseAttributeKvEntry(kv, ts)).collect(Collectors.toList()));
        return result;
    }

    private static List<KvEntry> parseValues(JsonObject valuesObject) {
        ArrayList<KvEntry> result = new ArrayList<KvEntry>();
        for (Map.Entry valueEntry : valuesObject.entrySet()) {
            JsonElement element = (JsonElement)valueEntry.getValue();
            if (element.isJsonPrimitive()) {
                JsonPrimitive value = element.getAsJsonPrimitive();
                if (value.isString()) {
                    if (maxStringValueLength > 0 && value.getAsString().length() > maxStringValueLength) {
                        String message = String.format("String value length [%d] for key [%s] is greater than maximum allowed [%d]", value.getAsString().length(), valueEntry.getKey(), maxStringValueLength);
                        throw new JsonSyntaxException(message);
                    }
                    if (isTypeCastEnabled && NumberUtils.isParsable((String)value.getAsString())) {
                        try {
                            JsonConverter.parseNumericValue(result, valueEntry, value);
                        }
                        catch (RuntimeException th) {
                            result.add((KvEntry)new StringDataEntry((String)valueEntry.getKey(), value.getAsString()));
                        }
                        continue;
                    }
                    result.add((KvEntry)new StringDataEntry((String)valueEntry.getKey(), value.getAsString()));
                    continue;
                }
                if (value.isBoolean()) {
                    result.add((KvEntry)new BooleanDataEntry((String)valueEntry.getKey(), Boolean.valueOf(value.getAsBoolean())));
                    continue;
                }
                if (value.isNumber()) {
                    JsonConverter.parseNumericValue(result, valueEntry, value);
                    continue;
                }
                throw new JsonSyntaxException(CAN_T_PARSE_VALUE + value);
            }
            throw new JsonSyntaxException(CAN_T_PARSE_VALUE + element);
        }
        return result;
    }

    public static Map<Long, List<KvEntry>> convertToTelemetry(JsonElement jsonElement, long systemTs) throws JsonSyntaxException {
        HashMap<Long, List<KvEntry>> result = new HashMap<Long, List<KvEntry>>();
        JsonConverter.convertToTelemetry(jsonElement, systemTs, result, null);
        return result;
    }

    private static void parseObject(Map<Long, List<KvEntry>> result, long systemTs, JsonObject jo) {
        if (jo.has("ts") && jo.has("values")) {
            JsonConverter.parseWithTs(result, jo);
        } else {
            JsonConverter.parseWithoutTs(result, systemTs, jo);
        }
    }

    private static void parseWithoutTs(Map<Long, List<KvEntry>> result, long systemTs, JsonObject jo) {
        for (KvEntry entry : JsonConverter.parseValues(jo)) {
            result.computeIfAbsent(systemTs, tmp -> new ArrayList()).add(entry);
        }
    }

    public static void parseWithTs(Map<Long, List<KvEntry>> result, JsonObject jo) {
        long ts = jo.get("ts").getAsLong();
        JsonObject valuesObject = jo.get("values").getAsJsonObject();
        for (KvEntry entry : JsonConverter.parseValues(valuesObject)) {
            result.computeIfAbsent(ts, tmp -> new ArrayList()).add(entry);
        }
    }

    public static void setTypeCastEnabled(boolean enabled) {
        isTypeCastEnabled = enabled;
    }

    public static void setMaxStringValueLength(int length) {
        maxStringValueLength = length;
    }
}

