/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.session;

import java.beans.ConstructorProperties;
import java.util.UUID;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.msg.session.SessionContext;
import org.thingsboard.server.gen.transport.TransportProtos;

public abstract class DeviceAwareSessionContext
implements SessionContext {
    protected final UUID sessionId;
    private volatile DeviceId deviceId;
    private volatile TransportProtos.DeviceInfoProto deviceInfo;

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceInfo(TransportProtos.DeviceInfoProto deviceInfo) {
        this.deviceInfo = deviceInfo;
        this.deviceId = new DeviceId(new UUID(deviceInfo.getDeviceIdMSB(), deviceInfo.getDeviceIdLSB()));
    }

    public boolean isConnected() {
        return this.deviceInfo != null;
    }

    @ConstructorProperties(value={"sessionId"})
    public DeviceAwareSessionContext(UUID sessionId) {
        this.sessionId = sessionId;
    }

    public void setDeviceId(DeviceId deviceId) {
        this.deviceId = deviceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceAwareSessionContext)) {
            return false;
        }
        DeviceAwareSessionContext other = (DeviceAwareSessionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$sessionId = this.getSessionId();
        UUID other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        TransportProtos.DeviceInfoProto this$deviceInfo = this.getDeviceInfo();
        TransportProtos.DeviceInfoProto other$deviceInfo = other.getDeviceInfo();
        return !(this$deviceInfo == null ? other$deviceInfo != null : !((Object)this$deviceInfo).equals(other$deviceInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceAwareSessionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        TransportProtos.DeviceInfoProto $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : ((Object)$deviceInfo).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceAwareSessionContext(sessionId=" + this.getSessionId() + ", deviceId=" + this.getDeviceId() + ", deviceInfo=" + this.getDeviceInfo() + ")";
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public TransportProtos.DeviceInfoProto getDeviceInfo() {
        return this.deviceInfo;
    }
}

