/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import java.util.concurrent.ScheduledFuture;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.gen.transport.TransportProtos;

class SessionMetaData {
    private final TransportProtos.SessionInfoProto sessionInfo;
    private final TransportProtos.SessionType sessionType;
    private final SessionMsgListener listener;
    private ScheduledFuture scheduledFuture;
    private volatile long lastActivityTime;
    private volatile boolean subscribedToAttributes;
    private volatile boolean subscribedToRPC;

    SessionMetaData(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SessionType sessionType, SessionMsgListener listener) {
        this.sessionInfo = sessionInfo;
        this.sessionType = sessionType;
        this.listener = listener;
        this.lastActivityTime = System.currentTimeMillis();
        this.scheduledFuture = null;
    }

    void updateLastActivityTime() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    void setScheduledFuture(ScheduledFuture scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public ScheduledFuture getScheduledFuture() {
        return this.scheduledFuture;
    }

    public boolean hasScheduledFuture() {
        return null != this.scheduledFuture;
    }

    public TransportProtos.SessionInfoProto getSessionInfo() {
        return this.sessionInfo;
    }

    public TransportProtos.SessionType getSessionType() {
        return this.sessionType;
    }

    public SessionMsgListener getListener() {
        return this.listener;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public boolean isSubscribedToAttributes() {
        return this.subscribedToAttributes;
    }

    public boolean isSubscribedToRPC() {
        return this.subscribedToRPC;
    }

    public void setLastActivityTime(long lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
    }

    public void setSubscribedToAttributes(boolean subscribedToAttributes) {
        this.subscribedToAttributes = subscribedToAttributes;
    }

    public void setSubscribedToRPC(boolean subscribedToRPC) {
        this.subscribedToRPC = subscribedToRPC;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionMetaData)) {
            return false;
        }
        SessionMetaData other = (SessionMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransportProtos.SessionInfoProto this$sessionInfo = this.getSessionInfo();
        TransportProtos.SessionInfoProto other$sessionInfo = other.getSessionInfo();
        if (this$sessionInfo == null ? other$sessionInfo != null : !((Object)this$sessionInfo).equals(other$sessionInfo)) {
            return false;
        }
        TransportProtos.SessionType this$sessionType = this.getSessionType();
        TransportProtos.SessionType other$sessionType = other.getSessionType();
        if (this$sessionType == null ? other$sessionType != null : !((Object)((Object)this$sessionType)).equals((Object)other$sessionType)) {
            return false;
        }
        SessionMsgListener this$listener = this.getListener();
        SessionMsgListener other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        ScheduledFuture this$scheduledFuture = this.getScheduledFuture();
        ScheduledFuture other$scheduledFuture = other.getScheduledFuture();
        if (this$scheduledFuture == null ? other$scheduledFuture != null : !this$scheduledFuture.equals(other$scheduledFuture)) {
            return false;
        }
        if (this.getLastActivityTime() != other.getLastActivityTime()) {
            return false;
        }
        if (this.isSubscribedToAttributes() != other.isSubscribedToAttributes()) {
            return false;
        }
        return this.isSubscribedToRPC() == other.isSubscribedToRPC();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransportProtos.SessionInfoProto $sessionInfo = this.getSessionInfo();
        result = result * 59 + ($sessionInfo == null ? 43 : ((Object)$sessionInfo).hashCode());
        TransportProtos.SessionType $sessionType = this.getSessionType();
        result = result * 59 + ($sessionType == null ? 43 : ((Object)((Object)$sessionType)).hashCode());
        SessionMsgListener $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        ScheduledFuture $scheduledFuture = this.getScheduledFuture();
        result = result * 59 + ($scheduledFuture == null ? 43 : $scheduledFuture.hashCode());
        long $lastActivityTime = this.getLastActivityTime();
        result = result * 59 + (int)($lastActivityTime >>> 32 ^ $lastActivityTime);
        result = result * 59 + (this.isSubscribedToAttributes() ? 79 : 97);
        result = result * 59 + (this.isSubscribedToRPC() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SessionMetaData(sessionInfo=" + this.getSessionInfo() + ", sessionType=" + (Object)((Object)this.getSessionType()) + ", listener=" + this.getListener() + ", scheduledFuture=" + this.getScheduledFuture() + ", lastActivityTime=" + this.getLastActivityTime() + ", subscribedToAttributes=" + this.isSubscribedToAttributes() + ", subscribedToRPC=" + this.isSubscribedToRPC() + ")";
    }
}

