/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport.service;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.tools.TbRateLimits;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.service.SessionMetaData;
import org.thingsboard.server.gen.transport.TransportProtos;

public abstract class AbstractTransportService
implements TransportService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTransportService.class);
    @Value(value="${transport.rate_limits.enabled}")
    private boolean rateLimitEnabled;
    @Value(value="${transport.rate_limits.tenant}")
    private String perTenantLimitsConf;
    @Value(value="${transport.rate_limits.device}")
    private String perDevicesLimitsConf;
    @Value(value="${transport.sessions.inactivity_timeout}")
    private long sessionInactivityTimeout;
    @Value(value="${transport.sessions.report_timeout}")
    private long sessionReportTimeout;
    protected ScheduledExecutorService schedulerExecutor;
    protected ExecutorService transportCallbackExecutor;
    private ConcurrentMap<UUID, SessionMetaData> sessions = new ConcurrentHashMap<UUID, SessionMetaData>();
    private ConcurrentMap<TenantId, TbRateLimits> perTenantLimits = new ConcurrentHashMap<TenantId, TbRateLimits>();
    private ConcurrentMap<DeviceId, TbRateLimits> perDeviceLimits = new ConcurrentHashMap<DeviceId, TbRateLimits>();

    @Override
    public void registerAsyncSession(TransportProtos.SessionInfoProto sessionInfo, SessionMsgListener listener) {
        this.sessions.putIfAbsent(this.toId(sessionInfo), new SessionMetaData(sessionInfo, TransportProtos.SessionType.ASYNC, listener));
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SessionEventMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.reportActivityInternal(sessionInfo);
            this.doProcess(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.PostTelemetryMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.reportActivityInternal(sessionInfo);
            this.doProcess(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.PostAttributeMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.reportActivityInternal(sessionInfo);
            this.doProcess(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.GetAttributeRequestMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.reportActivityInternal(sessionInfo);
            this.doProcess(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SubscribeToAttributeUpdatesMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            SessionMetaData sessionMetaData = this.reportActivityInternal(sessionInfo);
            sessionMetaData.setSubscribedToAttributes(!msg.getUnsubscribe());
            this.doProcess(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.SubscribeToRPCMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            SessionMetaData sessionMetaData = this.reportActivityInternal(sessionInfo);
            sessionMetaData.setSubscribedToRPC(!msg.getUnsubscribe());
            this.doProcess(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToDeviceRpcResponseMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.reportActivityInternal(sessionInfo);
            this.doProcess(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToServerRpcRequestMsg msg, TransportServiceCallback<Void> callback) {
        if (this.checkLimits(sessionInfo, msg, callback)) {
            this.reportActivityInternal(sessionInfo);
            this.doProcess(sessionInfo, msg, callback);
        }
    }

    @Override
    public void process(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ClaimDeviceMsg msg, TransportServiceCallback<Void> callback) {
        this.registerClaimingInfo(sessionInfo, msg, callback);
    }

    @Override
    public void reportActivity(TransportProtos.SessionInfoProto sessionInfo) {
        this.reportActivityInternal(sessionInfo);
    }

    protected abstract void doProcess(TransportProtos.SessionInfoProto var1, TransportProtos.SessionEventMsg var2, TransportServiceCallback<Void> var3);

    protected abstract void doProcess(TransportProtos.SessionInfoProto var1, TransportProtos.PostTelemetryMsg var2, TransportServiceCallback<Void> var3);

    protected abstract void doProcess(TransportProtos.SessionInfoProto var1, TransportProtos.PostAttributeMsg var2, TransportServiceCallback<Void> var3);

    protected abstract void doProcess(TransportProtos.SessionInfoProto var1, TransportProtos.GetAttributeRequestMsg var2, TransportServiceCallback<Void> var3);

    protected abstract void doProcess(TransportProtos.SessionInfoProto var1, TransportProtos.SubscribeToAttributeUpdatesMsg var2, TransportServiceCallback<Void> var3);

    protected abstract void doProcess(TransportProtos.SessionInfoProto var1, TransportProtos.SubscribeToRPCMsg var2, TransportServiceCallback<Void> var3);

    protected abstract void doProcess(TransportProtos.SessionInfoProto var1, TransportProtos.ToDeviceRpcResponseMsg var2, TransportServiceCallback<Void> var3);

    protected abstract void doProcess(TransportProtos.SessionInfoProto var1, TransportProtos.ToServerRpcRequestMsg var2, TransportServiceCallback<Void> var3);

    protected abstract void registerClaimingInfo(TransportProtos.SessionInfoProto var1, TransportProtos.ClaimDeviceMsg var2, TransportServiceCallback<Void> var3);

    private SessionMetaData reportActivityInternal(TransportProtos.SessionInfoProto sessionInfo) {
        UUID sessionId = this.toId(sessionInfo);
        SessionMetaData sessionMetaData = (SessionMetaData)this.sessions.get(sessionId);
        if (sessionMetaData != null) {
            sessionMetaData.updateLastActivityTime();
        }
        return sessionMetaData;
    }

    private void checkInactivityAndReportActivity() {
        long expTime = System.currentTimeMillis() - this.sessionInactivityTimeout;
        this.sessions.forEach((uuid, sessionMD) -> {
            if (sessionMD.getLastActivityTime() < expTime) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Session has expired due to last activity time: {}", (Object)this.toId(sessionMD.getSessionInfo()), (Object)sessionMD.getLastActivityTime());
                }
                this.process(sessionMD.getSessionInfo(), AbstractTransportService.getSessionEventMsg(TransportProtos.SessionEvent.CLOSED), null);
                this.sessions.remove(uuid);
                sessionMD.getListener().onRemoteSessionCloseCommand(TransportProtos.SessionCloseNotificationProto.getDefaultInstance());
            } else {
                this.process(sessionMD.getSessionInfo(), TransportProtos.SubscriptionInfoProto.newBuilder().setAttributeSubscription(sessionMD.isSubscribedToAttributes()).setRpcSubscription(sessionMD.isSubscribedToRPC()).setLastActivityTime(sessionMD.getLastActivityTime()).build(), null);
            }
        });
    }

    @Override
    public void registerSyncSession(TransportProtos.SessionInfoProto sessionInfo, SessionMsgListener listener, long timeout) {
        SessionMetaData currentSession = new SessionMetaData(sessionInfo, TransportProtos.SessionType.SYNC, listener);
        this.sessions.putIfAbsent(this.toId(sessionInfo), currentSession);
        ScheduledFuture<?> executorFuture = this.schedulerExecutor.schedule(() -> {
            listener.onRemoteSessionCloseCommand(TransportProtos.SessionCloseNotificationProto.getDefaultInstance());
            this.deregisterSession(sessionInfo);
        }, timeout, TimeUnit.MILLISECONDS);
        currentSession.setScheduledFuture(executorFuture);
    }

    @Override
    public void deregisterSession(TransportProtos.SessionInfoProto sessionInfo) {
        SessionMetaData currentSession = (SessionMetaData)this.sessions.get(this.toId(sessionInfo));
        if (currentSession != null && currentSession.hasScheduledFuture()) {
            log.debug("Stopping scheduler to avoid resending response if request has been ack.");
            currentSession.getScheduledFuture().cancel(false);
        }
        this.sessions.remove(this.toId(sessionInfo));
    }

    @Override
    public boolean checkLimits(TransportProtos.SessionInfoProto sessionInfo, Object msg, TransportServiceCallback<Void> callback) {
        if (log.isTraceEnabled()) {
            log.trace("[{}] Processing msg: {}", (Object)this.toId(sessionInfo), msg);
        }
        if (!this.rateLimitEnabled) {
            return true;
        }
        TenantId tenantId = new TenantId(new UUID(sessionInfo.getTenantIdMSB(), sessionInfo.getTenantIdLSB()));
        TbRateLimits rateLimits = this.perTenantLimits.computeIfAbsent(tenantId, id -> new TbRateLimits(this.perTenantLimitsConf));
        if (!rateLimits.tryConsume()) {
            if (callback != null) {
                callback.onError((Throwable)new TbRateLimitsException(EntityType.TENANT));
            }
            if (log.isTraceEnabled()) {
                log.trace("[{}][{}] Tenant level rate limit detected: {}", new Object[]{this.toId(sessionInfo), tenantId, msg});
            }
            return false;
        }
        DeviceId deviceId = new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
        rateLimits = this.perDeviceLimits.computeIfAbsent(deviceId, id -> new TbRateLimits(this.perDevicesLimitsConf));
        if (!rateLimits.tryConsume()) {
            if (callback != null) {
                callback.onError((Throwable)new TbRateLimitsException(EntityType.DEVICE));
            }
            if (log.isTraceEnabled()) {
                log.trace("[{}][{}] Device level rate limit detected: {}", new Object[]{this.toId(sessionInfo), deviceId, msg});
            }
            return false;
        }
        return true;
    }

    protected void processToTransportMsg(TransportProtos.DeviceActorToTransportMsg toSessionMsg) {
        UUID sessionId = new UUID(toSessionMsg.getSessionIdMSB(), toSessionMsg.getSessionIdLSB());
        SessionMetaData md = (SessionMetaData)this.sessions.get(sessionId);
        if (md != null) {
            SessionMsgListener listener = md.getListener();
            this.transportCallbackExecutor.submit(() -> {
                if (toSessionMsg.hasGetAttributesResponse()) {
                    listener.onGetAttributesResponse(toSessionMsg.getGetAttributesResponse());
                }
                if (toSessionMsg.hasAttributeUpdateNotification()) {
                    listener.onAttributeUpdate(toSessionMsg.getAttributeUpdateNotification());
                }
                if (toSessionMsg.hasSessionCloseNotification()) {
                    listener.onRemoteSessionCloseCommand(toSessionMsg.getSessionCloseNotification());
                }
                if (toSessionMsg.hasToDeviceRequest()) {
                    listener.onToDeviceRpcRequest(toSessionMsg.getToDeviceRequest());
                }
                if (toSessionMsg.hasToServerResponse()) {
                    listener.onToServerRpcResponse(toSessionMsg.getToServerResponse());
                }
            });
            if (md.getSessionType() == TransportProtos.SessionType.SYNC) {
                this.deregisterSession(md.getSessionInfo());
            }
        } else {
            log.debug("[{}] Missing session.", (Object)sessionId);
        }
    }

    protected UUID toId(TransportProtos.SessionInfoProto sessionInfo) {
        return new UUID(sessionInfo.getSessionIdMSB(), sessionInfo.getSessionIdLSB());
    }

    protected String getRoutingKey(TransportProtos.SessionInfoProto sessionInfo) {
        return new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()).toString();
    }

    public void init() {
        if (this.rateLimitEnabled) {
            new TbRateLimits(this.perTenantLimitsConf);
            new TbRateLimits(this.perDevicesLimitsConf);
        }
        this.schedulerExecutor = Executors.newSingleThreadScheduledExecutor();
        this.transportCallbackExecutor = Executors.newWorkStealingPool(20);
        this.schedulerExecutor.scheduleAtFixedRate(this::checkInactivityAndReportActivity, this.sessionReportTimeout, this.sessionReportTimeout, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        if (this.rateLimitEnabled) {
            this.perTenantLimits.clear();
            this.perDeviceLimits.clear();
        }
        if (this.schedulerExecutor != null) {
            this.schedulerExecutor.shutdownNow();
        }
        if (this.transportCallbackExecutor != null) {
            this.transportCallbackExecutor.shutdownNow();
        }
    }

    public static TransportProtos.SessionEventMsg getSessionEventMsg(TransportProtos.SessionEvent event) {
        return TransportProtos.SessionEventMsg.newBuilder().setSessionType(TransportProtos.SessionType.ASYNC).setEvent(event).build();
    }
}

