/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.kafka.TbNodeIdProvider;

public class TransportContext {
    private static final Logger log = LoggerFactory.getLogger(TransportContext.class);
    protected final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private TransportService transportService;
    @Autowired
    private TbNodeIdProvider nodeIdProvider;
    private ExecutorService executor;

    @PostConstruct
    public void init() {
        this.executor = Executors.newCachedThreadPool();
    }

    @PreDestroy
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public String getNodeId() {
        return this.nodeIdProvider.getNodeId();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public TransportService getTransportService() {
        return this.transportService;
    }

    public TbNodeIdProvider getNodeIdProvider() {
        return this.nodeIdProvider;
    }

    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    public void setNodeIdProvider(TbNodeIdProvider nodeIdProvider) {
        this.nodeIdProvider = nodeIdProvider;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransportContext)) {
            return false;
        }
        TransportContext other = (TransportContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        TransportService this$transportService = this.getTransportService();
        TransportService other$transportService = other.getTransportService();
        if (this$transportService == null ? other$transportService != null : !this$transportService.equals(other$transportService)) {
            return false;
        }
        TbNodeIdProvider this$nodeIdProvider = this.getNodeIdProvider();
        TbNodeIdProvider other$nodeIdProvider = other.getNodeIdProvider();
        if (this$nodeIdProvider == null ? other$nodeIdProvider != null : !this$nodeIdProvider.equals(other$nodeIdProvider)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransportContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        TransportService $transportService = this.getTransportService();
        result = result * 59 + ($transportService == null ? 43 : $transportService.hashCode());
        TbNodeIdProvider $nodeIdProvider = this.getNodeIdProvider();
        result = result * 59 + ($nodeIdProvider == null ? 43 : $nodeIdProvider.hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    public String toString() {
        return "TransportContext(mapper=" + this.getMapper() + ", transportService=" + this.getTransportService() + ", nodeIdProvider=" + this.getNodeIdProvider() + ", executor=" + this.getExecutor() + ")";
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }
}

