/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.session;

import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduledTask.class);
    private ListenableFuture<?> scheduledFuture;
    private boolean stopped = false;

    public void init(AsyncCallable<Void> task, long delayMs, ScheduledExecutorService scheduler) {
        this.schedule(task, delayMs, scheduler);
    }

    private void schedule(AsyncCallable<Void> task, long delayMs, ScheduledExecutorService scheduler) {
        this.scheduledFuture = Futures.scheduleAsync(() -> {
            if (this.stopped) {
                return Futures.immediateCancelledFuture();
            }
            try {
                return task.call();
            }
            catch (Throwable t) {
                log.error("Unhandled error in scheduled task", t);
                return Futures.immediateFailedFuture((Throwable)t);
            }
        }, (long)delayMs, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)scheduler);
        if (!this.stopped) {
            this.scheduledFuture.addListener(() -> this.schedule(task, delayMs, scheduler), MoreExecutors.directExecutor());
        }
    }

    public void cancel() {
        this.stopped = true;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Generated
    public ScheduledTask() {
    }

    @Generated
    public ListenableFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    @Generated
    public boolean isStopped() {
        return this.stopped;
    }

    @Generated
    public void setScheduledFuture(ListenableFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    @Generated
    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledTask)) {
            return false;
        }
        ScheduledTask other = (ScheduledTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStopped() != other.isStopped()) {
            return false;
        }
        ListenableFuture<?> this$scheduledFuture = this.getScheduledFuture();
        ListenableFuture<?> other$scheduledFuture = other.getScheduledFuture();
        return !(this$scheduledFuture == null ? other$scheduledFuture != null : !this$scheduledFuture.equals(other$scheduledFuture));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScheduledTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStopped() ? 79 : 97);
        ListenableFuture<?> $scheduledFuture = this.getScheduledFuture();
        result = result * 59 + ($scheduledFuture == null ? 43 : $scheduledFuture.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScheduledTask(scheduledFuture=" + String.valueOf(this.getScheduledFuture()) + ", stopped=" + this.isStopped() + ")";
    }
}

