/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.service;

import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.TbTransportService;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.transport.snmp.SnmpCommunicationSpec;
import org.thingsboard.server.common.data.transport.snmp.SnmpMapping;
import org.thingsboard.server.common.data.transport.snmp.SnmpMethod;
import org.thingsboard.server.common.data.transport.snmp.config.RepeatingQueryingSnmpCommunicationConfig;
import org.thingsboard.server.common.data.transport.snmp.config.SnmpCommunicationConfig;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbSnmpTransportComponent;
import org.thingsboard.server.transport.snmp.SnmpTransportContext;
import org.thingsboard.server.transport.snmp.service.PduService;
import org.thingsboard.server.transport.snmp.session.DeviceSessionContext;
import org.thingsboard.server.transport.snmp.session.ScheduledTask;

@TbSnmpTransportComponent
@Service
public class SnmpTransportService
implements TbTransportService,
CommandResponder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnmpTransportService.class);
    private final TransportService transportService;
    private final PduService pduService;
    @Autowired
    @Lazy
    private SnmpTransportContext transportContext;
    private Snmp snmp;
    private ListeningScheduledExecutorService scheduler;
    private ExecutorService executor;
    private final Map<SnmpCommunicationSpec, ResponseDataMapper> responseDataMappers = new EnumMap<SnmpCommunicationSpec, ResponseDataMapper>(SnmpCommunicationSpec.class);
    private final Map<SnmpCommunicationSpec, ResponseProcessor> responseProcessors = new EnumMap<SnmpCommunicationSpec, ResponseProcessor>(SnmpCommunicationSpec.class);
    @Value(value="${transport.snmp.bind_port:0}")
    private Integer snmpBindPort;
    @Value(value="${transport.snmp.bind_address:0.0.0.0}")
    private String snmpBindAddress;
    @Value(value="${transport.snmp.response_processing.parallelism_level:4}")
    private int responseProcessingThreadPoolSize;
    @Value(value="${transport.snmp.scheduler_thread_pool_size:4}")
    private int schedulerThreadPoolSize;
    @Value(value="${transport.snmp.underlying_protocol}")
    private String snmpUnderlyingProtocol;
    @Value(value="${transport.snmp.request_chunk_delay_ms:100}")
    private int requestChunkDelayMs;

    @PostConstruct
    private void init() throws IOException {
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)ThingsBoardExecutors.newScheduledThreadPool((int)this.schedulerThreadPoolSize, (String)"snmp-querying"));
        this.executor = ThingsBoardExecutors.newWorkStealingPool((int)this.responseProcessingThreadPoolSize, (String)"snmp-response-processing");
        this.initializeSnmp();
        this.configureResponseDataMappers();
        this.configureResponseProcessors();
        log.info("SNMP transport service initialized");
    }

    @PreDestroy
    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    private void initializeSnmp() throws IOException {
        DefaultUdpTransportMapping transportMapping = switch (this.snmpUnderlyingProtocol) {
            case "udp" -> new DefaultUdpTransportMapping(new UdpAddress(InetAddress.getByName(this.snmpBindAddress), this.snmpBindPort.intValue()));
            case "tcp" -> new DefaultTcpTransportMapping(new TcpAddress(InetAddress.getByName(this.snmpBindAddress), this.snmpBindPort.intValue()));
            default -> throw new IllegalArgumentException("Underlying protocol " + this.snmpUnderlyingProtocol + " for SNMP is not supported");
        };
        this.snmp = new Snmp((TransportMapping)transportMapping);
        this.snmp.addNotificationListener((TransportMapping)transportMapping, transportMapping.getListenAddress(), (CommandResponder)this);
        this.snmp.listen();
        SecurityProtocols.getInstance().addPredefinedProtocolSet(SecurityProtocols.SecurityProtocolSet.maxCompatibility);
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
    }

    public void createQueryingTasks(DeviceSessionContext sessionContext) {
        sessionContext.getProfileTransportConfiguration().getCommunicationConfigs().stream().filter(communicationConfig -> communicationConfig instanceof RepeatingQueryingSnmpCommunicationConfig).forEach(config -> {
            RepeatingQueryingSnmpCommunicationConfig repeatingCommunicationConfig = (RepeatingQueryingSnmpCommunicationConfig)config;
            Long queryingFrequency = repeatingCommunicationConfig.getQueryingFrequencyMs();
            ScheduledTask scheduledTask = new ScheduledTask();
            scheduledTask.init((AsyncCallable<Void>)((AsyncCallable)() -> {
                try {
                    if (sessionContext.isActive()) {
                        return this.sendRequest(sessionContext, (SnmpCommunicationConfig)repeatingCommunicationConfig);
                    }
                }
                catch (Exception e) {
                    log.error("Failed to send SNMP request for device {}: {}", (Object)sessionContext.getDeviceId(), (Object)e.toString());
                    this.transportService.errorEvent(sessionContext.getTenantId(), sessionContext.getDeviceId(), config.getSpec().getLabel(), (Throwable)e);
                }
                return Futures.immediateVoidFuture();
            }), queryingFrequency, (ScheduledExecutorService)this.scheduler);
            sessionContext.getQueryingTasks().add(scheduledTask);
        });
    }

    public void cancelQueryingTasks(DeviceSessionContext sessionContext) {
        sessionContext.getQueryingTasks().forEach(ScheduledTask::cancel);
        sessionContext.getQueryingTasks().clear();
    }

    private ListenableFuture<Void> sendRequest(DeviceSessionContext sessionContext, SnmpCommunicationConfig communicationConfig) {
        return this.sendRequest(sessionContext, communicationConfig, Collections.emptyMap());
    }

    private ListenableFuture<Void> sendRequest(DeviceSessionContext sessionContext, SnmpCommunicationConfig communicationConfig, Map<String, String> values) {
        List<PDU> request = this.pduService.createPdus(sessionContext, communicationConfig, values);
        RequestContext requestContext = RequestContext.builder().communicationSpec(communicationConfig.getSpec()).method(communicationConfig.getMethod()).responseMappings(communicationConfig.getAllMappings()).requestSize(request.size()).build();
        return this.sendRequest(sessionContext, request, requestContext);
    }

    private ListenableFuture<Void> sendRequest(DeviceSessionContext sessionContext, List<PDU> request, RequestContext requestContext) {
        if (request.size() <= 1 || this.requestChunkDelayMs == 0) {
            for (PDU pdu : request) {
                this.sendPdu(pdu, requestContext, sessionContext);
            }
            return Futures.immediateVoidFuture();
        }
        ArrayList<ListenableScheduledFuture> futures = new ArrayList<ListenableScheduledFuture>();
        int i = 0;
        int delay = 0;
        while (i < request.size()) {
            PDU pdu = request.get(i);
            if (delay == 0) {
                this.sendPdu(pdu, requestContext, sessionContext);
            } else {
                ListenableScheduledFuture future = this.scheduler.schedule(() -> this.sendPdu(pdu, requestContext, sessionContext), (long)delay, TimeUnit.MILLISECONDS);
                futures.add(future);
            }
            ++i;
            delay += this.requestChunkDelayMs;
        }
        return Futures.whenAllComplete(futures).call(() -> null, MoreExecutors.directExecutor());
    }

    private void sendPdu(PDU pdu, RequestContext requestContext, DeviceSessionContext sessionContext) {
        log.debug("[{}] Sending SNMP request with {} variable bindings to {}", new Object[]{sessionContext.getDeviceId(), pdu.size(), sessionContext.getTarget().getAddress()});
        try {
            this.snmp.send(pdu, sessionContext.getTarget(), (Object)requestContext, (ResponseListener)sessionContext);
        }
        catch (Exception e) {
            log.error("[{}] Failed to send SNMP request", (Object)sessionContext.getDeviceId(), (Object)e);
            this.transportService.errorEvent(sessionContext.getTenantId(), sessionContext.getDeviceId(), requestContext.getCommunicationSpec().getLabel(), (Throwable)e);
        }
    }

    public void onAttributeUpdate(DeviceSessionContext sessionContext, TransportProtos.AttributeUpdateNotificationMsg attributeUpdateNotification) {
        sessionContext.getProfileTransportConfiguration().getCommunicationConfigs().stream().filter(config -> config.getSpec() == SnmpCommunicationSpec.SHARED_ATTRIBUTES_SETTING).findFirst().ifPresent(communicationConfig -> {
            Map<String, String> sharedAttributes = JsonConverter.toJson((TransportProtos.AttributeUpdateNotificationMsg)attributeUpdateNotification).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).isJsonPrimitive() ? ((JsonElement)entry.getValue()).getAsString() : ((JsonElement)entry.getValue()).toString()));
            this.sendRequest(sessionContext, (SnmpCommunicationConfig)communicationConfig, sharedAttributes);
        });
    }

    public void onToDeviceRpcRequest(DeviceSessionContext sessionContext, TransportProtos.ToDeviceRpcRequestMsg toDeviceRpcRequestMsg) {
        SnmpMethod snmpMethod = SnmpMethod.valueOf((String)toDeviceRpcRequestMsg.getMethodName());
        JsonObject params = JsonConverter.parse((String)toDeviceRpcRequestMsg.getParams()).getAsJsonObject();
        String key = Optional.ofNullable(params.get("key")).map(JsonElement::getAsString).orElse(null);
        String value = Optional.ofNullable(params.get("value")).map(JsonElement::getAsString).orElse(null);
        if (value == null && snmpMethod == SnmpMethod.SET) {
            throw new IllegalArgumentException("Value must be specified for SNMP method 'SET'");
        }
        SnmpCommunicationConfig communicationConfig = sessionContext.getProfileTransportConfiguration().getCommunicationConfigs().stream().filter(config -> config.getSpec() == SnmpCommunicationSpec.TO_DEVICE_RPC_REQUEST).findFirst().orElseThrow(() -> new IllegalArgumentException("No communication config found with RPC spec"));
        SnmpMapping snmpMapping = communicationConfig.getAllMappings().stream().filter(mapping -> mapping.getKey().equals(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("No SNMP mapping found in the config for specified key"));
        String oid = snmpMapping.getOid();
        DataType dataType = snmpMapping.getDataType();
        PDU request = this.pduService.createSingleVariablePdu(sessionContext, snmpMethod, oid, value, dataType);
        RequestContext requestContext = RequestContext.builder().requestId(toDeviceRpcRequestMsg.getRequestId()).communicationSpec(communicationConfig.getSpec()).method(snmpMethod).responseMappings(communicationConfig.getAllMappings()).requestSize(1).build();
        this.sendRequest(sessionContext, List.of(request), requestContext);
    }

    public void processResponseEvent(DeviceSessionContext sessionContext, ResponseEvent event) {
        List<PDU> response;
        ((Snmp)event.getSource()).cancel(event.getRequest(), (ResponseListener)sessionContext);
        RequestContext requestContext = (RequestContext)event.getUserObject();
        if (event.getError() != null) {
            log.warn("[{}] SNMP response error: {}", (Object)sessionContext.getDeviceId(), (Object)event.getError().toString());
            this.transportService.errorEvent(sessionContext.getTenantId(), sessionContext.getDeviceId(), requestContext.getCommunicationSpec().getLabel(), (Throwable)new RuntimeException(event.getError()));
            return;
        }
        PDU responsePdu = event.getResponse();
        log.trace("[{}] Received PDU: {}", (Object)sessionContext.getDeviceId(), (Object)responsePdu);
        if (requestContext.getRequestSize() == 1) {
            if (responsePdu == null) {
                if (requestContext.getMethod() == SnmpMethod.GET) {
                    log.debug("[{}][{}] Empty response from device", (Object)sessionContext.getDeviceId(), (Object)event.getRequest().getRequestID());
                    this.transportService.errorEvent(sessionContext.getTenantId(), sessionContext.getDeviceId(), requestContext.getCommunicationSpec().getLabel(), (Throwable)new RuntimeException("No response from device"));
                }
                return;
            }
            response = List.of(responsePdu);
        } else {
            List<PDU> responseParts = requestContext.getResponseParts();
            responseParts.add(responsePdu);
            if (responseParts.size() == requestContext.getRequestSize()) {
                response = new ArrayList<PDU>();
                for (PDU responsePart : responseParts) {
                    if (responsePart == null) continue;
                    response.add(responsePart);
                }
                log.debug("[{}] All {} response parts are collected for request", (Object)sessionContext.getDeviceId(), (Object)responseParts.size());
            } else {
                log.trace("[{}] Awaiting other response parts for request", (Object)sessionContext.getDeviceId());
                return;
            }
        }
        this.executor.execute(() -> {
            try {
                this.processResponse(sessionContext, response, requestContext);
            }
            catch (Exception e) {
                this.transportService.errorEvent(sessionContext.getTenantId(), sessionContext.getDeviceId(), requestContext.getCommunicationSpec().getLabel(), (Throwable)e);
            }
        });
    }

    public void processPdu(CommandResponderEvent event) {
        IpAddress sourceAddress = (IpAddress)event.getPeerAddress();
        List sessions = this.transportContext.getSessions().stream().filter(session -> ((IpAddress)session.getTarget().getAddress()).getInetAddress().equals(sourceAddress.getInetAddress())).collect(Collectors.toList());
        if (sessions.isEmpty()) {
            log.warn("Couldn't find device session for SNMP TRAP for address {}", (Object)sourceAddress);
            return;
        }
        if (sessions.size() > 1) {
            for (DeviceSessionContext sessionContext : sessions) {
                this.transportService.errorEvent(sessionContext.getTenantId(), sessionContext.getDeviceId(), SnmpCommunicationSpec.TO_SERVER_RPC_REQUEST.getLabel(), (Throwable)new IllegalStateException("Found multiple devices for host " + sourceAddress.getInetAddress().getHostAddress()));
            }
            return;
        }
        DeviceSessionContext sessionContext = (DeviceSessionContext)((Object)sessions.get(0));
        try {
            this.processIncomingTrap(sessionContext, event);
        }
        catch (Throwable e) {
            this.transportService.errorEvent(sessionContext.getTenantId(), sessionContext.getDeviceId(), SnmpCommunicationSpec.TO_SERVER_RPC_REQUEST.getLabel(), e);
        }
    }

    private void processIncomingTrap(DeviceSessionContext sessionContext, CommandResponderEvent event) {
        PDU pdu = event.getPDU();
        if (pdu == null) {
            log.warn("[{}] Received empty SNMP trap", (Object)sessionContext.getDeviceId());
            throw new IllegalArgumentException("Received TRAP with no data");
        }
        log.debug("[{}] Processing SNMP trap: {}", (Object)sessionContext.getDeviceId(), (Object)pdu);
        SnmpCommunicationConfig communicationConfig = sessionContext.getProfileTransportConfiguration().getCommunicationConfigs().stream().filter(config -> config.getSpec() == SnmpCommunicationSpec.TO_SERVER_RPC_REQUEST).findFirst().orElseThrow(() -> new IllegalArgumentException("No config found for to-server RPC requests"));
        RequestContext requestContext = RequestContext.builder().communicationSpec(communicationConfig.getSpec()).responseMappings(communicationConfig.getAllMappings()).method(SnmpMethod.TRAP).build();
        this.executor.execute(() -> this.processResponse(sessionContext, List.of(pdu), requestContext));
    }

    private void processResponse(DeviceSessionContext sessionContext, List<PDU> response, RequestContext requestContext) {
        ResponseProcessor responseProcessor = this.responseProcessors.get(requestContext.getCommunicationSpec());
        if (responseProcessor == null) {
            return;
        }
        JsonObject responseData = this.responseDataMappers.get(requestContext.getCommunicationSpec()).map(response, requestContext);
        if (responseData.size() == 0) {
            log.warn("[{}] No values in the response", (Object)sessionContext.getDeviceId());
            throw new IllegalArgumentException("No values in the response");
        }
        responseProcessor.process(responseData, requestContext, sessionContext);
        this.reportActivity(sessionContext.getSessionInfo());
    }

    private void configureResponseDataMappers() {
        this.responseDataMappers.put(SnmpCommunicationSpec.TO_DEVICE_RPC_REQUEST, (pdus, requestContext) -> {
            JsonObject responseData = new JsonObject();
            this.pduService.processPdus(pdus).forEach((oid, value) -> requestContext.getResponseMappings().stream().filter(snmpMapping -> snmpMapping.getOid().equals(oid.toDottedString())).findFirst().ifPresent(snmpMapping -> this.pduService.processValue(snmpMapping.getKey(), snmpMapping.getDataType(), (String)value, responseData)));
            return responseData;
        });
        ResponseDataMapper defaultResponseDataMapper = (pdus, requestContext) -> this.pduService.processPdus(pdus, requestContext.getResponseMappings());
        Arrays.stream(SnmpCommunicationSpec.values()).forEach(communicationSpec -> this.responseDataMappers.putIfAbsent((SnmpCommunicationSpec)communicationSpec, defaultResponseDataMapper));
    }

    private void configureResponseProcessors() {
        this.responseProcessors.put(SnmpCommunicationSpec.TELEMETRY_QUERYING, (responseData, requestContext, sessionContext) -> {
            TransportProtos.PostTelemetryMsg postTelemetryMsg = JsonConverter.convertToTelemetryProto((JsonElement)responseData);
            this.transportService.process(sessionContext.getSessionInfo(), postTelemetryMsg, null);
            log.debug("Posted telemetry for SNMP device {}: {}", (Object)sessionContext.getDeviceId(), (Object)responseData);
        });
        this.responseProcessors.put(SnmpCommunicationSpec.CLIENT_ATTRIBUTES_QUERYING, (responseData, requestContext, sessionContext) -> {
            TransportProtos.PostAttributeMsg postAttributesMsg = JsonConverter.convertToAttributesProto((JsonElement)responseData);
            this.transportService.process(sessionContext.getSessionInfo(), postAttributesMsg, null);
            log.debug("Posted attributes for SNMP device {}: {}", (Object)sessionContext.getDeviceId(), (Object)responseData);
        });
        this.responseProcessors.put(SnmpCommunicationSpec.TO_DEVICE_RPC_REQUEST, (responseData, requestContext, sessionContext) -> {
            TransportProtos.ToDeviceRpcResponseMsg rpcResponseMsg = TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(requestContext.getRequestId().intValue()).setPayload(JsonConverter.toJson((JsonElement)responseData)).build();
            this.transportService.process(sessionContext.getSessionInfo(), rpcResponseMsg, null);
            log.debug("Posted RPC response {} for device {}", (Object)responseData, (Object)sessionContext.getDeviceId());
        });
        this.responseProcessors.put(SnmpCommunicationSpec.TO_SERVER_RPC_REQUEST, (responseData, requestContext, sessionContext) -> {
            TransportProtos.ToServerRpcRequestMsg toServerRpcRequestMsg = TransportProtos.ToServerRpcRequestMsg.newBuilder().setRequestId(0).setMethodName(requestContext.getMethod().name()).setParams(JsonConverter.toJson((JsonElement)responseData)).build();
            this.transportService.process(sessionContext.getSessionInfo(), toServerRpcRequestMsg, null);
        });
    }

    private void reportActivity(TransportProtos.SessionInfoProto sessionInfo) {
        this.transportService.recordActivity(sessionInfo);
    }

    public String getName() {
        return "SNMP";
    }

    @PreDestroy
    public void shutdown() {
        log.info("Stopping SNMP transport!");
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.snmp != null) {
            try {
                this.snmp.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.info("SNMP transport stopped!");
    }

    @ConstructorProperties(value={"transportService", "pduService"})
    @Generated
    public SnmpTransportService(TransportService transportService, PduService pduService) {
        this.transportService = transportService;
        this.pduService = pduService;
    }

    @Generated
    public Snmp getSnmp() {
        return this.snmp;
    }

    private static class RequestContext {
        private final Integer requestId;
        private final SnmpCommunicationSpec communicationSpec;
        private final SnmpMethod method;
        private final List<SnmpMapping> responseMappings;
        private final int requestSize;
        private List<PDU> responseParts;

        public RequestContext(Integer requestId, SnmpCommunicationSpec communicationSpec, SnmpMethod method, List<SnmpMapping> responseMappings, int requestSize) {
            this.requestId = requestId;
            this.communicationSpec = communicationSpec;
            this.method = method;
            this.responseMappings = responseMappings;
            this.requestSize = requestSize;
            if (requestSize > 1) {
                this.responseParts = Collections.synchronizedList(new ArrayList());
            }
        }

        @Generated
        public static RequestContextBuilder builder() {
            return new RequestContextBuilder();
        }

        @Generated
        public Integer getRequestId() {
            return this.requestId;
        }

        @Generated
        public SnmpCommunicationSpec getCommunicationSpec() {
            return this.communicationSpec;
        }

        @Generated
        public SnmpMethod getMethod() {
            return this.method;
        }

        @Generated
        public List<SnmpMapping> getResponseMappings() {
            return this.responseMappings;
        }

        @Generated
        public int getRequestSize() {
            return this.requestSize;
        }

        @Generated
        public List<PDU> getResponseParts() {
            return this.responseParts;
        }

        @Generated
        public void setResponseParts(List<PDU> responseParts) {
            this.responseParts = responseParts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestContext)) {
                return false;
            }
            RequestContext other = (RequestContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRequestSize() != other.getRequestSize()) {
                return false;
            }
            Integer this$requestId = this.getRequestId();
            Integer other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !((Object)this$requestId).equals(other$requestId)) {
                return false;
            }
            SnmpCommunicationSpec this$communicationSpec = this.getCommunicationSpec();
            SnmpCommunicationSpec other$communicationSpec = other.getCommunicationSpec();
            if (this$communicationSpec == null ? other$communicationSpec != null : !this$communicationSpec.equals(other$communicationSpec)) {
                return false;
            }
            SnmpMethod this$method = this.getMethod();
            SnmpMethod other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            List<SnmpMapping> this$responseMappings = this.getResponseMappings();
            List<SnmpMapping> other$responseMappings = other.getResponseMappings();
            if (this$responseMappings == null ? other$responseMappings != null : !((Object)this$responseMappings).equals(other$responseMappings)) {
                return false;
            }
            List<PDU> this$responseParts = this.getResponseParts();
            List<PDU> other$responseParts = other.getResponseParts();
            return !(this$responseParts == null ? other$responseParts != null : !((Object)this$responseParts).equals(other$responseParts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRequestSize();
            Integer $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : ((Object)$requestId).hashCode());
            SnmpCommunicationSpec $communicationSpec = this.getCommunicationSpec();
            result = result * 59 + ($communicationSpec == null ? 43 : $communicationSpec.hashCode());
            SnmpMethod $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            List<SnmpMapping> $responseMappings = this.getResponseMappings();
            result = result * 59 + ($responseMappings == null ? 43 : ((Object)$responseMappings).hashCode());
            List<PDU> $responseParts = this.getResponseParts();
            result = result * 59 + ($responseParts == null ? 43 : ((Object)$responseParts).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SnmpTransportService.RequestContext(requestId=" + this.getRequestId() + ", communicationSpec=" + String.valueOf(this.getCommunicationSpec()) + ", method=" + String.valueOf(this.getMethod()) + ", responseMappings=" + String.valueOf(this.getResponseMappings()) + ", requestSize=" + this.getRequestSize() + ", responseParts=" + String.valueOf(this.getResponseParts()) + ")";
        }

        @Generated
        public static class RequestContextBuilder {
            @Generated
            private Integer requestId;
            @Generated
            private SnmpCommunicationSpec communicationSpec;
            @Generated
            private SnmpMethod method;
            @Generated
            private List<SnmpMapping> responseMappings;
            @Generated
            private int requestSize;

            @Generated
            RequestContextBuilder() {
            }

            @Generated
            public RequestContextBuilder requestId(Integer requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public RequestContextBuilder communicationSpec(SnmpCommunicationSpec communicationSpec) {
                this.communicationSpec = communicationSpec;
                return this;
            }

            @Generated
            public RequestContextBuilder method(SnmpMethod method) {
                this.method = method;
                return this;
            }

            @Generated
            public RequestContextBuilder responseMappings(List<SnmpMapping> responseMappings) {
                this.responseMappings = responseMappings;
                return this;
            }

            @Generated
            public RequestContextBuilder requestSize(int requestSize) {
                this.requestSize = requestSize;
                return this;
            }

            @Generated
            public RequestContext build() {
                return new RequestContext(this.requestId, this.communicationSpec, this.method, this.responseMappings, this.requestSize);
            }

            @Generated
            public String toString() {
                return "SnmpTransportService.RequestContext.RequestContextBuilder(requestId=" + this.requestId + ", communicationSpec=" + String.valueOf(this.communicationSpec) + ", method=" + String.valueOf(this.method) + ", responseMappings=" + String.valueOf(this.responseMappings) + ", requestSize=" + this.requestSize + ")";
            }
        }
    }

    private static interface ResponseProcessor {
        public void process(JsonObject var1, RequestContext var2, DeviceSessionContext var3);
    }

    private static interface ResponseDataMapper {
        public JsonObject map(List<PDU> var1, RequestContext var2);
    }
}

