/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.service;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.snmp4j.CommunityTarget;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.device.data.SnmpDeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.SnmpDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.transport.snmp.SnmpProtocolVersion;
import org.thingsboard.server.queue.util.TbSnmpTransportComponent;
import org.thingsboard.server.transport.snmp.service.SnmpTransportService;
import org.thingsboard.server.transport.snmp.session.DeviceSessionContext;

@Service
@TbSnmpTransportComponent
public class SnmpAuthService {
    private final SnmpTransportService snmpTransportService;
    @Value(value="${transport.snmp.underlying_protocol}")
    private String snmpUnderlyingProtocol;

    public Target setUpSnmpTarget(SnmpDeviceProfileTransportConfiguration profileTransportConfig, SnmpDeviceTransportConfiguration deviceTransportConfig) {
        SnmpProtocolVersion protocolVersion = deviceTransportConfig.getProtocolVersion();
        CommunityTarget target = switch (protocolVersion) {
            case SnmpProtocolVersion.V1 -> {
                CommunityTarget communityTargetV1 = new CommunityTarget();
                communityTargetV1.setSecurityModel(1);
                communityTargetV1.setSecurityLevel(1);
                communityTargetV1.setCommunity(new OctetString(deviceTransportConfig.getCommunity()));
                yield communityTargetV1;
            }
            case SnmpProtocolVersion.V2C -> {
                CommunityTarget communityTargetV2 = new CommunityTarget();
                communityTargetV2.setSecurityModel(2);
                communityTargetV2.setSecurityLevel(1);
                communityTargetV2.setCommunity(new OctetString(deviceTransportConfig.getCommunity()));
                yield communityTargetV2;
            }
            case SnmpProtocolVersion.V3 -> {
                OctetString username = new OctetString(deviceTransportConfig.getUsername());
                OctetString securityName = new OctetString(deviceTransportConfig.getSecurityName());
                OctetString engineId = OctetString.fromString((String)deviceTransportConfig.getEngineId(), (int)16);
                OID authenticationProtocol = new OID(deviceTransportConfig.getAuthenticationProtocol().getOid());
                OctetString authenticationPassphrase = Optional.ofNullable(SecurityProtocols.getInstance().passwordToKey(authenticationProtocol, new OctetString(deviceTransportConfig.getAuthenticationPassphrase()), engineId.getValue())).map(OctetString::new).orElseThrow(() -> new UnsupportedOperationException("Authentication protocol " + String.valueOf(deviceTransportConfig.getAuthenticationProtocol()) + " is not supported"));
                OID privacyProtocol = new OID(deviceTransportConfig.getPrivacyProtocol().getOid());
                OctetString privacyPassphrase = Optional.ofNullable(SecurityProtocols.getInstance().passwordToKey(privacyProtocol, authenticationProtocol, new OctetString(deviceTransportConfig.getPrivacyPassphrase()), engineId.getValue())).map(OctetString::new).orElseThrow(() -> new UnsupportedOperationException("Privacy protocol " + String.valueOf(deviceTransportConfig.getPrivacyProtocol()) + " is not supported"));
                USM usm = this.snmpTransportService.getSnmp().getUSM();
                if (usm.hasUser(engineId, securityName)) {
                    usm.removeAllUsers(username, engineId);
                }
                UsmUser usmUser = new UsmUser(username, authenticationProtocol, authenticationPassphrase, privacyProtocol, privacyPassphrase, engineId);
                usm.addUser(username, engineId, usmUser);
                UserTarget userTarget = new UserTarget();
                userTarget.setSecurityName(securityName);
                userTarget.setAuthoritativeEngineID(engineId.getValue());
                userTarget.setSecurityModel(3);
                userTarget.setSecurityLevel(3);
                yield userTarget;
            }
            default -> throw new UnsupportedOperationException("SNMP protocol version " + String.valueOf(protocolVersion) + " is not supported");
        };
        Address address = GenericAddress.parse((String)(this.snmpUnderlyingProtocol + ":" + deviceTransportConfig.getHost() + "/" + deviceTransportConfig.getPort()));
        target.setAddress(Optional.ofNullable(address).orElseThrow(() -> new IllegalArgumentException("Address of the SNMP device is invalid")));
        target.setTimeout((long)profileTransportConfig.getTimeoutMs().intValue());
        target.setRetries(profileTransportConfig.getRetries().intValue());
        target.setVersion(protocolVersion.getCode());
        return target;
    }

    public void cleanUpSnmpAuthInfo(DeviceSessionContext sessionContext) {
        SnmpDeviceTransportConfiguration deviceTransportConfiguration = sessionContext.getDeviceTransportConfiguration();
        if (deviceTransportConfiguration.getProtocolVersion() == SnmpProtocolVersion.V3) {
            OctetString username = new OctetString(deviceTransportConfiguration.getUsername());
            OctetString engineId = new OctetString(deviceTransportConfiguration.getEngineId());
            this.snmpTransportService.getSnmp().getUSM().removeAllUsers(username, engineId);
        }
    }

    @ConstructorProperties(value={"snmpTransportService"})
    @Generated
    public SnmpAuthService(SnmpTransportService snmpTransportService) {
        this.snmpTransportService = snmpTransportService;
    }
}

