/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.service;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.device.data.DeviceData;
import org.thingsboard.server.common.data.device.data.DeviceTransportConfiguration;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbSnmpTransportComponent;

@TbSnmpTransportComponent
@Service
public class ProtoTransportEntityService {
    private final TransportService transportService;

    public Device getDeviceById(DeviceId id) {
        TransportProtos.GetDeviceResponseMsg deviceProto = this.transportService.getDevice(TransportProtos.GetDeviceRequestMsg.newBuilder().setDeviceIdMSB(id.getId().getMostSignificantBits()).setDeviceIdLSB(id.getId().getLeastSignificantBits()).build());
        if (deviceProto == null) {
            return null;
        }
        DeviceProfileId deviceProfileId = new DeviceProfileId(new UUID(deviceProto.getDeviceProfileIdMSB(), deviceProto.getDeviceProfileIdLSB()));
        Device device = new Device();
        device.setId((UUIDBased)id);
        device.setDeviceProfileId(deviceProfileId);
        DeviceTransportConfiguration deviceTransportConfiguration = (DeviceTransportConfiguration)JacksonUtil.fromBytes((byte[])deviceProto.getDeviceTransportConfiguration().toByteArray(), DeviceTransportConfiguration.class);
        DeviceData deviceData = new DeviceData();
        deviceData.setTransportConfiguration(deviceTransportConfiguration);
        device.setDeviceData(deviceData);
        return device;
    }

    public DeviceCredentials getDeviceCredentialsByDeviceId(DeviceId deviceId) {
        TransportProtos.GetDeviceCredentialsResponseMsg deviceCredentialsResponse = this.transportService.getDeviceCredentials(TransportProtos.GetDeviceCredentialsRequestMsg.newBuilder().setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).build());
        if (deviceCredentialsResponse.hasDeviceCredentialsData()) {
            return ProtoUtils.fromProto((TransportProtos.DeviceCredentialsProto)deviceCredentialsResponse.getDeviceCredentialsData());
        }
        throw new IllegalArgumentException("Device credentials not found");
    }

    public TransportProtos.GetSnmpDevicesResponseMsg getSnmpDevicesIds(int page, int pageSize) {
        TransportProtos.GetSnmpDevicesRequestMsg requestMsg = TransportProtos.GetSnmpDevicesRequestMsg.newBuilder().setPage(page).setPageSize(pageSize).build();
        return this.transportService.getSnmpDevicesIds(requestMsg);
    }

    @ConstructorProperties(value={"transportService"})
    @Generated
    public ProtoTransportEntityService(TransportService transportService) {
        this.transportService = transportService;
    }
}

