/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.session;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.device.data.SnmpDeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.SnmpDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.common.data.transport.snmp.SnmpCommunicationSpec;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.session.DeviceAwareSessionContext;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.snmp.SnmpTransportContext;
import org.thingsboard.server.transport.snmp.session.ScheduledTask;

public class DeviceSessionContext
extends DeviceAwareSessionContext
implements SessionMsgListener,
ResponseListener {
    private static final Logger log = LoggerFactory.getLogger(DeviceSessionContext.class);
    private Target target;
    private final String token;
    private SnmpDeviceProfileTransportConfiguration profileTransportConfiguration;
    private SnmpDeviceTransportConfiguration deviceTransportConfiguration;
    private Device device;
    private final TenantId tenantId;
    private final SnmpTransportContext snmpTransportContext;
    private final AtomicInteger msgIdSeq = new AtomicInteger(0);
    private boolean isActive = true;
    private Runnable sessionTimeoutHandler;
    private final List<ScheduledTask> queryingTasks = new LinkedList<ScheduledTask>();

    public DeviceSessionContext(TenantId tenantId, Device device, DeviceProfile deviceProfile, String token, SnmpDeviceProfileTransportConfiguration profileTransportConfiguration, SnmpDeviceTransportConfiguration deviceTransportConfiguration, SnmpTransportContext snmpTransportContext) throws Exception {
        super(UUID.randomUUID());
        super.setDeviceId(device.getId());
        super.setDeviceProfile(deviceProfile);
        this.device = device;
        this.tenantId = tenantId;
        this.token = token;
        this.snmpTransportContext = snmpTransportContext;
        this.profileTransportConfiguration = profileTransportConfiguration;
        this.deviceTransportConfiguration = deviceTransportConfiguration;
        this.initializeTarget(profileTransportConfiguration, deviceTransportConfiguration);
    }

    public void onDeviceProfileUpdate(TransportProtos.SessionInfoProto newSessionInfo, DeviceProfile deviceProfile) {
        super.onDeviceProfileUpdate(newSessionInfo, deviceProfile);
        if (this.isActive) {
            this.snmpTransportContext.onDeviceProfileUpdated(deviceProfile, this);
        }
    }

    public void onDeviceDeleted(DeviceId deviceId) {
        this.snmpTransportContext.onDeviceDeleted(this);
    }

    public void onResponse(ResponseEvent event) {
        if (this.isActive) {
            this.snmpTransportContext.getSnmpTransportService().processResponseEvent(this, event);
        }
    }

    public void initializeTarget(SnmpDeviceProfileTransportConfiguration profileTransportConfig, SnmpDeviceTransportConfiguration deviceTransportConfig) throws Exception {
        log.trace("Initializing target for SNMP session of device {}", (Object)this.device);
        this.target = this.snmpTransportContext.getSnmpAuthService().setUpSnmpTarget(profileTransportConfig, deviceTransportConfig);
        log.debug("SNMP target initialized: {}", (Object)this.target);
    }

    public void close() {
        this.isActive = false;
    }

    public String getToken() {
        return this.token;
    }

    public int nextMsgId() {
        return this.msgIdSeq.incrementAndGet();
    }

    public void onGetAttributesResponse(TransportProtos.GetAttributeResponseMsg getAttributesResponse) {
    }

    public void onAttributeUpdate(UUID sessionId, TransportProtos.AttributeUpdateNotificationMsg attributeUpdateNotification) {
        log.trace("[{}] Received attributes update notification to device", (Object)sessionId);
        try {
            this.snmpTransportContext.getSnmpTransportService().onAttributeUpdate(this, attributeUpdateNotification);
        }
        catch (Exception e) {
            this.snmpTransportContext.getTransportService().errorEvent(this.getTenantId(), this.getDeviceId(), SnmpCommunicationSpec.SHARED_ATTRIBUTES_SETTING.getLabel(), (Throwable)e);
        }
    }

    public void onRemoteSessionCloseCommand(UUID sessionId, TransportProtos.SessionCloseNotificationProto sessionCloseNotification) {
        log.trace("[{}] Received the remote command to close the session: {}", (Object)sessionId, (Object)sessionCloseNotification.getMessage());
        if (sessionCloseNotification.getMessage().equals("Session has expired due to last activity time!") && this.sessionTimeoutHandler != null) {
            this.sessionTimeoutHandler.run();
        }
    }

    public void onToDeviceRpcRequest(UUID sessionId, TransportProtos.ToDeviceRpcRequestMsg toDeviceRequest) {
        log.trace("[{}] Received RPC command to device", (Object)sessionId);
        try {
            this.snmpTransportContext.getSnmpTransportService().onToDeviceRpcRequest(this, toDeviceRequest);
            this.snmpTransportContext.getTransportService().process(this.getSessionInfo(), toDeviceRequest, RpcStatus.DELIVERED, TransportServiceCallback.EMPTY);
        }
        catch (Exception e) {
            this.snmpTransportContext.getTransportService().errorEvent(this.getTenantId(), this.getDeviceId(), SnmpCommunicationSpec.TO_DEVICE_RPC_REQUEST.getLabel(), (Throwable)e);
        }
    }

    public void onToServerRpcResponse(TransportProtos.ToServerRpcResponseMsg toServerResponse) {
    }

    public static DeviceSessionContextBuilder builder() {
        return new DeviceSessionContextBuilder();
    }

    public Target getTarget() {
        return this.target;
    }

    public SnmpDeviceProfileTransportConfiguration getProfileTransportConfiguration() {
        return this.profileTransportConfiguration;
    }

    public void setProfileTransportConfiguration(SnmpDeviceProfileTransportConfiguration profileTransportConfiguration) {
        this.profileTransportConfiguration = profileTransportConfiguration;
    }

    public SnmpDeviceTransportConfiguration getDeviceTransportConfiguration() {
        return this.deviceTransportConfiguration;
    }

    public void setDeviceTransportConfiguration(SnmpDeviceTransportConfiguration deviceTransportConfiguration) {
        this.deviceTransportConfiguration = deviceTransportConfiguration;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setSessionTimeoutHandler(Runnable sessionTimeoutHandler) {
        this.sessionTimeoutHandler = sessionTimeoutHandler;
    }

    public List<ScheduledTask> getQueryingTasks() {
        return this.queryingTasks;
    }

    public static class DeviceSessionContextBuilder {
        private TenantId tenantId;
        private Device device;
        private DeviceProfile deviceProfile;
        private String token;
        private SnmpDeviceProfileTransportConfiguration profileTransportConfiguration;
        private SnmpDeviceTransportConfiguration deviceTransportConfiguration;
        private SnmpTransportContext snmpTransportContext;

        DeviceSessionContextBuilder() {
        }

        public DeviceSessionContextBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public DeviceSessionContextBuilder device(Device device) {
            this.device = device;
            return this;
        }

        public DeviceSessionContextBuilder deviceProfile(DeviceProfile deviceProfile) {
            this.deviceProfile = deviceProfile;
            return this;
        }

        public DeviceSessionContextBuilder token(String token) {
            this.token = token;
            return this;
        }

        public DeviceSessionContextBuilder profileTransportConfiguration(SnmpDeviceProfileTransportConfiguration profileTransportConfiguration) {
            this.profileTransportConfiguration = profileTransportConfiguration;
            return this;
        }

        public DeviceSessionContextBuilder deviceTransportConfiguration(SnmpDeviceTransportConfiguration deviceTransportConfiguration) {
            this.deviceTransportConfiguration = deviceTransportConfiguration;
            return this;
        }

        public DeviceSessionContextBuilder snmpTransportContext(SnmpTransportContext snmpTransportContext) {
            this.snmpTransportContext = snmpTransportContext;
            return this;
        }

        public DeviceSessionContext build() throws Exception {
            return new DeviceSessionContext(this.tenantId, this.device, this.deviceProfile, this.token, this.profileTransportConfiguration, this.deviceTransportConfiguration, this.snmpTransportContext);
        }

        public String toString() {
            return "DeviceSessionContext.DeviceSessionContextBuilder(tenantId=" + this.tenantId + ", device=" + this.device + ", deviceProfile=" + this.deviceProfile + ", token=" + this.token + ", profileTransportConfiguration=" + this.profileTransportConfiguration + ", deviceTransportConfiguration=" + this.deviceTransportConfiguration + ", snmpTransportContext=" + this.snmpTransportContext + ")";
        }
    }
}

