/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.service;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.data.SnmpDeviceTransportConfiguration;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.transport.snmp.SnmpMapping;
import org.thingsboard.server.common.data.transport.snmp.SnmpMethod;
import org.thingsboard.server.common.data.transport.snmp.SnmpProtocolVersion;
import org.thingsboard.server.common.data.transport.snmp.config.SnmpCommunicationConfig;
import org.thingsboard.server.common.data.util.TypeCastUtil;
import org.thingsboard.server.queue.util.TbSnmpTransportComponent;
import org.thingsboard.server.transport.snmp.session.DeviceSessionContext;

@TbSnmpTransportComponent
@Service
public class PduService {
    private static final Logger log = LoggerFactory.getLogger(PduService.class);
    @Value(value="${transport.snmp.max_request_oids:100}")
    private int maxRequestOids;
    @Value(value="${transport.snmp.response.ignore_type_cast_errors:false}")
    private boolean ignoreTypeCastErrors;

    public List<PDU> createPdus(DeviceSessionContext sessionContext, SnmpCommunicationConfig communicationConfig, Map<String, String> values) {
        ArrayList<PDU> pdus = new ArrayList<PDU>();
        List allMappings = communicationConfig.getAllMappings();
        for (List mappings : Lists.partition((List)allMappings, (int)this.maxRequestOids)) {
            PDU pdu = this.setUpPdu(sessionContext);
            pdu.setType(communicationConfig.getMethod().getCode());
            pdu.addAll(mappings.stream().filter(mapping -> values.isEmpty() || values.containsKey(mapping.getKey())).map(mapping -> Optional.ofNullable((String)values.get(mapping.getKey())).map(value -> {
                Variable variable = this.toSnmpVariable((String)value, mapping.getDataType());
                return new VariableBinding(new OID(mapping.getOid()), variable);
            }).orElseGet(() -> new VariableBinding(new OID(mapping.getOid())))).collect(Collectors.toList()));
            if (pdu.size() <= 0) continue;
            pdus.add(pdu);
        }
        return pdus;
    }

    public PDU createSingleVariablePdu(DeviceSessionContext sessionContext, SnmpMethod snmpMethod, String oid, String value, DataType dataType) {
        PDU pdu = this.setUpPdu(sessionContext);
        pdu.setType(snmpMethod.getCode());
        Null variable = value == null ? Null.instance : this.toSnmpVariable(value, dataType);
        pdu.add(new VariableBinding(new OID(oid), (Variable)variable));
        return pdu;
    }

    private Variable toSnmpVariable(String value, DataType dataType) {
        OctetString variable;
        dataType = dataType == null ? DataType.STRING : dataType;
        switch (dataType) {
            case LONG: {
                try {
                    variable = new Integer32(Integer.parseInt(value));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            default: {
                variable = new OctetString(value);
            }
        }
        return variable;
    }

    private PDU setUpPdu(DeviceSessionContext sessionContext) {
        PDU pdu;
        SnmpDeviceTransportConfiguration deviceTransportConfiguration = sessionContext.getDeviceTransportConfiguration();
        SnmpProtocolVersion snmpVersion = deviceTransportConfiguration.getProtocolVersion();
        switch (snmpVersion) {
            case V1: 
            case V2C: {
                pdu = new PDU();
                break;
            }
            case V3: {
                ScopedPDU scopedPdu = new ScopedPDU();
                scopedPdu.setContextName(new OctetString(deviceTransportConfiguration.getContextName()));
                scopedPdu.setContextEngineID(new OctetString(deviceTransportConfiguration.getEngineId()));
                pdu = scopedPdu;
                break;
            }
            default: {
                throw new UnsupportedOperationException("SNMP version " + snmpVersion + " is not supported");
            }
        }
        return pdu;
    }

    public JsonObject processPdus(List<PDU> pdus, List<SnmpMapping> responseMappings) {
        Map<OID, String> values = this.processPdus(pdus);
        HashMap<OID, SnmpMapping> mappings = new HashMap<OID, SnmpMapping>();
        if (responseMappings != null) {
            for (SnmpMapping mapping : responseMappings) {
                OID oid2 = new OID(mapping.getOid());
                mappings.put(oid2, mapping);
            }
        }
        JsonObject data = new JsonObject();
        values.forEach((oid, value) -> {
            log.trace("Processing variable binding: {} - {}", oid, value);
            SnmpMapping mapping = (SnmpMapping)mappings.get(oid);
            if (mapping == null) {
                log.debug("No SNMP mapping for oid {}", oid);
                return;
            }
            this.processValue(mapping.getKey(), mapping.getDataType(), (String)value, data);
        });
        return data;
    }

    public Map<OID, String> processPdus(List<PDU> pdus) {
        return pdus.stream().flatMap(pdu -> pdu.getVariableBindings().stream()).filter(Objects::nonNull).filter(variableBinding -> !(variableBinding.getVariable() instanceof Null)).collect(Collectors.toMap(VariableBinding::getOid, VariableBinding::toValueString));
    }

    public void processValue(String key, DataType dataType, String value, JsonObject result) {
        try {
            switch (dataType) {
                case STRING: 
                case JSON: {
                    result.addProperty(key, value);
                    break;
                }
                case LONG: 
                case DOUBLE: {
                    result.addProperty(key, (Number)TypeCastUtil.castToNumber((String)value).getValue());
                    break;
                }
                case BOOLEAN: {
                    if (StringUtils.equalsAnyIgnoreCase((String)value, (String[])new String[]{"true", "false"})) {
                        result.addProperty(key, Boolean.valueOf(Boolean.parseBoolean(value)));
                        break;
                    }
                    throw new IllegalArgumentException("Can't parse '" + value + "' as boolean");
                }
            }
        }
        catch (IllegalArgumentException e) {
            if (this.ignoreTypeCastErrors) {
                log.debug("Ignoring value '{}' for key '{}' because of data type mismatch ({} required)", new Object[]{value, key, dataType});
            }
            throw e;
        }
    }
}

