/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.TbTransportService;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.transport.snmp.SnmpCommunicationSpec;
import org.thingsboard.server.common.data.transport.snmp.SnmpMapping;
import org.thingsboard.server.common.data.transport.snmp.SnmpMethod;
import org.thingsboard.server.common.data.transport.snmp.config.RepeatingQueryingSnmpCommunicationConfig;
import org.thingsboard.server.common.data.transport.snmp.config.SnmpCommunicationConfig;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbSnmpTransportComponent;
import org.thingsboard.server.transport.snmp.service.PduService;
import org.thingsboard.server.transport.snmp.session.DeviceSessionContext;

@TbSnmpTransportComponent
@Service
public class SnmpTransportService
implements TbTransportService {
    private static final Logger log = LoggerFactory.getLogger(SnmpTransportService.class);
    private final TransportService transportService;
    private final PduService pduService;
    private Snmp snmp;
    private ScheduledExecutorService queryingExecutor;
    private ExecutorService responseProcessingExecutor;
    private final Map<SnmpCommunicationSpec, ResponseDataMapper> responseDataMappers = new EnumMap<SnmpCommunicationSpec, ResponseDataMapper>(SnmpCommunicationSpec.class);
    private final Map<SnmpCommunicationSpec, ResponseProcessor> responseProcessors = new EnumMap<SnmpCommunicationSpec, ResponseProcessor>(SnmpCommunicationSpec.class);
    @Value(value="${transport.snmp.response_processing.parallelism_level}")
    private Integer responseProcessingParallelismLevel;
    @Value(value="${transport.snmp.underlying_protocol}")
    private String snmpUnderlyingProtocol;

    @PostConstruct
    private void init() throws IOException {
        this.queryingExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)ThingsBoardThreadFactory.forName((String)"snmp-querying"));
        this.responseProcessingExecutor = ThingsBoardExecutors.newWorkStealingPool((int)this.responseProcessingParallelismLevel, (String)"snmp-response-processing");
        this.initializeSnmp();
        this.configureResponseDataMappers();
        this.configureResponseProcessors();
        log.info("SNMP transport service initialized");
    }

    @PreDestroy
    public void stop() {
        if (this.queryingExecutor != null) {
            this.queryingExecutor.shutdownNow();
        }
        if (this.responseProcessingExecutor != null) {
            this.responseProcessingExecutor.shutdownNow();
        }
    }

    private void initializeSnmp() throws IOException {
        DefaultUdpTransportMapping transportMapping;
        switch (this.snmpUnderlyingProtocol) {
            case "udp": {
                transportMapping = new DefaultUdpTransportMapping();
                break;
            }
            case "tcp": {
                transportMapping = new DefaultTcpTransportMapping();
                break;
            }
            default: {
                throw new IllegalArgumentException("Underlying protocol " + this.snmpUnderlyingProtocol + " for SNMP is not supported");
            }
        }
        this.snmp = new Snmp((TransportMapping)transportMapping);
        this.snmp.listen();
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
    }

    public void createQueryingTasks(DeviceSessionContext sessionContext) {
        List queryingTasks = sessionContext.getProfileTransportConfiguration().getCommunicationConfigs().stream().filter(communicationConfig -> communicationConfig instanceof RepeatingQueryingSnmpCommunicationConfig).map(config -> {
            RepeatingQueryingSnmpCommunicationConfig repeatingCommunicationConfig = (RepeatingQueryingSnmpCommunicationConfig)config;
            Long queryingFrequency = repeatingCommunicationConfig.getQueryingFrequencyMs();
            return this.queryingExecutor.scheduleWithFixedDelay(() -> {
                try {
                    if (sessionContext.isActive()) {
                        this.sendRequest(sessionContext, (SnmpCommunicationConfig)repeatingCommunicationConfig);
                    }
                }
                catch (Exception e) {
                    log.error("Failed to send SNMP request for device {}: {}", (Object)sessionContext.getDeviceId(), (Object)e.toString());
                }
            }, queryingFrequency, queryingFrequency, TimeUnit.MILLISECONDS);
        }).collect(Collectors.toList());
        sessionContext.getQueryingTasks().addAll(queryingTasks);
    }

    public void cancelQueryingTasks(DeviceSessionContext sessionContext) {
        sessionContext.getQueryingTasks().forEach(task -> task.cancel(true));
        sessionContext.getQueryingTasks().clear();
    }

    private void sendRequest(DeviceSessionContext sessionContext, SnmpCommunicationConfig communicationConfig) {
        this.sendRequest(sessionContext, communicationConfig, Collections.emptyMap());
    }

    private void sendRequest(DeviceSessionContext sessionContext, SnmpCommunicationConfig communicationConfig, Map<String, String> values) {
        PDU request = this.pduService.createPdu(sessionContext, communicationConfig, values);
        RequestInfo requestInfo = new RequestInfo(communicationConfig.getSpec(), communicationConfig.getAllMappings());
        this.sendRequest(sessionContext, request, requestInfo);
    }

    private void sendRequest(DeviceSessionContext sessionContext, PDU request, RequestInfo requestInfo) {
        if (request.size() > 0) {
            log.trace("Executing SNMP request for device {}. Variables bindings: {}", (Object)sessionContext.getDeviceId(), (Object)request.getVariableBindings());
            try {
                this.snmp.send(request, sessionContext.getTarget(), (Object)requestInfo, (ResponseListener)sessionContext);
            }
            catch (IOException e) {
                log.error("Failed to send SNMP request to device {}: {}", (Object)sessionContext.getDeviceId(), (Object)e.toString());
            }
        }
    }

    public void onAttributeUpdate(DeviceSessionContext sessionContext, TransportProtos.AttributeUpdateNotificationMsg attributeUpdateNotification) {
        sessionContext.getProfileTransportConfiguration().getCommunicationConfigs().stream().filter(config -> config.getSpec() == SnmpCommunicationSpec.SHARED_ATTRIBUTES_SETTING).findFirst().ifPresent(communicationConfig -> {
            Map<String, String> sharedAttributes = JsonConverter.toJson((TransportProtos.AttributeUpdateNotificationMsg)attributeUpdateNotification).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).isJsonPrimitive() ? ((JsonElement)entry.getValue()).getAsString() : ((JsonElement)entry.getValue()).toString()));
            this.sendRequest(sessionContext, (SnmpCommunicationConfig)communicationConfig, sharedAttributes);
        });
    }

    public void onToDeviceRpcRequest(DeviceSessionContext sessionContext, TransportProtos.ToDeviceRpcRequestMsg toDeviceRpcRequestMsg) {
        SnmpMethod snmpMethod = SnmpMethod.valueOf((String)toDeviceRpcRequestMsg.getMethodName());
        JsonObject params = JsonConverter.parse((String)toDeviceRpcRequestMsg.getParams()).getAsJsonObject();
        String key = Optional.ofNullable(params.get("key")).map(JsonElement::getAsString).orElse(null);
        String value = Optional.ofNullable(params.get("value")).map(JsonElement::getAsString).orElse(null);
        if (value == null && snmpMethod == SnmpMethod.SET) {
            throw new IllegalArgumentException("Value must be specified for SNMP method 'SET'");
        }
        SnmpCommunicationConfig communicationConfig = sessionContext.getProfileTransportConfiguration().getCommunicationConfigs().stream().filter(config -> config.getSpec() == SnmpCommunicationSpec.TO_DEVICE_RPC_REQUEST).findFirst().orElseThrow(() -> new IllegalArgumentException("No communication config found with RPC spec"));
        SnmpMapping snmpMapping = communicationConfig.getAllMappings().stream().filter(mapping -> mapping.getKey().equals(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("No SNMP mapping found in the config for specified key"));
        String oid = snmpMapping.getOid();
        DataType dataType = snmpMapping.getDataType();
        PDU request = this.pduService.createSingleVariablePdu(sessionContext, snmpMethod, oid, value, dataType);
        RequestInfo requestInfo = new RequestInfo(toDeviceRpcRequestMsg.getRequestId(), communicationConfig.getSpec(), communicationConfig.getAllMappings());
        this.sendRequest(sessionContext, request, requestInfo);
    }

    public void processResponseEvent(DeviceSessionContext sessionContext, ResponseEvent event) {
        ((Snmp)event.getSource()).cancel(event.getRequest(), (ResponseListener)sessionContext);
        if (event.getError() != null) {
            log.warn("SNMP response error: {}", (Object)event.getError().toString());
            return;
        }
        PDU response = event.getResponse();
        if (response == null) {
            log.debug("No response from SNMP device {}, requestId: {}", (Object)sessionContext.getDeviceId(), (Object)event.getRequest().getRequestID());
            return;
        }
        RequestInfo requestInfo = (RequestInfo)event.getUserObject();
        this.responseProcessingExecutor.execute(() -> this.processResponse(sessionContext, response, requestInfo));
    }

    private void processResponse(DeviceSessionContext sessionContext, PDU response, RequestInfo requestInfo) {
        ResponseProcessor responseProcessor = this.responseProcessors.get(requestInfo.getCommunicationSpec());
        if (responseProcessor == null) {
            return;
        }
        JsonObject responseData = this.responseDataMappers.get(requestInfo.getCommunicationSpec()).map(response, requestInfo);
        if (responseData.entrySet().isEmpty()) {
            log.debug("No values is the SNMP response for device {}. Request id: {}", (Object)sessionContext.getDeviceId(), (Object)response.getRequestID());
            return;
        }
        responseProcessor.process(responseData, requestInfo, sessionContext);
        this.reportActivity(sessionContext.getSessionInfo());
    }

    private void configureResponseDataMappers() {
        this.responseDataMappers.put(SnmpCommunicationSpec.TO_DEVICE_RPC_REQUEST, (pdu, requestInfo) -> {
            JsonObject responseData = new JsonObject();
            this.pduService.processPdu(pdu).forEach((oid, value) -> requestInfo.getResponseMappings().stream().filter(snmpMapping -> snmpMapping.getOid().equals(oid.toDottedString())).findFirst().ifPresent(snmpMapping -> this.pduService.processValue(snmpMapping.getKey(), snmpMapping.getDataType(), (String)value, responseData)));
            return responseData;
        });
        ResponseDataMapper defaultResponseDataMapper = (pdu, requestInfo) -> this.pduService.processPdu(pdu, requestInfo.getResponseMappings());
        Arrays.stream(SnmpCommunicationSpec.values()).forEach(communicationSpec -> this.responseDataMappers.putIfAbsent((SnmpCommunicationSpec)communicationSpec, defaultResponseDataMapper));
    }

    private void configureResponseProcessors() {
        this.responseProcessors.put(SnmpCommunicationSpec.TELEMETRY_QUERYING, (responseData, requestInfo, sessionContext) -> {
            TransportProtos.PostTelemetryMsg postTelemetryMsg = JsonConverter.convertToTelemetryProto((JsonElement)responseData);
            this.transportService.process(sessionContext.getSessionInfo(), postTelemetryMsg, null);
            log.debug("Posted telemetry for SNMP device {}: {}", (Object)sessionContext.getDeviceId(), (Object)responseData);
        });
        this.responseProcessors.put(SnmpCommunicationSpec.CLIENT_ATTRIBUTES_QUERYING, (responseData, requestInfo, sessionContext) -> {
            TransportProtos.PostAttributeMsg postAttributesMsg = JsonConverter.convertToAttributesProto((JsonElement)responseData);
            this.transportService.process(sessionContext.getSessionInfo(), postAttributesMsg, null);
            log.debug("Posted attributes for SNMP device {}: {}", (Object)sessionContext.getDeviceId(), (Object)responseData);
        });
        this.responseProcessors.put(SnmpCommunicationSpec.TO_DEVICE_RPC_REQUEST, (responseData, requestInfo, sessionContext) -> {
            TransportProtos.ToDeviceRpcResponseMsg rpcResponseMsg = TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(requestInfo.getRequestId().intValue()).setPayload(JsonConverter.toJson((JsonElement)responseData)).build();
            this.transportService.process(sessionContext.getSessionInfo(), rpcResponseMsg, null);
            log.debug("Posted RPC response {} for device {}", (Object)responseData, (Object)sessionContext.getDeviceId());
        });
    }

    private void reportActivity(TransportProtos.SessionInfoProto sessionInfo) {
        this.transportService.process(sessionInfo, TransportProtos.SubscriptionInfoProto.newBuilder().setAttributeSubscription(true).setRpcSubscription(true).setLastActivityTime(System.currentTimeMillis()).build(), TransportServiceCallback.EMPTY);
    }

    public String getName() {
        return "SNMP";
    }

    @PreDestroy
    public void shutdown() {
        log.info("Stopping SNMP transport!");
        if (this.queryingExecutor != null) {
            this.queryingExecutor.shutdownNow();
        }
        if (this.responseProcessingExecutor != null) {
            this.responseProcessingExecutor.shutdownNow();
        }
        if (this.snmp != null) {
            try {
                this.snmp.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.info("SNMP transport stopped!");
    }

    @ConstructorProperties(value={"transportService", "pduService"})
    public SnmpTransportService(TransportService transportService, PduService pduService) {
        this.transportService = transportService;
        this.pduService = pduService;
    }

    public Snmp getSnmp() {
        return this.snmp;
    }

    private static interface ResponseProcessor {
        public void process(JsonObject var1, RequestInfo var2, DeviceSessionContext var3);
    }

    private static interface ResponseDataMapper {
        public JsonObject map(PDU var1, RequestInfo var2);
    }

    private static class RequestInfo {
        private Integer requestId;
        private SnmpCommunicationSpec communicationSpec;
        private List<SnmpMapping> responseMappings;

        public RequestInfo(Integer requestId, SnmpCommunicationSpec communicationSpec, List<SnmpMapping> responseMappings) {
            this.requestId = requestId;
            this.communicationSpec = communicationSpec;
            this.responseMappings = responseMappings;
        }

        public RequestInfo(SnmpCommunicationSpec communicationSpec, List<SnmpMapping> responseMappings) {
            this.communicationSpec = communicationSpec;
            this.responseMappings = responseMappings;
        }

        public Integer getRequestId() {
            return this.requestId;
        }

        public SnmpCommunicationSpec getCommunicationSpec() {
            return this.communicationSpec;
        }

        public List<SnmpMapping> getResponseMappings() {
            return this.responseMappings;
        }

        public void setRequestId(Integer requestId) {
            this.requestId = requestId;
        }

        public void setCommunicationSpec(SnmpCommunicationSpec communicationSpec) {
            this.communicationSpec = communicationSpec;
        }

        public void setResponseMappings(List<SnmpMapping> responseMappings) {
            this.responseMappings = responseMappings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestInfo)) {
                return false;
            }
            RequestInfo other = (RequestInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$requestId = this.getRequestId();
            Integer other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !((Object)this$requestId).equals(other$requestId)) {
                return false;
            }
            SnmpCommunicationSpec this$communicationSpec = this.getCommunicationSpec();
            SnmpCommunicationSpec other$communicationSpec = other.getCommunicationSpec();
            if (this$communicationSpec == null ? other$communicationSpec != null : !this$communicationSpec.equals(other$communicationSpec)) {
                return false;
            }
            List<SnmpMapping> this$responseMappings = this.getResponseMappings();
            List<SnmpMapping> other$responseMappings = other.getResponseMappings();
            return !(this$responseMappings == null ? other$responseMappings != null : !((Object)this$responseMappings).equals(other$responseMappings));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : ((Object)$requestId).hashCode());
            SnmpCommunicationSpec $communicationSpec = this.getCommunicationSpec();
            result = result * 59 + ($communicationSpec == null ? 43 : $communicationSpec.hashCode());
            List<SnmpMapping> $responseMappings = this.getResponseMappings();
            result = result * 59 + ($responseMappings == null ? 43 : ((Object)$responseMappings).hashCode());
            return result;
        }

        public String toString() {
            return "SnmpTransportService.RequestInfo(requestId=" + this.getRequestId() + ", communicationSpec=" + this.getCommunicationSpec() + ", responseMappings=" + this.getResponseMappings() + ")";
        }
    }
}

