/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.service;

import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.event.ServiceListChangedEvent;
import org.thingsboard.server.queue.util.TbSnmpTransportComponent;
import org.thingsboard.server.transport.snmp.event.SnmpTransportListChangedEvent;
import org.thingsboard.server.transport.snmp.service.SnmpTransportService;

@TbSnmpTransportComponent
@Service
public class SnmpTransportBalancingService {
    private static final Logger log = LoggerFactory.getLogger(SnmpTransportBalancingService.class);
    private final PartitionService partitionService;
    private final ApplicationEventPublisher eventPublisher;
    private final SnmpTransportService snmpTransportService;
    private int snmpTransportsCount = 1;
    private Integer currentTransportPartitionIndex = 0;

    public void onServiceListChanged(ServiceListChangedEvent event) {
        log.trace("Got service list changed event: {}", (Object)event);
        this.recalculatePartitions(event.getOtherServices(), event.getCurrentService());
    }

    public boolean isManagedByCurrentTransport(UUID entityId) {
        boolean isManaged;
        boolean bl = isManaged = this.resolvePartitionIndexForEntity(entityId) == this.currentTransportPartitionIndex.intValue();
        if (!isManaged) {
            log.trace("Entity {} is not managed by current SNMP transport node", (Object)entityId);
        }
        return isManaged;
    }

    private int resolvePartitionIndexForEntity(UUID entityId) {
        return this.partitionService.resolvePartitionIndex(entityId, this.snmpTransportsCount);
    }

    private void recalculatePartitions(List<TransportProtos.ServiceInfo> otherServices, TransportProtos.ServiceInfo currentService) {
        log.info("Recalculating partitions for SNMP transports");
        List snmpTransports = Stream.concat(otherServices.stream(), Stream.of(currentService)).filter(service -> service.getTransportsList().contains((Object)this.snmpTransportService.getName())).sorted(Comparator.comparing(TransportProtos.ServiceInfo::getServiceId)).collect(Collectors.toList());
        log.trace("Found SNMP transports: {}", snmpTransports);
        int previousCurrentTransportPartitionIndex = this.currentTransportPartitionIndex;
        int previousSnmpTransportsCount = this.snmpTransportsCount;
        if (!snmpTransports.isEmpty()) {
            for (int i = 0; i < snmpTransports.size(); ++i) {
                if (!((TransportProtos.ServiceInfo)snmpTransports.get(i)).equals((Object)currentService)) continue;
                this.currentTransportPartitionIndex = i;
                break;
            }
            this.snmpTransportsCount = snmpTransports.size();
        }
        if (this.snmpTransportsCount != previousSnmpTransportsCount || this.currentTransportPartitionIndex != previousCurrentTransportPartitionIndex) {
            log.info("SNMP transports partitions have changed: transports count = {}, current transport partition index = {}", (Object)this.snmpTransportsCount, (Object)this.currentTransportPartitionIndex);
            this.eventPublisher.publishEvent((ApplicationEvent)new SnmpTransportListChangedEvent());
        } else {
            log.info("SNMP transports partitions have not changed");
        }
    }

    @ConstructorProperties(value={"partitionService", "eventPublisher", "snmpTransportService"})
    public SnmpTransportBalancingService(PartitionService partitionService, ApplicationEventPublisher eventPublisher, SnmpTransportService snmpTransportService) {
        this.partitionService = partitionService;
        this.eventPublisher = eventPublisher;
        this.snmpTransportService = snmpTransportService;
    }
}

