/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.snmp.service;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.device.data.SnmpDeviceTransportConfiguration;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.transport.snmp.SnmpMapping;
import org.thingsboard.server.common.data.transport.snmp.SnmpMethod;
import org.thingsboard.server.common.data.transport.snmp.SnmpProtocolVersion;
import org.thingsboard.server.common.data.transport.snmp.config.SnmpCommunicationConfig;
import org.thingsboard.server.queue.util.TbSnmpTransportComponent;
import org.thingsboard.server.transport.snmp.session.DeviceSessionContext;

@TbSnmpTransportComponent
@Service
public class PduService {
    private static final Logger log = LoggerFactory.getLogger(PduService.class);

    public PDU createPdu(DeviceSessionContext sessionContext, SnmpCommunicationConfig communicationConfig, Map<String, String> values) {
        PDU pdu = this.setUpPdu(sessionContext);
        pdu.setType(communicationConfig.getMethod().getCode());
        pdu.addAll(communicationConfig.getAllMappings().stream().filter(mapping -> values.isEmpty() || values.containsKey(mapping.getKey())).map(mapping -> Optional.ofNullable((String)values.get(mapping.getKey())).map(value -> {
            Variable variable = this.toSnmpVariable((String)value, mapping.getDataType());
            return new VariableBinding(new OID(mapping.getOid()), variable);
        }).orElseGet(() -> new VariableBinding(new OID(mapping.getOid())))).collect(Collectors.toList()));
        return pdu;
    }

    public PDU createSingleVariablePdu(DeviceSessionContext sessionContext, SnmpMethod snmpMethod, String oid, String value, DataType dataType) {
        PDU pdu = this.setUpPdu(sessionContext);
        pdu.setType(snmpMethod.getCode());
        Null variable = value == null ? Null.instance : this.toSnmpVariable(value, dataType);
        pdu.add(new VariableBinding(new OID(oid), (Variable)variable));
        return pdu;
    }

    private Variable toSnmpVariable(String value, DataType dataType) {
        OctetString variable;
        dataType = dataType == null ? DataType.STRING : dataType;
        switch (dataType) {
            case LONG: {
                try {
                    variable = new Integer32(Integer.parseInt(value));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            default: {
                variable = new OctetString(value);
            }
        }
        return variable;
    }

    private PDU setUpPdu(DeviceSessionContext sessionContext) {
        PDU pdu;
        SnmpDeviceTransportConfiguration deviceTransportConfiguration = sessionContext.getDeviceTransportConfiguration();
        SnmpProtocolVersion snmpVersion = deviceTransportConfiguration.getProtocolVersion();
        switch (snmpVersion) {
            case V1: 
            case V2C: {
                pdu = new PDU();
                break;
            }
            case V3: {
                ScopedPDU scopedPdu = new ScopedPDU();
                scopedPdu.setContextName(new OctetString(deviceTransportConfiguration.getContextName()));
                scopedPdu.setContextEngineID(new OctetString(deviceTransportConfiguration.getEngineId()));
                pdu = scopedPdu;
                break;
            }
            default: {
                throw new UnsupportedOperationException("SNMP version " + snmpVersion + " is not supported");
            }
        }
        return pdu;
    }

    public JsonObject processPdu(PDU pdu, List<SnmpMapping> responseMappings) {
        Map<OID, String> values = this.processPdu(pdu);
        HashMap<OID, SnmpMapping> mappings = new HashMap<OID, SnmpMapping>();
        if (responseMappings != null) {
            for (SnmpMapping mapping : responseMappings) {
                OID oid2 = new OID(mapping.getOid());
                mappings.put(oid2, mapping);
            }
        }
        JsonObject data = new JsonObject();
        values.forEach((oid, value) -> {
            log.trace("Processing variable binding: {} - {}", oid, value);
            SnmpMapping mapping = (SnmpMapping)mappings.get(oid);
            if (mapping == null) {
                log.debug("No SNMP mapping for oid {}", oid);
                return;
            }
            this.processValue(mapping.getKey(), mapping.getDataType(), (String)value, data);
        });
        return data;
    }

    public Map<OID, String> processPdu(PDU pdu) {
        return IntStream.range(0, pdu.size()).mapToObj(arg_0 -> ((PDU)pdu).get(arg_0)).filter(Objects::nonNull).filter(variableBinding -> !(variableBinding.getVariable() instanceof Null)).collect(Collectors.toMap(VariableBinding::getOid, VariableBinding::toValueString));
    }

    public void processValue(String key, DataType dataType, String value, JsonObject result) {
        switch (dataType) {
            case LONG: {
                result.addProperty(key, (Number)Long.parseLong(value));
                break;
            }
            case BOOLEAN: {
                result.addProperty(key, Boolean.valueOf(Boolean.parseBoolean(value)));
                break;
            }
            case DOUBLE: {
                result.addProperty(key, (Number)Double.parseDouble(value));
                break;
            }
            default: {
                result.addProperty(key, value);
            }
        }
    }
}

