/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.utils;

import com.google.api.client.util.Base64;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.ObjectLink;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mValueConverter;
import org.eclipse.leshan.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.StringUtils;

public class LwM2mValueConverterImpl
implements LwM2mValueConverter {
    private static final Logger log = LoggerFactory.getLogger(LwM2mValueConverterImpl.class);
    private static final LwM2mValueConverterImpl INSTANCE = new LwM2mValueConverterImpl();

    public static LwM2mValueConverterImpl getInstance() {
        return INSTANCE;
    }

    public Object convertValue(Object value, ResourceModel.Type currentType, ResourceModel.Type expectedType, LwM2mPath resourcePath) throws CodecException {
        if (value == null) {
            return null;
        }
        if (expectedType == null) {
            return value;
        }
        if (currentType == expectedType) {
            return value;
        }
        if (currentType == null) {
            currentType = ResourceModel.Type.OPAQUE;
        }
        block4 : switch (expectedType) {
            case INTEGER: {
                switch (currentType) {
                    case FLOAT: {
                        log.debug("Trying to convert float value [{}] to Integer", value);
                        Long longValue = ((Double)value).longValue();
                        if (((Double)value).doubleValue() == longValue.doubleValue()) {
                            return longValue;
                        }
                    }
                    case STRING: {
                        log.debug("Trying to convert String value [{}] to Integer", value);
                        return Long.parseLong((String)value);
                    }
                }
                break;
            }
            case FLOAT: {
                switch (currentType) {
                    case INTEGER: {
                        log.debug("Trying to convert integer value [{}] to float", value);
                        Double floatValue = ((Long)value).doubleValue();
                        if (((Long)value).longValue() == floatValue.longValue()) {
                            return floatValue;
                        }
                    }
                    case STRING: {
                        log.debug("Trying to convert String value [{}] to Float", value);
                        return Float.valueOf((String)value);
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (currentType) {
                    case STRING: {
                        log.debug("Trying to convert string value {} to boolean", value);
                        if (StringUtils.equalsIgnoreCase((String)((String)value), (String)"true")) {
                            return true;
                        }
                        if (!StringUtils.equalsIgnoreCase((String)((String)value), (String)"false")) break block4;
                        return false;
                    }
                    case INTEGER: {
                        log.debug("Trying to convert int value {} to boolean", value);
                        Long val = (Long)value;
                        if (val == 1L) {
                            return true;
                        }
                        if (val != 0L) break block4;
                        return false;
                    }
                }
                break;
            }
            case TIME: {
                switch (currentType) {
                    case INTEGER: {
                        log.debug("Trying to convert long value {} to date", value);
                        return new Date(((Number)value).longValue() * 1000L);
                    }
                    case STRING: {
                        log.debug("Trying to convert string value {} to date", value);
                        try {
                            return new Date(Long.decode(value.toString()));
                        }
                        catch (IllegalArgumentException e) {
                            log.debug("Unable to convert string to date", (Throwable)e);
                            throw new CodecException("Unable to convert string (%s) to date for resource %s", new Object[]{value, resourcePath});
                        }
                    }
                }
                break;
            }
            case STRING: {
                switch (currentType) {
                    case FLOAT: 
                    case INTEGER: 
                    case BOOLEAN: {
                        return String.valueOf(value);
                    }
                    case TIME: {
                        Long timeValue;
                        String DATE_FORMAT = "MMM d, yyyy HH:mm a";
                        try {
                            timeValue = ((Date)value).getTime();
                        }
                        catch (Exception e) {
                            timeValue = new BigInteger((byte[])value).longValue();
                        }
                        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
                        return formatter.format(new Date(timeValue));
                    }
                    case OPAQUE: {
                        return Hex.encodeHexString((byte[])((byte[])value));
                    }
                    case OBJLNK: {
                        return ObjectLink.decodeFromString((String)((String)value));
                    }
                }
                break;
            }
            case OPAQUE: {
                if (currentType != ResourceModel.Type.STRING) break;
                log.debug("Trying to convert hexadecimal/base64 string [{}] to byte array", value);
                try {
                    return Hex.decodeHex((char[])((String)value).toCharArray());
                }
                catch (IllegalArgumentException e) {
                    try {
                        return Base64.decodeBase64((byte[])((String)value).getBytes());
                    }
                    catch (IllegalArgumentException ea) {
                        throw new CodecException("Unable to convert hexastring or base64 [%s] to byte array for resource %s", new Object[]{value, resourcePath});
                    }
                }
            }
            case OBJLNK: {
                if (currentType != ResourceModel.Type.STRING) break;
                return ObjectLink.fromPath((String)value.toString());
            }
        }
        throw new CodecException("Invalid value type for resource %s, expected %s, got %s", new Object[]{resourcePath, expectedType, currentType});
    }
}

