/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.leshan.core.attributes.Attribute;
import org.eclipse.leshan.core.attributes.AttributeSet;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.model.ObjectLoader;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.model.StaticModel;
import org.eclipse.leshan.core.node.LwM2mMultipleResource;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.LwM2mSingleResource;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.request.SimpleDownlinkRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.Lwm2mDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.lwm2m.bootstrap.LwM2MBootstrapServerCredential;
import org.thingsboard.server.common.data.ota.OtaPackageKey;
import org.thingsboard.server.common.transport.util.JsonUtils;
import org.thingsboard.server.transport.lwm2m.config.TbLwM2mVersion;
import org.thingsboard.server.transport.lwm2m.server.LwM2mOtaConvert;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.ResourceValue;
import org.thingsboard.server.transport.lwm2m.server.downlink.HasVersionedId;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.FirmwareUpdateResult;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.FirmwareUpdateState;
import org.thingsboard.server.transport.lwm2m.server.ota.software.SoftwareUpdateResult;
import org.thingsboard.server.transport.lwm2m.server.ota.software.SoftwareUpdateState;
import org.thingsboard.server.transport.lwm2m.server.uplink.DefaultLwM2mUplinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.utils.LwM2mValueConverterImpl;

public class LwM2MTransportUtil {
    private static final Logger log = LoggerFactory.getLogger(LwM2MTransportUtil.class);
    public static final String LWM2M_OBJECT_VERSION_DEFAULT = "1.0";
    public static final String LOG_LWM2M_TELEMETRY = "transportLog";
    public static final String LOG_LWM2M_INFO = "info";
    public static final String LOG_LWM2M_ERROR = "error";
    public static final String LOG_LWM2M_WARN = "warn";
    public static final int BOOTSTRAP_DEFAULT_SHORT_ID = 0;

    public static boolean equalsResourceValue(Object valueOld, Object valueNew, ResourceModel.Type type, LwM2mPath resourcePath) throws CodecException {
        switch (type) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: {
                return String.valueOf(valueOld).equals(String.valueOf(valueNew));
            }
            case TIME: {
                return ((Date)valueOld).getTime() == ((Date)valueNew).getTime();
            }
            case STRING: 
            case OBJLNK: {
                return valueOld.equals(valueNew);
            }
            case OPAQUE: {
                return Arrays.equals(Hex.decodeHex((char[])((String)valueOld).toCharArray()), Hex.decodeHex((char[])((String)valueNew).toCharArray()));
            }
        }
        throw new CodecException("Invalid value type for resource %s, type %s", new Object[]{resourcePath, type});
    }

    public static LwM2mOtaConvert convertOtaUpdateValueToString(String pathIdVer, Object value, ResourceModel.Type currentType) {
        String path = LwM2MTransportUtil.fromVersionedIdToObjectId(pathIdVer);
        LwM2mOtaConvert lwM2mOtaConvert = new LwM2mOtaConvert();
        if (path != null) {
            if ("/5/0/3".equals(path)) {
                lwM2mOtaConvert.setCurrentType(ResourceModel.Type.STRING);
                lwM2mOtaConvert.setValue(FirmwareUpdateState.fromStateFwByCode(((Long)value).intValue()).getType());
                return lwM2mOtaConvert;
            }
            if ("/5/0/5".equals(path)) {
                lwM2mOtaConvert.setCurrentType(ResourceModel.Type.STRING);
                lwM2mOtaConvert.setValue(FirmwareUpdateResult.fromUpdateResultFwByCode(((Long)value).intValue()).getType());
                return lwM2mOtaConvert;
            }
            if ("/9/0/7".equals(path)) {
                lwM2mOtaConvert.setCurrentType(ResourceModel.Type.STRING);
                lwM2mOtaConvert.setValue(SoftwareUpdateState.fromUpdateStateSwByCode(((Long)value).intValue()).getType());
                return lwM2mOtaConvert;
            }
            if ("/9/0/9".equals(path)) {
                lwM2mOtaConvert.setCurrentType(ResourceModel.Type.STRING);
                lwM2mOtaConvert.setValue(SoftwareUpdateResult.fromUpdateResultSwByCode(((Long)value).intValue()).getType());
                return lwM2mOtaConvert;
            }
        }
        lwM2mOtaConvert.setCurrentType(currentType);
        lwM2mOtaConvert.setValue(value);
        return lwM2mOtaConvert;
    }

    public static Lwm2mDeviceProfileTransportConfiguration toLwM2MClientProfile(DeviceProfile deviceProfile) {
        DeviceProfileTransportConfiguration transportConfiguration = deviceProfile.getProfileData().getTransportConfiguration();
        if (transportConfiguration.getType().equals((Object)DeviceTransportType.LWM2M)) {
            return (Lwm2mDeviceProfileTransportConfiguration)transportConfiguration;
        }
        log.info("[{}] Received profile with invalid transport configuration: {}", (Object)deviceProfile.getId(), (Object)deviceProfile.getProfileData().getTransportConfiguration());
        throw new IllegalArgumentException("Received profile with invalid transport configuration: " + transportConfiguration.getType());
    }

    public static List<LwM2MBootstrapServerCredential> getBootstrapParametersFromThingsboard(DeviceProfile deviceProfile) {
        return LwM2MTransportUtil.toLwM2MClientProfile(deviceProfile).getBootstrap();
    }

    public static String fromVersionedIdToObjectId(String pathIdVer) {
        try {
            if (pathIdVer == null) {
                return null;
            }
            String[] keyArray = pathIdVer.split("/");
            if (keyArray.length > 1 && keyArray[1].split("_").length == 2) {
                keyArray[1] = keyArray[1].split("_")[0];
                return StringUtils.join((String[])keyArray, (String)"/");
            }
            return pathIdVer;
        }
        catch (Exception e) {
            log.debug("Issue converting path with version [{}] to path without version: ", (Object)pathIdVer, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static String getVerFromPathIdVerOrId(String path) {
        try {
            String[] keyArray = path.split("/");
            if (keyArray.length > 1) {
                String[] keyArrayVer = keyArray[1].split("_");
                return keyArrayVer.length == 2 ? keyArrayVer[1] : LWM2M_OBJECT_VERSION_DEFAULT;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String validPathIdVer(String pathIdVer, Registration registration) throws IllegalArgumentException {
        if (!pathIdVer.contains("/")) {
            throw new IllegalArgumentException(String.format("Error:", new Object[0]));
        }
        String[] keyArray = pathIdVer.split("/");
        if (keyArray.length > 1 && keyArray[1].split("_").length == 2) {
            return pathIdVer;
        }
        return LwM2MTransportUtil.convertObjectIdToVersionedId(pathIdVer, registration);
    }

    public static String convertObjectIdToVersionedId(String path, Registration registration) {
        String ver = (String)registration.getSupportedObject().get(new LwM2mPath(path).getObjectId());
        ver = ver != null ? ver : TbLwM2mVersion.VERSION_1_0.getVersion().toString();
        try {
            String[] keyArray = path.split("/");
            if (keyArray.length > 1) {
                keyArray[1] = keyArray[1] + "_" + ver;
                return StringUtils.join((String[])keyArray, (String)"/");
            }
            return path;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String validateObjectVerFromKey(String key) {
        try {
            return key.split("/")[1].split("_")[1];
        }
        catch (Exception e) {
            return LWM2M_OBJECT_VERSION_DEFAULT;
        }
    }

    public static SimpleDownlinkRequest createWriteAttributeRequest(String target, Object params, DefaultLwM2mUplinkMsgHandler serviceImpl) {
        AttributeSet attrSet = new AttributeSet(LwM2MTransportUtil.createWriteAttributes(params, serviceImpl, target));
        return attrSet.getAttributes().size() > 0 ? new WriteAttributesRequest(target, attrSet) : null;
    }

    private static Attribute[] createWriteAttributes(Object params, DefaultLwM2mUplinkMsgHandler serviceImpl, String target) {
        ArrayList attributeLists = new ArrayList();
        Map map = (Map)JacksonUtil.convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
        map.forEach((k, v) -> {
            Attribute attribute;
            Object attrValue;
            if (StringUtils.trimToNull((String)v.toString()) != null && (attrValue = LwM2MTransportUtil.convertWriteAttributes(k, v, serviceImpl, target)) != null && (attribute = LwM2MTransportUtil.createAttribute(k, attrValue)) != null) {
                attributeLists.add(new Attribute(k, attrValue));
            }
        });
        return (Attribute[])attributeLists.toArray(Attribute[]::new);
    }

    public static ResourceModel.Type equalsResourceTypeGetSimpleName(Object value) {
        switch (value.getClass().getSimpleName()) {
            case "Double": {
                return ResourceModel.Type.FLOAT;
            }
            case "Integer": {
                return ResourceModel.Type.INTEGER;
            }
            case "String": {
                return ResourceModel.Type.STRING;
            }
            case "Boolean": {
                return ResourceModel.Type.BOOLEAN;
            }
            case "byte[]": {
                return ResourceModel.Type.OPAQUE;
            }
            case "Date": {
                return ResourceModel.Type.TIME;
            }
            case "ObjectLink": {
                return ResourceModel.Type.OBJLNK;
            }
        }
        return null;
    }

    public static void validateVersionedId(LwM2mClient client, HasVersionedId request) {
        String msgExceptionStr = "";
        msgExceptionStr = request.getObjectId() == null ? "Specified object id is null!" : client.isValidObjectVersion(request.getVersionedId());
        if (!msgExceptionStr.isEmpty()) {
            throw new IllegalArgumentException(msgExceptionStr);
        }
    }

    public static Map<Integer, Object> convertMultiResourceValuesFromRpcBody(Object value, ResourceModel.Type type, String versionedId) throws Exception {
        String valueJsonStr = JacksonUtil.toString((Object)value);
        JsonElement element = JsonUtils.parse((String)valueJsonStr);
        return LwM2MTransportUtil.convertMultiResourceValuesFromJson(element, type, versionedId);
    }

    public static Map<Integer, Object> convertMultiResourceValuesFromJson(JsonElement newValProto, ResourceModel.Type type, String versionedId) {
        HashMap<Integer, Object> newValues = new HashMap<Integer, Object>();
        newValProto.getAsJsonObject().entrySet().forEach(obj -> newValues.put(Integer.valueOf((String)obj.getKey()), LwM2mValueConverterImpl.getInstance().convertValue(((JsonElement)obj.getValue()).getAsString(), ResourceModel.Type.STRING, type, new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(versionedId)))));
        return newValues;
    }

    public static Object convertWriteAttributes(String type, Object value, DefaultLwM2mUplinkMsgHandler serviceImpl, String target) {
        switch (type) {
            case "dim": {
                Long dim = (Long)serviceImpl.converter.convertValue(value, LwM2MTransportUtil.equalsResourceTypeGetSimpleName(value), ResourceModel.Type.INTEGER, new LwM2mPath(target));
                return dim >= 0L && dim <= 255L ? dim : null;
            }
            case "ver": {
                return serviceImpl.converter.convertValue(value, LwM2MTransportUtil.equalsResourceTypeGetSimpleName(value), ResourceModel.Type.STRING, new LwM2mPath(target));
            }
            case "pmin": 
            case "pmax": {
                return serviceImpl.converter.convertValue(value, LwM2MTransportUtil.equalsResourceTypeGetSimpleName(value), ResourceModel.Type.INTEGER, new LwM2mPath(target));
            }
            case "gt": 
            case "lt": 
            case "st": {
                if (value.getClass().getSimpleName().equals("String")) {
                    value = Double.valueOf((String)value);
                }
                return serviceImpl.converter.convertValue(value, LwM2MTransportUtil.equalsResourceTypeGetSimpleName(value), ResourceModel.Type.FLOAT, new LwM2mPath(target));
            }
        }
        return null;
    }

    private static Attribute createAttribute(String key, Object attrValue) {
        try {
            return new Attribute(key, attrValue);
        }
        catch (Exception e) {
            log.error("CreateAttribute, not valid parameter key: [{}], attrValue: [{}], error: [{}]", new Object[]{key, attrValue, e.getMessage()});
            return null;
        }
    }

    public static LwM2mResource getResourceValueFromLwM2MClient(LwM2mClient lwM2MClient, String path) {
        LwM2mResource lwm2mResourceValue = null;
        ResourceValue resourceValue = lwM2MClient.getResources().get(path);
        if (resourceValue != null && new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(path)).isResource()) {
            lwm2mResourceValue = lwM2MClient.getResources().get(path).getLwM2mResource();
        }
        return lwm2mResourceValue;
    }

    public static Optional<String> contentToString(Object content) {
        try {
            String value = null;
            LwM2mResource resource = null;
            String key = null;
            if (content instanceof Map) {
                Map contentAsMap = (Map)content;
                if (contentAsMap.size() == 1) {
                    for (Map.Entry kv : contentAsMap.entrySet()) {
                        if (!(kv.getValue() instanceof LwM2mResource)) continue;
                        key = kv.getKey().toString();
                        resource = (LwM2mResource)kv.getValue();
                    }
                }
            } else if (content instanceof LwM2mResource) {
                resource = (LwM2mResource)content;
            }
            if (resource != null && resource.getType() == ResourceModel.Type.OPAQUE) {
                value = LwM2MTransportUtil.opaqueResourceToString(resource, key);
            }
            value = value == null ? content.toString() : value;
            return Optional.of(value);
        }
        catch (Exception e) {
            log.debug("Failed to convert content " + content + " to string", (Throwable)e);
            return Optional.ofNullable(content != null ? content.toString() : null);
        }
    }

    private static String opaqueResourceToString(LwM2mResource resource, String key) {
        String value = null;
        StringBuilder builder = new StringBuilder();
        if (resource instanceof LwM2mSingleResource) {
            builder.append("LwM2mSingleResource");
            if (key == null) {
                builder.append(" id=").append(String.valueOf(resource.getId()));
            } else {
                builder.append(" key=").append(key);
            }
            builder.append(" value=").append(LwM2MTransportUtil.opaqueToString((byte[])resource.getValue()));
            builder.append(" type=").append(ResourceModel.Type.OPAQUE.toString());
            value = builder.toString();
        } else if (resource instanceof LwM2mMultipleResource) {
            builder.append("LwM2mMultipleResource");
            if (key == null) {
                builder.append(" id=").append(String.valueOf(resource.getId()));
            } else {
                builder.append(" key=").append(key);
            }
            builder.append(" values={");
            if (resource.getInstances().size() > 0) {
                builder.append(LwM2MTransportUtil.multiInstanceOpaqueToString((LwM2mMultipleResource)resource));
            }
            builder.append("}");
            builder.append(" type=").append(ResourceModel.Type.OPAQUE.toString());
            value = builder.toString();
        }
        return value;
    }

    private static String multiInstanceOpaqueToString(LwM2mMultipleResource resource) {
        StringBuilder builder = new StringBuilder();
        resource.getInstances().values().forEach(v -> builder.append(" id=").append(v.getId()).append(" value=").append(Hex.encodeHexString((byte[])((byte[])v.getValue()))).append(", "));
        int startInd = builder.lastIndexOf(", ");
        if (startInd > 0) {
            builder.delete(startInd, startInd + 2);
        }
        return builder.toString();
    }

    private static String opaqueToString(byte[] value) {
        String opaque = Hex.encodeHexString((byte[])value);
        return opaque.length() > 1024 ? opaque.substring(0, 1024) : opaque;
    }

    public static LwM2mModel createModelsDefault() {
        return new StaticModel((Collection)ObjectLoader.loadDefault());
    }

    public static boolean compareAttNameKeyOta(String attrName) {
        for (OtaPackageKey value : OtaPackageKey.values()) {
            if (!attrName.contains(value.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean valueEquals(Object newValue, Object oldValue) {
        String oldValueStr = oldValue instanceof byte[] ? Hex.encodeHexString((byte[])((byte[])oldValue)) : oldValue.toString();
        String newValueStr = newValue instanceof byte[] ? Hex.encodeHexString((byte[])((byte[])newValue)) : newValue.toString();
        return newValueStr.equals(oldValueStr);
    }

    public static enum LwM2MClientStrategy {
        CLIENT_STRATEGY_1(1, "Read only resources marked as observation"),
        CLIENT_STRATEGY_2(2, "Read all client resources");

        public int code;
        public String type;

        private LwM2MClientStrategy(int code, String type) {
            this.code = code;
            this.type = type;
        }

        public static LwM2MClientStrategy fromStrategyClientByType(String type) {
            for (LwM2MClientStrategy to : LwM2MClientStrategy.values()) {
                if (!to.type.equals(type)) continue;
                return to;
            }
            throw new IllegalArgumentException(String.format("Unsupported Client Strategy type  : %s", type));
        }

        public static LwM2MClientStrategy fromStrategyClientByCode(int code) {
            for (LwM2MClientStrategy to : LwM2MClientStrategy.values()) {
                if (to.code != code) continue;
                return to;
            }
            throw new IllegalArgumentException(String.format("Unsupported Client Strategy code : %s", code));
        }
    }
}

