/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.uplink;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mMultipleResource;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mObject;
import org.eclipse.leshan.core.node.LwM2mObjectInstance;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.LwM2mResourceInstance;
import org.eclipse.leshan.core.node.LwM2mSingleResource;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.SendRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.CollectionsUtil;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.profile.Lwm2mDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.lwm2m.ObjectAttributes;
import org.thingsboard.server.common.data.device.profile.lwm2m.OtherConfiguration;
import org.thingsboard.server.common.data.device.profile.lwm2m.TelemetryMappingConfiguration;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.OtaPackageUtil;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.server.LwM2mOtaConvert;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.LwM2mVersionedModelProvider;
import org.thingsboard.server.transport.lwm2m.server.attributes.LwM2MAttributesService;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MClientState;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MClientStateException;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.client.ParametersAnalyzeResult;
import org.thingsboard.server.transport.lwm2m.server.client.ResultsAddKeyValueProto;
import org.thingsboard.server.transport.lwm2m.server.common.LwM2MExecutorAwareService;
import org.thingsboard.server.transport.lwm2m.server.downlink.DownlinkRequestCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.LwM2mDownlinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MLatchCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MReadCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MReadRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteAttributesCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteAttributesRequest;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.model.LwM2MModelConfig;
import org.thingsboard.server.transport.lwm2m.server.model.LwM2MModelConfigService;
import org.thingsboard.server.transport.lwm2m.server.ota.LwM2MOtaUpdateService;
import org.thingsboard.server.transport.lwm2m.server.session.LwM2MSessionManager;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MDtlsSessionStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.utils.LwM2MTransportUtil;
import org.thingsboard.server.transport.lwm2m.utils.LwM2mValueConverterImpl;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2mUplinkMsgHandler
extends LwM2MExecutorAwareService
implements LwM2mUplinkMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2mUplinkMsgHandler.class);
    public LwM2mValueConverterImpl converter;
    private final TransportService transportService;
    private final LwM2mTransportContext context;
    private final LwM2MAttributesService attributesService;
    private final LwM2MSessionManager sessionManager;
    private final LwM2MOtaUpdateService otaService;
    private final LwM2MTransportServerConfig config;
    private final LwM2MTelemetryLogService logService;
    private final LwM2mTransportServerHelper helper;
    private final TbLwM2MDtlsSessionStore sessionStore;
    private final LwM2mClientContext clientContext;
    private final LwM2mDownlinkMsgHandler defaultLwM2MDownlinkMsgHandler;
    private final LwM2mVersionedModelProvider modelProvider;
    private final RegistrationStore registrationStore;
    private final TbLwM2mSecurityStore securityStore;
    private final LwM2MModelConfigService modelConfigService;

    public DefaultLwM2mUplinkMsgHandler(TransportService transportService, LwM2MTransportServerConfig config, LwM2mTransportServerHelper helper, LwM2mClientContext clientContext, LwM2MTelemetryLogService logService, LwM2MSessionManager sessionManager, @Lazy LwM2MOtaUpdateService otaService, @Lazy LwM2MAttributesService attributesService, @Lazy LwM2mDownlinkMsgHandler defaultLwM2MDownlinkMsgHandler, LwM2mTransportContext context, TbLwM2MDtlsSessionStore sessionStore, LwM2mVersionedModelProvider modelProvider, RegistrationStore registrationStore, TbLwM2mSecurityStore securityStore, LwM2MModelConfigService modelConfigService) {
        this.transportService = transportService;
        this.sessionManager = sessionManager;
        this.attributesService = attributesService;
        this.otaService = otaService;
        this.config = config;
        this.helper = helper;
        this.clientContext = clientContext;
        this.logService = logService;
        this.defaultLwM2MDownlinkMsgHandler = defaultLwM2MDownlinkMsgHandler;
        this.context = context;
        this.sessionStore = sessionStore;
        this.modelProvider = modelProvider;
        this.registrationStore = registrationStore;
        this.securityStore = securityStore;
        this.modelConfigService = modelConfigService;
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.context.getScheduler().scheduleAtFixedRate(this::reportActivity, (long)new Random().nextInt((int)this.config.getSessionReportTimeout()), this.config.getSessionReportTimeout(), TimeUnit.MILLISECONDS);
        this.converter = LwM2mValueConverterImpl.getInstance();
    }

    @Override
    @PreDestroy
    public void destroy() {
        super.destroy();
    }

    @Override
    protected String getExecutorName() {
        return "LwM2M uplink";
    }

    @Override
    protected int getExecutorSize() {
        return this.config.getUplinkPoolSize();
    }

    @Override
    public void onRegistered(Registration registration, Collection<Observation> previousObservations) {
        this.executor.submit(() -> {
            LwM2mClient lwM2MClient = this.clientContext.getClientByEndpoint(registration.getEndpoint());
            try {
                log.debug("[{}] [{{}] Client: create after Registration", (Object)registration.getEndpoint(), (Object)registration.getId());
                Optional<TransportProtos.SessionInfoProto> oldSessionInfo = this.clientContext.register(lwM2MClient, registration);
                if (oldSessionInfo.isPresent()) {
                    log.info("[{}] Closing old session: {}", (Object)registration.getEndpoint(), (Object)new UUID(oldSessionInfo.get().getSessionIdMSB(), oldSessionInfo.get().getSessionIdLSB()));
                    this.sessionManager.deregister(oldSessionInfo.get());
                }
                this.logService.log(lwM2MClient, "info: Client registered with registration id: " + registration.getId() + " version: " + registration.getLwM2mVersion() + " and modes: " + registration.getQueueMode() + ", " + registration.getBindingMode());
                this.sessionManager.register(lwM2MClient.getSession());
                this.initClientTelemetry(lwM2MClient);
                this.initAttributes(lwM2MClient, true);
                this.otaService.init(lwM2MClient);
                lwM2MClient.getRetryAttempts().set(0);
            }
            catch (LwM2MClientStateException stateException) {
                if (LwM2MClientState.UNREGISTERED.equals((Object)stateException.getState())) {
                    log.info("[{}] retry registration due to race condition: [{}].", (Object)registration.getEndpoint(), (Object)stateException.getState());
                    if (lwM2MClient.getRetryAttempts().incrementAndGet() <= 5) {
                        this.context.getScheduler().schedule(() -> this.onRegistered(registration, previousObservations), 1L, TimeUnit.SECONDS);
                    } else {
                        this.logService.log(lwM2MClient, "warn: Client registration failed due to retry attempts: " + lwM2MClient.getRetryAttempts().get());
                    }
                } else {
                    this.logService.log(lwM2MClient, "warn: Client registration failed due to invalid state: " + stateException.getState());
                }
            }
            catch (Throwable t) {
                log.error("[{}] endpoint [{}] error Unable registration.", (Object)registration.getEndpoint(), (Object)t);
                this.logService.log(lwM2MClient, "warn: Client registration failed due to: " + t.getMessage());
            }
        });
    }

    @Override
    public void updatedReg(Registration registration) {
        this.executor.submit(() -> {
            LwM2mClient lwM2MClient = this.clientContext.getClientByEndpoint(registration.getEndpoint());
            try {
                log.info("[{}] [{{}] Client: update after Registration", (Object)registration.getEndpoint(), (Object)registration.getId());
                this.logService.log(lwM2MClient, String.format("[%s][%s] Updated registration.", registration.getId(), registration.getSocketAddress()));
                this.clientContext.updateRegistration(lwM2MClient, registration);
                this.reportActivityAndRegister(lwM2MClient.getSession());
            }
            catch (LwM2MClientStateException stateException) {
                if (LwM2MClientState.REGISTERED.equals((Object)stateException.getState())) {
                    log.info("[{}] update registration failed because client has different registration id: [{}] {}.", new Object[]{registration.getEndpoint(), stateException.getState(), stateException.getMessage()});
                } else {
                    this.onRegistered(registration, Collections.emptyList());
                }
            }
            catch (Throwable t) {
                log.error("[{}] endpoint [{}] error Unable update registration.", (Object)registration.getEndpoint(), (Object)t);
                this.logService.log(lwM2MClient, "error" + String.format(": Client update Registration, %s", t.getMessage()));
            }
        });
    }

    @Override
    public void unReg(Registration registration, Collection<Observation> observations) {
        this.executor.submit(() -> this.doUnReg(registration, this.clientContext.getClientByEndpoint(registration.getEndpoint())));
    }

    private void doUnReg(Registration registration, LwM2mClient client) {
        try {
            this.logService.log(client, "info: Client unRegistration");
            this.clientContext.unregister(client, registration);
            TransportProtos.SessionInfoProto sessionInfo = client.getSession();
            if (sessionInfo != null) {
                this.sessionManager.deregister(sessionInfo);
                this.sessionStore.remove(registration.getEndpoint());
                log.info("Client close session: [{}] unReg [{}] name  [{}] profile ", new Object[]{registration.getId(), registration.getEndpoint(), sessionInfo.getDeviceType()});
            } else {
                log.error("Client close session: [{}] unReg [{}] name  [{}] sessionInfo ", new Object[]{registration.getId(), registration.getEndpoint(), null});
            }
        }
        catch (LwM2MClientStateException stateException) {
            log.info("[{}] delete registration: [{}] {}.", new Object[]{registration.getEndpoint(), stateException.getState(), stateException.getMessage()});
        }
        catch (Throwable t) {
            log.error("[{}] endpoint [{}] error Unable un registration.", (Object)registration.getEndpoint(), (Object)t);
            this.logService.log(client, "error" + String.format(": Client Unable un Registration, %s", t.getMessage()));
        }
    }

    @Override
    public void onSleepingDev(Registration registration) {
        log.debug("[{}] [{}] Received endpoint sleeping event", (Object)registration.getId(), (Object)registration.getEndpoint());
        this.clientContext.asleep(this.clientContext.getClientByEndpoint(registration.getEndpoint()));
    }

    @Override
    public void onUpdateValueAfterReadResponse(Registration registration, String path, ReadResponse response) {
        LwM2mNode content = response.getContent();
        if (content != null) {
            LwM2mClient lwM2MClient = this.clientContext.getClientByEndpoint(registration.getEndpoint());
            ObjectModel objectModelVersion = lwM2MClient.getObjectModel(path, this.modelProvider);
            if (objectModelVersion != null) {
                int responseCode = response.getCode().getCode();
                if (content instanceof LwM2mObject) {
                    LwM2mObject lwM2mObject = (LwM2mObject)content;
                    this.updateObjectResourceValue(lwM2MClient, lwM2mObject, path, responseCode);
                } else if (content instanceof LwM2mObjectInstance) {
                    LwM2mObjectInstance lwM2mObjectInstance = (LwM2mObjectInstance)content;
                    this.updateObjectInstanceResourceValue(lwM2MClient, lwM2mObjectInstance, path, responseCode);
                } else if (content instanceof LwM2mResource) {
                    LwM2mResource lwM2mResource = (LwM2mResource)content;
                    this.updateResourcesValue(lwM2MClient, lwM2mResource, path, WriteRequest.Mode.UPDATE, responseCode);
                }
            }
            this.tryAwake(lwM2MClient);
        }
    }

    @Override
    public void onUpdateValueAfterReadCompositeResponse(Registration registration, ReadCompositeResponse response) {
        log.trace("ReadCompositeResponse: [{}]", (Object)response);
        if (response.getContent() != null) {
            LwM2mClient lwM2MClient = this.clientContext.getClientByEndpoint(registration.getEndpoint());
            response.getContent().forEach((k, v) -> {
                if (v != null) {
                    int responseCode = response.getCode().getCode();
                    if (v instanceof LwM2mObject) {
                        this.updateObjectResourceValue(lwM2MClient, (LwM2mObject)v, k.toString(), responseCode);
                    } else if (v instanceof LwM2mObjectInstance) {
                        this.updateObjectInstanceResourceValue(lwM2MClient, (LwM2mObjectInstance)v, k.toString(), responseCode);
                    } else if (v instanceof LwM2mResource) {
                        this.updateResourcesValue(lwM2MClient, (LwM2mResource)v, k.toString(), WriteRequest.Mode.UPDATE, responseCode);
                    }
                }
            });
            this.clientContext.update(lwM2MClient);
            this.tryAwake(lwM2MClient);
        }
    }

    @Override
    public void onUpdateValueWithSendRequest(Registration registration, SendRequest sendRequest) {
        for (Map.Entry entry : sendRequest.getNodes().entrySet()) {
            String stringPath;
            LwM2mPath path = (LwM2mPath)entry.getKey();
            LwM2mNode node = (LwM2mNode)entry.getValue();
            LwM2mClient lwM2MClient = this.clientContext.getClientByEndpoint(registration.getEndpoint());
            ObjectModel objectModelVersion = lwM2MClient.getObjectModel(stringPath = LwM2MTransportUtil.convertObjectIdToVersionedId(path.toString(), registration), this.modelProvider);
            if (objectModelVersion != null) {
                if (node instanceof LwM2mObject) {
                    LwM2mObject lwM2mObject = (LwM2mObject)node;
                    this.updateObjectResourceValue(lwM2MClient, lwM2mObject, stringPath, 0);
                } else if (node instanceof LwM2mObjectInstance) {
                    LwM2mObjectInstance lwM2mObjectInstance = (LwM2mObjectInstance)node;
                    this.updateObjectInstanceResourceValue(lwM2MClient, lwM2mObjectInstance, stringPath, 0);
                } else if (node instanceof LwM2mResource) {
                    LwM2mResource lwM2mResource = (LwM2mResource)node;
                    this.updateResourcesValue(lwM2MClient, lwM2mResource, stringPath, WriteRequest.Mode.UPDATE, 0);
                }
            }
            this.tryAwake(lwM2MClient);
        }
    }

    @Override
    public void onDeviceProfileUpdate(TransportProtos.SessionInfoProto sessionInfo, DeviceProfile deviceProfile) {
        try {
            List<LwM2mClient> clients = this.clientContext.getLwM2mClients().stream().filter(e -> e.getProfileId() != null).filter(e -> e.getProfileId().equals(deviceProfile.getUuidId())).collect(Collectors.toList());
            clients.forEach(client -> {
                this.securityStore.remove(client.getEndpoint(), client.getRegistration().getId());
                client.onDeviceProfileUpdate(deviceProfile);
            });
            if (clients.size() > 0) {
                Lwm2mDeviceProfileTransportConfiguration oldProfile = this.clientContext.getProfile(deviceProfile.getUuidId());
                this.onDeviceProfileUpdate(clients, oldProfile, deviceProfile);
            }
        }
        catch (Exception e2) {
            log.warn("[{}] failed to update profile: {}", (Object)deviceProfile.getId(), (Object)deviceProfile);
        }
    }

    @Override
    public void onDeviceUpdate(TransportProtos.SessionInfoProto sessionInfo, Device device, Optional<DeviceProfile> newDeviceProfileOpt) {
        try {
            LwM2mClient client = this.clientContext.getClientByDeviceId(device.getUuidId());
            if (client != null) {
                if (newDeviceProfileOpt.isPresent()) {
                    this.securityStore.remove(client.getEndpoint(), client.getRegistration().getId());
                }
                this.onDeviceUpdate(client, device, newDeviceProfileOpt);
            }
        }
        catch (Exception e) {
            log.warn("[{}] failed to update device: {}", (Object)device.getId(), (Object)device);
        }
    }

    @Override
    public void onDeviceDelete(DeviceId deviceId) {
        this.clearAndUnregister(this.clientContext.getClientByDeviceId(deviceId.getId()));
    }

    @Override
    public void onResourceUpdate(TransportProtos.ResourceUpdateMsg resourceUpdateMsgOpt) {
        String idVer = resourceUpdateMsgOpt.getResourceKey();
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(resourceUpdateMsgOpt.getTenantIdMSB(), resourceUpdateMsgOpt.getTenantIdLSB()));
        this.modelProvider.evict(tenantId, idVer);
        this.clientContext.getLwM2mClients().forEach(e -> e.updateResourceModel(idVer, this.modelProvider));
    }

    @Override
    public void onResourceDelete(TransportProtos.ResourceDeleteMsg resourceDeleteMsgOpt) {
        String pathIdVer = resourceDeleteMsgOpt.getResourceKey();
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(resourceDeleteMsgOpt.getTenantIdMSB(), resourceDeleteMsgOpt.getTenantIdLSB()));
        this.modelProvider.evict(tenantId, pathIdVer);
        this.clientContext.getLwM2mClients().forEach(e -> e.deleteResources(pathIdVer, this.modelProvider));
    }

    @Override
    public void onAwakeDev(Registration registration) {
        log.debug("[{}] [{}] Received endpoint awake event", (Object)registration.getId(), (Object)registration.getEndpoint());
        this.clientContext.awake(this.clientContext.getClientByEndpoint(registration.getEndpoint()));
    }

    private void initClientTelemetry(LwM2mClient lwM2MClient) {
        Lwm2mDeviceProfileTransportConfiguration profile = this.clientContext.getProfile(lwM2MClient.getProfileId());
        Set<String> supportedObjects = this.clientContext.getSupportedIdVerInClient(lwM2MClient);
        if (supportedObjects != null && supportedObjects.size() > 0) {
            this.sendReadRequests(lwM2MClient, profile, supportedObjects);
            this.sendObserveRequests(lwM2MClient, profile, supportedObjects);
            this.sendWriteAttributeRequests(lwM2MClient, profile, supportedObjects);
        }
    }

    private void sendReadRequests(LwM2mClient lwM2MClient, Lwm2mDeviceProfileTransportConfiguration profile, Set<String> supportedObjects) {
        try {
            Set<Object> targetIds = new HashSet(profile.getObserveAttr().getAttribute());
            targetIds.addAll(profile.getObserveAttr().getTelemetry());
            targetIds = CollectionsUtil.diffSets((Set)profile.getObserveAttr().getObserve(), targetIds);
            targetIds = targetIds.stream().filter(target -> this.isSupportedTargetId(supportedObjects, (String)target)).collect(Collectors.toSet());
            CountDownLatch latch = new CountDownLatch(targetIds.size());
            targetIds.forEach(versionedId -> this.sendReadRequest(lwM2MClient, (String)versionedId, (DownlinkRequestCallback<ReadRequest, ReadResponse>)new TbLwM2MLatchCallback<ReadRequest, ReadResponse>(latch, new TbLwM2MReadCallback((LwM2mUplinkMsgHandler)this, this.logService, lwM2MClient, (String)versionedId))));
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("[{}] Failed to await Read requests!", (Object)lwM2MClient.getEndpoint(), (Object)e);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process read requests!", (Object)lwM2MClient.getEndpoint(), (Object)e);
            this.logService.log(lwM2MClient, "Failed to process read requests. Possible profile misconfiguration.");
        }
    }

    private void sendObserveRequests(LwM2mClient lwM2MClient, Lwm2mDeviceProfileTransportConfiguration profile, Set<String> supportedObjects) {
        try {
            Set<String> targetIds = profile.getObserveAttr().getObserve();
            targetIds = targetIds.stream().filter(target -> this.isSupportedTargetId(supportedObjects, (String)target)).collect(Collectors.toSet());
            CountDownLatch latch = new CountDownLatch(targetIds.size());
            targetIds.forEach(targetId -> this.sendObserveRequest(lwM2MClient, (String)targetId, (DownlinkRequestCallback<ObserveRequest, ObserveResponse>)new TbLwM2MLatchCallback<ObserveRequest, ObserveResponse>(latch, new TbLwM2MObserveCallback((LwM2mUplinkMsgHandler)this, this.logService, lwM2MClient, (String)targetId))));
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("[{}] Failed to await Observe requests!", (Object)lwM2MClient.getEndpoint(), (Object)e);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process observe requests!", (Object)lwM2MClient.getEndpoint(), (Object)e);
            this.logService.log(lwM2MClient, "Failed to process observe requests. Possible profile misconfiguration.");
        }
    }

    private void sendWriteAttributeRequests(LwM2mClient lwM2MClient, Lwm2mDeviceProfileTransportConfiguration profile, Set<String> supportedObjects) {
        try {
            Map<String, ObjectAttributes> attributesMap = profile.getObserveAttr().getAttributeLwm2m();
            attributesMap = attributesMap.entrySet().stream().filter(target -> this.isSupportedTargetId(supportedObjects, (String)target.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            attributesMap.forEach((targetId, params) -> this.sendWriteAttributesRequest(lwM2MClient, (String)targetId, (ObjectAttributes)params));
        }
        catch (Exception e) {
            log.error("[{}] Failed to process write attribute requests!", (Object)lwM2MClient.getEndpoint(), (Object)e);
            this.logService.log(lwM2MClient, "Failed to process write attribute requests. Possible profile misconfiguration.");
        }
    }

    private void sendReadRequest(LwM2mClient lwM2MClient, String versionedId) {
        this.sendReadRequest(lwM2MClient, versionedId, new TbLwM2MReadCallback((LwM2mUplinkMsgHandler)this, this.logService, lwM2MClient, versionedId));
    }

    private void sendReadRequest(LwM2mClient lwM2MClient, String versionedId, DownlinkRequestCallback<ReadRequest, ReadResponse> callback) {
        TbLwM2MReadRequest request = TbLwM2MReadRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(lwM2MClient)).build();
        this.defaultLwM2MDownlinkMsgHandler.sendReadRequest(lwM2MClient, request, callback);
    }

    private void sendObserveRequest(LwM2mClient lwM2MClient, String versionedId) {
        this.sendObserveRequest(lwM2MClient, versionedId, new TbLwM2MObserveCallback((LwM2mUplinkMsgHandler)this, this.logService, lwM2MClient, versionedId));
    }

    private void sendObserveRequest(LwM2mClient lwM2MClient, String versionedId, DownlinkRequestCallback<ObserveRequest, ObserveResponse> callback) {
        TbLwM2MObserveRequest request = TbLwM2MObserveRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(lwM2MClient)).build();
        this.defaultLwM2MDownlinkMsgHandler.sendObserveRequest(lwM2MClient, request, callback);
    }

    private void sendWriteAttributesRequest(LwM2mClient lwM2MClient, String targetId, ObjectAttributes params) {
        TbLwM2MWriteAttributesRequest request = TbLwM2MWriteAttributesRequest.builder().versionedId(targetId).attributes(params).timeout(this.clientContext.getRequestTimeout(lwM2MClient)).build();
        this.defaultLwM2MDownlinkMsgHandler.sendWriteAttributesRequest(lwM2MClient, request, new TbLwM2MWriteAttributesCallback(this.logService, lwM2MClient, targetId));
    }

    private void sendCancelObserveRequest(String versionedId, LwM2mClient client) {
        TbLwM2MCancelObserveRequest request = TbLwM2MCancelObserveRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(client)).build();
        this.defaultLwM2MDownlinkMsgHandler.sendCancelObserveRequest(client, request, new TbLwM2MCancelObserveCallback(this.logService, client, versionedId));
    }

    private void updateObjectResourceValue(LwM2mClient client, LwM2mObject lwM2mObject, String pathIdVer, int code) {
        LwM2mPath pathIds = new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(pathIdVer));
        lwM2mObject.getInstances().forEach((instanceId, instance) -> {
            String pathInstance = pathIds.toString() + "/" + instanceId;
            this.updateObjectInstanceResourceValue(client, (LwM2mObjectInstance)instance, pathInstance, code);
        });
    }

    private void updateObjectInstanceResourceValue(LwM2mClient client, LwM2mObjectInstance lwM2mObjectInstance, String pathIdVer, int code) {
        LwM2mPath pathIds = new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(pathIdVer));
        lwM2mObjectInstance.getResources().forEach((resourceId, resource) -> {
            String pathRez = pathIds.toString() + "/" + resourceId;
            this.updateResourcesValue(client, (LwM2mResource)resource, pathRez, WriteRequest.Mode.UPDATE, code);
        });
    }

    private void updateResourcesValue(LwM2mClient lwM2MClient, LwM2mResource lwM2mResource, String path, WriteRequest.Mode mode, int code) {
        Registration registration = lwM2MClient.getRegistration();
        if (lwM2MClient.saveResourceValue(path, lwM2mResource, this.modelProvider, mode)) {
            if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/5/0/6", registration))) {
                this.otaService.onCurrentFirmwareNameUpdate(lwM2MClient, (String)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/3/0/3", registration))) {
                this.otaService.onCurrentFirmwareVersion3Update(lwM2MClient, (String)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/5/0/7", registration))) {
                this.otaService.onCurrentFirmwareVersionUpdate(lwM2MClient, (String)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/5/0/3", registration))) {
                this.otaService.onCurrentFirmwareStateUpdate(lwM2MClient, (Long)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/5/0/5", registration))) {
                this.otaService.onCurrentFirmwareResultUpdate(lwM2MClient, (Long)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/5/0/9", registration))) {
                this.otaService.onCurrentFirmwareDeliveryMethodUpdate(lwM2MClient, (Long)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/9/0/0", registration))) {
                this.otaService.onCurrentSoftwareNameUpdate(lwM2MClient, (String)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/9/0/1", registration))) {
                this.otaService.onCurrentSoftwareVersionUpdate(lwM2MClient, (String)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/3/0/19", registration))) {
                this.otaService.onCurrentSoftwareVersion3Update(lwM2MClient, (String)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/9/0/7", registration))) {
                this.otaService.onCurrentSoftwareStateUpdate(lwM2MClient, (Long)lwM2mResource.getValue());
            } else if (path.equals(LwM2MTransportUtil.convertObjectIdToVersionedId("/9/0/9", registration))) {
                this.otaService.onCurrentSoftwareResultUpdate(lwM2MClient, (Long)lwM2mResource.getValue());
            }
            if (ResponseCode.BAD_REQUEST.getCode() > code) {
                this.updateAttrTelemetry(registration, Collections.singleton(path));
            }
        } else {
            log.error("Fail update path [{}] Resource [{}]", (Object)path, (Object)lwM2mResource);
        }
    }

    private void updateAttrTelemetry(Registration registration, Set<String> paths) {
        try {
            ResultsAddKeyValueProto results = this.getParametersFromProfile(registration, paths);
            TransportProtos.SessionInfoProto sessionInfo = this.getSessionInfoOrCloseSession(registration);
            if (results != null && sessionInfo != null) {
                if (results.getResultAttributes().size() > 0) {
                    this.helper.sendParametersOnThingsboardAttribute(results.getResultAttributes(), sessionInfo);
                }
                if (results.getResultTelemetries().size() > 0) {
                    this.helper.sendParametersOnThingsboardTelemetry(results.getResultTelemetries(), sessionInfo);
                }
            }
        }
        catch (Exception e) {
            log.error("UpdateAttrTelemetry", (Throwable)e);
        }
    }

    private boolean isSupportedTargetId(Set<String> supportedIds, String targetId) {
        String[] targetIdParts = targetId.split("/");
        if (targetIdParts.length <= 1) {
            return false;
        }
        Object targetIdSearch = targetIdParts[0];
        for (int i = 1; i < targetIdParts.length; ++i) {
            if (!supportedIds.contains(targetIdSearch = (String)targetIdSearch + "/" + targetIdParts[i])) continue;
            return true;
        }
        return false;
    }

    private ConcurrentHashMap<String, Object> getPathForWriteAttributes(JsonObject objectJson) {
        ConcurrentHashMap pathAttributes = (ConcurrentHashMap)new Gson().fromJson(objectJson.toString(), new TypeToken<ConcurrentHashMap<String, Object>>(){}.getType());
        return pathAttributes;
    }

    private void onDeviceUpdate(LwM2mClient lwM2MClient, Device device, Optional<DeviceProfile> deviceProfileOpt) {
        Lwm2mDeviceProfileTransportConfiguration oldProfile = this.clientContext.getProfile(lwM2MClient.getProfileId());
        deviceProfileOpt.ifPresent(deviceProfile -> this.onDeviceProfileUpdate(Collections.singletonList(lwM2MClient), oldProfile, (DeviceProfile)deviceProfile));
        lwM2MClient.onDeviceUpdate(device, deviceProfileOpt);
    }

    private ResultsAddKeyValueProto getParametersFromProfile(Registration registration, Set<String> path) {
        if (path != null && path.size() > 0) {
            ResultsAddKeyValueProto results = new ResultsAddKeyValueProto();
            Lwm2mDeviceProfileTransportConfiguration profile = this.clientContext.getProfile(registration);
            ArrayList<TransportProtos.KeyValueProto> resultAttributes = new ArrayList<TransportProtos.KeyValueProto>();
            profile.getObserveAttr().getAttribute().forEach(pathIdVer -> {
                TransportProtos.KeyValueProto kvAttr;
                if (path.contains(pathIdVer) && (kvAttr = this.getKvToThingsBoard((String)pathIdVer, registration)) != null) {
                    resultAttributes.add(kvAttr);
                }
            });
            ArrayList<TransportProtos.KeyValueProto> resultTelemetries = new ArrayList<TransportProtos.KeyValueProto>();
            profile.getObserveAttr().getTelemetry().forEach(pathIdVer -> {
                TransportProtos.KeyValueProto kvAttr;
                if (path.contains(pathIdVer) && (kvAttr = this.getKvToThingsBoard((String)pathIdVer, registration)) != null) {
                    resultTelemetries.add(kvAttr);
                }
            });
            if (resultAttributes.size() > 0) {
                results.setResultAttributes(resultAttributes);
            }
            if (resultTelemetries.size() > 0) {
                results.setResultTelemetries(resultTelemetries);
            }
            return results;
        }
        return null;
    }

    private TransportProtos.KeyValueProto getKvToThingsBoard(String pathIdVer, Registration registration) {
        LwM2mClient lwM2MClient = this.clientContext.getClientByEndpoint(registration.getEndpoint());
        Map names = this.clientContext.getProfile(lwM2MClient.getProfileId()).getObserveAttr().getKeyName();
        if (names != null && names.containsKey(pathIdVer)) {
            String resourceName = (String)names.get(pathIdVer);
            if (resourceName != null && !resourceName.isEmpty()) {
                try {
                    LwM2mResource resourceValue = LwM2MTransportUtil.getResourceValueFromLwM2MClient(lwM2MClient, pathIdVer);
                    if (resourceValue != null) {
                        ResourceModel.Type currentType = resourceValue.getType();
                        ResourceModel.Type expectedType = LwM2mTransportServerHelper.getResourceModelTypeEqualsKvProtoValueType(currentType, pathIdVer);
                        Object valueKvProto = null;
                        if (resourceValue.isMultiInstances()) {
                            JsonObject finalvalueKvProto = valueKvProto = new JsonObject();
                            Gson gson = new GsonBuilder().create();
                            ResourceModel.Type finalCurrentType = currentType;
                            resourceValue.getInstances().forEach((k, v) -> {
                                Object val = this.converter.convertValue(v.getValue(), finalCurrentType, expectedType, new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(pathIdVer)));
                                JsonElement element = gson.toJsonTree(val, val.getClass());
                                ((JsonObject)finalvalueKvProto).add(String.valueOf(k), element);
                            });
                            valueKvProto = gson.toJson(valueKvProto);
                        } else {
                            valueKvProto = this.converter.convertValue(resourceValue.getValue(), currentType, expectedType, new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(pathIdVer)));
                        }
                        LwM2mOtaConvert lwM2mOtaConvert = LwM2MTransportUtil.convertOtaUpdateValueToString(pathIdVer, valueKvProto, currentType);
                        valueKvProto = lwM2mOtaConvert.getValue();
                        currentType = lwM2mOtaConvert.getCurrentType();
                        return valueKvProto != null ? this.helper.getKvAttrTelemetryToThingsboard(currentType, resourceName, valueKvProto, resourceValue.isMultiInstances()) : null;
                    }
                }
                catch (Exception e) {
                    log.error("Failed to add parameters.", (Throwable)e);
                }
            }
        } else {
            log.error("Failed to add parameters. path: [{}], names: [{}]", (Object)pathIdVer, (Object)names);
        }
        return null;
    }

    @Override
    public void onWriteResponseOk(LwM2mClient client, String path, WriteRequest request, int code) {
        if (request.getNode() instanceof LwM2mResource) {
            this.updateResourcesValue(client, (LwM2mResource)request.getNode(), path, request.isReplaceRequest() ? WriteRequest.Mode.REPLACE : WriteRequest.Mode.UPDATE, code);
        } else if (request.getNode() instanceof LwM2mObjectInstance) {
            ((LwM2mObjectInstance)request.getNode()).getResources().forEach((resId, resource) -> this.updateResourcesValue(client, (LwM2mResource)resource, path + "/" + resId, request.isReplaceRequest() ? WriteRequest.Mode.REPLACE : WriteRequest.Mode.UPDATE, code));
        }
        if (request.getNode() instanceof LwM2mResource || request.getNode() instanceof LwM2mObjectInstance) {
            this.clientContext.update(client);
        }
    }

    @Override
    public void onCreateResponseOk(LwM2mClient client, String path, CreateRequest request) {
        if (request.getObjectInstances() != null && request.getObjectInstances().size() > 0) {
            request.getObjectInstances().forEach(instance -> instance.getResources());
            this.clientContext.update(client);
        }
    }

    @Override
    public void onWriteCompositeResponseOk(LwM2mClient client, WriteCompositeRequest request, int code) {
        log.trace("ReadCompositeResponse: [{}]", (Object)request.getNodes());
        request.getNodes().forEach((k, v) -> {
            if (v instanceof LwM2mSingleResource) {
                this.updateResourcesValue(client, (LwM2mResource)v, k.toString(), WriteRequest.Mode.REPLACE, code);
            } else {
                LwM2mResourceInstance resourceInstance = (LwM2mResourceInstance)v;
                LwM2mMultipleResource multipleResource = new LwM2mMultipleResource(v.getId(), resourceInstance.getType(), new LwM2mResourceInstance[]{resourceInstance});
                this.updateResourcesValue(client, (LwM2mResource)multipleResource, k.toString(), WriteRequest.Mode.REPLACE, code);
            }
        });
    }

    private void onDeviceProfileUpdate(List<LwM2mClient> clients, Lwm2mDeviceProfileTransportConfiguration oldProfile, DeviceProfile deviceProfile) {
        if (this.clientContext.profileUpdate(deviceProfile) != null) {
            TelemetryMappingConfiguration oldTelemetryParams = oldProfile.getObserveAttr();
            Set attributeSetOld = oldTelemetryParams.getAttribute();
            Set telemetrySetOld = oldTelemetryParams.getTelemetry();
            Set observeOld = oldTelemetryParams.getObserve();
            Map keyNameOld = oldTelemetryParams.getKeyName();
            Map attributeLwm2mOld = oldTelemetryParams.getAttributeLwm2m();
            Lwm2mDeviceProfileTransportConfiguration newProfile = this.clientContext.getProfile(deviceProfile.getUuidId());
            TelemetryMappingConfiguration newTelemetryParams = newProfile.getObserveAttr();
            Set attributeSetNew = newTelemetryParams.getAttribute();
            Set telemetrySetNew = newTelemetryParams.getTelemetry();
            Set observeNew = newTelemetryParams.getObserve();
            Map keyNameNew = newTelemetryParams.getKeyName();
            Map attributeLwm2mNew = newTelemetryParams.getAttributeLwm2m();
            Set observeToAdd = CollectionsUtil.diffSets((Set)observeOld, (Set)observeNew);
            Set observeToRemove = CollectionsUtil.diffSets((Set)observeNew, (Set)observeOld);
            HashSet<String> newObjectsToRead = new HashSet<String>();
            HashSet newObjectsToCancelRead = new HashSet();
            if (!attributeSetOld.equals(attributeSetNew)) {
                newObjectsToRead.addAll(CollectionsUtil.diffSets((Set)attributeSetOld, (Set)attributeSetNew));
                newObjectsToCancelRead.addAll(CollectionsUtil.diffSets((Set)attributeSetNew, (Set)attributeSetOld));
            }
            if (!telemetrySetOld.equals(telemetrySetNew)) {
                newObjectsToRead.addAll(CollectionsUtil.diffSets((Set)telemetrySetOld, (Set)telemetrySetNew));
                newObjectsToCancelRead.addAll(CollectionsUtil.diffSets((Set)telemetrySetNew, (Set)telemetrySetOld));
            }
            if (!keyNameOld.equals(keyNameNew)) {
                ParametersAnalyzeResult keyNameChange = this.getAnalyzerKeyName(keyNameOld, keyNameNew);
                newObjectsToRead.addAll(keyNameChange.getPathPostParametersAdd());
            }
            ParametersAnalyzeResult analyzerParameters = this.getAttributesAnalyzer(attributeLwm2mOld, attributeLwm2mNew);
            clients.forEach(client -> {
                LwM2MModelConfig modelConfig = new LwM2MModelConfig(client.getEndpoint());
                modelConfig.getToRead().addAll(CollectionsUtil.diffSets((Set)observeToAdd, (Set)newObjectsToRead));
                modelConfig.getToCancelRead().addAll(newObjectsToCancelRead);
                modelConfig.getToCancelObserve().addAll(observeToRemove);
                modelConfig.getToObserve().addAll(observeToAdd);
                Set<String> clientObjects = this.clientContext.getSupportedIdVerInClient((LwM2mClient)client);
                Set pathToAdd = analyzerParameters.getPathPostParametersAdd().stream().filter(target -> clientObjects.contains("/" + target.split("/")[1])).collect(Collectors.toUnmodifiableSet());
                modelConfig.getAttributesToAdd().putAll(pathToAdd.stream().collect(Collectors.toMap(t -> t, attributeLwm2mNew::get)));
                Set pathToRemove = analyzerParameters.getPathPostParametersDel().stream().filter(target -> clientObjects.contains("/" + target.split("/")[1])).collect(Collectors.toUnmodifiableSet());
                modelConfig.getAttributesToRemove().addAll(pathToRemove);
                this.modelConfigService.sendUpdates((LwM2mClient)client, modelConfig);
            });
            OtherConfiguration newLwM2mSettings = newProfile.getClientLwM2mSettings();
            OtherConfiguration oldLwM2mSettings = oldProfile.getClientLwM2mSettings();
            if (!newLwM2mSettings.getFwUpdateStrategy().equals(oldLwM2mSettings.getFwUpdateStrategy()) || StringUtils.isNotEmpty((String)newLwM2mSettings.getFwUpdateResource()) && !newLwM2mSettings.getFwUpdateResource().equals(oldLwM2mSettings.getFwUpdateResource())) {
                clients.forEach(lwM2MClient -> this.otaService.onFirmwareStrategyUpdate((LwM2mClient)lwM2MClient, newLwM2mSettings));
            }
            if (!newLwM2mSettings.getSwUpdateStrategy().equals(oldLwM2mSettings.getSwUpdateStrategy()) || StringUtils.isNotEmpty((String)newLwM2mSettings.getSwUpdateResource()) && !newLwM2mSettings.getSwUpdateResource().equals(oldLwM2mSettings.getSwUpdateResource())) {
                clients.forEach(lwM2MClient -> this.otaService.onCurrentSoftwareStrategyUpdate((LwM2mClient)lwM2MClient, newLwM2mSettings));
            }
        }
    }

    private ParametersAnalyzeResult getAnalyzerKeyName(Map<String, String> keyNameOld, Map<String, String> keyNameNew) {
        ParametersAnalyzeResult analyzerParameters = new ParametersAnalyzeResult();
        Set<String> paths = keyNameNew.entrySet().stream().filter(e -> !((String)e.getValue()).equals(keyNameOld.get(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).keySet();
        analyzerParameters.setPathPostParametersAdd(paths);
        return analyzerParameters;
    }

    private ParametersAnalyzeResult getAttributesAnalyzer(Map<String, ObjectAttributes> attributeLwm2mOld, Map<String, ObjectAttributes> attributeLwm2mNew) {
        ParametersAnalyzeResult analyzerParameters = new ParametersAnalyzeResult();
        Set<String> pathOld = attributeLwm2mOld.keySet();
        Set<String> pathNew = attributeLwm2mNew.keySet();
        analyzerParameters.setPathPostParametersAdd(pathNew.stream().filter(p -> !pathOld.contains(p)).collect(Collectors.toSet()));
        analyzerParameters.setPathPostParametersDel(pathOld.stream().filter(p -> !pathNew.contains(p)).collect(Collectors.toSet()));
        Set pathCommon = pathNew.stream().filter(pathOld::contains).collect(Collectors.toSet());
        Set pathCommonChange = pathCommon.stream().filter(p -> !((ObjectAttributes)attributeLwm2mOld.get(p)).equals(attributeLwm2mNew.get(p))).collect(Collectors.toSet());
        analyzerParameters.getPathPostParametersAdd().addAll(pathCommonChange);
        return analyzerParameters;
    }

    private void compareAndSetWriteAttributes(LwM2mClient client, ParametersAnalyzeResult analyzerParameters, Map<String, ObjectAttributes> lwm2mAttributesNew, LwM2MModelConfig modelConfig) {
    }

    @Override
    public void onToTransportUpdateCredentials(TransportProtos.SessionInfoProto sessionInfo, TransportProtos.ToTransportUpdateCredentialsProto updateCredentials) {
        log.info("[{}] updateCredentials", (Object)sessionInfo);
        this.clearAndUnregister(this.clientContext.getClientBySessionInfo(sessionInfo));
    }

    private TransportProtos.SessionInfoProto getSessionInfo(LwM2mClient lwM2MClient) {
        if (lwM2MClient != null && lwM2MClient.getSession() != null) {
            return lwM2MClient.getSession();
        }
        return null;
    }

    public TransportProtos.SessionInfoProto getSessionInfoOrCloseSession(Registration registration) {
        return this.getSessionInfo(this.clientContext.getClientByEndpoint(registration.getEndpoint()));
    }

    private void reportActivityAndRegister(TransportProtos.SessionInfoProto sessionInfo) {
        if (sessionInfo != null && !this.transportService.hasSession(sessionInfo)) {
            this.sessionManager.register(sessionInfo);
            this.reportActivitySubscription(sessionInfo);
        }
    }

    private void reportActivity() {
        this.clientContext.getLwM2mClients().forEach(client -> this.reportActivityAndRegister(client.getSession()));
    }

    public void initAttributes(LwM2mClient lwM2MClient, boolean logFailedUpdateOfNonChangedValue) {
        Map<String, String> keyNamesMap = this.getNamesFromProfileForSharedAttributes(lwM2MClient);
        if (!keyNamesMap.isEmpty()) {
            HashSet<String> keysToFetch = new HashSet<String>(keyNamesMap.values());
            keysToFetch.removeAll(OtaPackageUtil.ALL_FW_ATTRIBUTE_KEYS);
            keysToFetch.removeAll(OtaPackageUtil.ALL_SW_ATTRIBUTE_KEYS);
            DonAsynchron.withCallback(this.attributesService.getSharedAttributes(lwM2MClient, keysToFetch), v -> this.attributesService.onAttributesUpdate(lwM2MClient, (List<TransportProtos.TsKvProto>)v, logFailedUpdateOfNonChangedValue), t -> log.error("[{}] Failed to get attributes", (Object)lwM2MClient.getEndpoint(), t), (Executor)this.executor);
        }
    }

    private Map<String, String> getNamesFromProfileForSharedAttributes(LwM2mClient lwM2MClient) {
        Lwm2mDeviceProfileTransportConfiguration profile = this.clientContext.getProfile(lwM2MClient.getProfileId());
        return profile.getObserveAttr().getKeyName();
    }

    @Override
    public LwM2MTransportServerConfig getConfig() {
        return this.config;
    }

    private void reportActivitySubscription(TransportProtos.SessionInfoProto sessionInfo) {
        this.transportService.process(sessionInfo, TransportProtos.SubscriptionInfoProto.newBuilder().setAttributeSubscription(true).setRpcSubscription(true).setLastActivityTime(System.currentTimeMillis()).build(), TransportServiceCallback.EMPTY);
    }

    private void clearAndUnregister(LwM2mClient client) {
        client.lock();
        try {
            Registration registration = client.getRegistration();
            this.doUnReg(registration, client);
            this.securityStore.remove(registration.getEndpoint(), registration.getId());
            this.registrationStore.removeRegistration(registration.getId());
        }
        finally {
            client.unlock();
        }
    }

    private void tryAwake(LwM2mClient lwM2MClient) {
        if (this.clientContext.awake(lwM2MClient)) {
            log.debug("[{}] Device is awake", (Object)lwM2MClient.getEndpoint());
        } else {
            this.clientContext.update(lwM2MClient);
        }
    }
}

