/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.store;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.transport.lwm2m.server.model.LwM2MModelConfig;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MModelConfigStore;

public class TbRedisLwM2MModelConfigStore
implements TbLwM2MModelConfigStore {
    private static final Logger log = LoggerFactory.getLogger(TbRedisLwM2MModelConfigStore.class);
    private static final String MODEL_EP = "MODEL#EP#";
    private final RedisConnectionFactory connectionFactory;

    @Override
    public List<LwM2MModelConfig> getAll() {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            ArrayList<LwM2MModelConfig> configs = new ArrayList<LwM2MModelConfig>();
            ScanOptions scanOptions = ScanOptions.scanOptions().count(100L).match("MODEL#EP#*").build();
            ArrayList<Cursor> scans = new ArrayList<Cursor>();
            if (connection instanceof RedisClusterConnection) {
                ((RedisClusterConnection)connection).clusterGetNodes().forEach(node -> scans.add(((RedisClusterConnection)connection).scan(node, scanOptions)));
            } else {
                scans.add(connection.scan(scanOptions));
            }
            scans.forEach(scan -> scan.forEachRemaining(key -> {
                byte[] element = connection.get(key);
                configs.add((LwM2MModelConfig)JacksonUtil.fromBytes((byte[])element, LwM2MModelConfig.class));
            }));
            ArrayList<LwM2MModelConfig> arrayList = configs;
            return arrayList;
        }
    }

    @Override
    public void put(LwM2MModelConfig modelConfig) {
        byte[] clientSerialized = JacksonUtil.writeValueAsBytes((Object)modelConfig);
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            connection.getSet(this.getKey(modelConfig.getEndpoint()), clientSerialized);
        }
    }

    @Override
    public void remove(String endpoint) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            connection.del((byte[][])new byte[][]{this.getKey(endpoint)});
        }
    }

    private byte[] getKey(String endpoint) {
        return (MODEL_EP + endpoint).getBytes();
    }

    @ConstructorProperties(value={"connectionFactory"})
    public TbRedisLwM2MModelConfigStore(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

