/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.store;

import java.beans.ConstructorProperties;
import java.util.Optional;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.californium.registration.InMemoryRegistrationStore;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.secure.LwM2mCredentialsSecurityInfoValidator;
import org.thingsboard.server.transport.lwm2m.server.store.TbDummyLwM2MClientOtaInfoStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbDummyLwM2MClientStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbDummyLwM2MModelConfigStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbInMemorySecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbL2M2MDtlsSessionInMemoryStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MClientOtaInfoStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MClientStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MDtlsSessionRedisStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MDtlsSessionStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MModelConfigStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mRedisClientOtaInfoStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mRedisRegistrationStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mRedisSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2mSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbMainSecurityStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbRedisLwM2MClientStore;
import org.thingsboard.server.transport.lwm2m.server.store.TbRedisLwM2MModelConfigStore;

@Component
@TbLwM2mTransportComponent
public class TbLwM2mStoreFactory {
    private final Optional<TBRedisCacheConfiguration> redisConfiguration;
    private final LwM2MTransportServerConfig config;
    private final LwM2mCredentialsSecurityInfoValidator validator;

    @Bean
    private CaliforniumRegistrationStore registrationStore() {
        return this.redisConfiguration.isPresent() ? new TbLwM2mRedisRegistrationStore(this.getConnectionFactory()) : new InMemoryRegistrationStore((long)this.config.getCleanPeriodInSec());
    }

    @Bean
    private TbMainSecurityStore securityStore() {
        return new TbLwM2mSecurityStore(this.redisConfiguration.isPresent() ? new TbLwM2mRedisSecurityStore(this.getConnectionFactory()) : new TbInMemorySecurityStore(), this.validator);
    }

    @Bean
    private TbLwM2MClientStore clientStore() {
        return this.redisConfiguration.isPresent() ? new TbRedisLwM2MClientStore(this.getConnectionFactory()) : new TbDummyLwM2MClientStore();
    }

    @Bean
    private TbLwM2MModelConfigStore modelConfigStore() {
        return this.redisConfiguration.isPresent() ? new TbRedisLwM2MModelConfigStore(this.getConnectionFactory()) : new TbDummyLwM2MModelConfigStore();
    }

    @Bean
    private TbLwM2MClientOtaInfoStore otaStore() {
        return this.redisConfiguration.isPresent() ? new TbLwM2mRedisClientOtaInfoStore(this.getConnectionFactory()) : new TbDummyLwM2MClientOtaInfoStore();
    }

    @Bean
    private TbLwM2MDtlsSessionStore sessionStore() {
        return this.redisConfiguration.isPresent() ? new TbLwM2MDtlsSessionRedisStore(this.getConnectionFactory()) : new TbL2M2MDtlsSessionInMemoryStore();
    }

    private RedisConnectionFactory getConnectionFactory() {
        return this.redisConfiguration.get().redisConnectionFactory();
    }

    @ConstructorProperties(value={"redisConfiguration", "config", "validator"})
    public TbLwM2mStoreFactory(Optional<TBRedisCacheConfiguration> redisConfiguration, LwM2MTransportServerConfig config, LwM2mCredentialsSecurityInfoValidator validator) {
        this.redisConfiguration = redisConfiguration;
        this.config = config;
        this.validator = validator;
    }
}

