/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.service.DefaultTransportService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.server.LwM2mSessionMsgListener;
import org.thingsboard.server.transport.lwm2m.server.attributes.LwM2MAttributesService;
import org.thingsboard.server.transport.lwm2m.server.rpc.LwM2MRpcRequestHandler;
import org.thingsboard.server.transport.lwm2m.server.session.LwM2MSessionManager;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2MSessionManager
implements LwM2MSessionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2MSessionManager.class);
    private final TransportService transportService;
    private final LwM2MAttributesService attributesService;
    private final LwM2MRpcRequestHandler rpcHandler;
    private final LwM2mUplinkMsgHandler uplinkHandler;

    public DefaultLwM2MSessionManager(TransportService transportService, @Lazy LwM2MAttributesService attributesService, @Lazy LwM2MRpcRequestHandler rpcHandler, @Lazy LwM2mUplinkMsgHandler uplinkHandler) {
        this.transportService = transportService;
        this.attributesService = attributesService;
        this.rpcHandler = rpcHandler;
        this.uplinkHandler = uplinkHandler;
    }

    @Override
    public void register(TransportProtos.SessionInfoProto sessionInfo) {
        this.transportService.registerAsyncSession(sessionInfo, (SessionMsgListener)new LwM2mSessionMsgListener(this.uplinkHandler, this.attributesService, this.rpcHandler, sessionInfo, this.transportService));
        TransportProtos.TransportToDeviceActorMsg msg = TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(sessionInfo).setSessionEvent(DefaultTransportService.SESSION_EVENT_MSG_OPEN).setSubscribeToAttributes(DefaultTransportService.SUBSCRIBE_TO_ATTRIBUTE_UPDATES_ASYNC_MSG).setSubscribeToRPC(DefaultTransportService.SUBSCRIBE_TO_RPC_ASYNC_MSG).build();
        this.transportService.process(msg, null);
    }

    @Override
    public void deregister(TransportProtos.SessionInfoProto sessionInfo) {
        this.transportService.process(sessionInfo, DefaultTransportService.SESSION_EVENT_MSG_CLOSED, null);
        this.transportService.deregisterSession(sessionInfo);
    }
}

