/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.rpc;

import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.request.exception.ClientSleepingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.downlink.DownlinkRequestCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.LwM2MRpcResponseBody;

public abstract class RpcDownlinkRequestCallbackProxy<R, T>
implements DownlinkRequestCallback<R, T> {
    private static final Logger log = LoggerFactory.getLogger(RpcDownlinkRequestCallbackProxy.class);
    private final TransportService transportService;
    private final TransportProtos.ToDeviceRpcRequestMsg request;
    private final DownlinkRequestCallback<R, T> callback;
    protected final LwM2mClient client;

    public RpcDownlinkRequestCallbackProxy(TransportService transportService, LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, DownlinkRequestCallback<R, T> callback) {
        this.transportService = transportService;
        this.client = client;
        this.request = requestMsg;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onSent(R request) {
        this.client.lock();
        try {
            UUID rpcId = new UUID(this.request.getRequestIdMSB(), this.request.getRequestIdLSB());
            if (rpcId.equals(this.client.getLastSentRpcId())) {
                log.debug("[{}]][{}] Rpc has already sent!", (Object)this.client.getEndpoint(), (Object)rpcId);
                boolean bl = false;
                return bl;
            }
            this.client.setLastSentRpcId(rpcId);
        }
        finally {
            this.client.unlock();
        }
        this.transportService.process(this.client.getSession(), this.request, RpcStatus.SENT, TransportServiceCallback.EMPTY);
        return true;
    }

    @Override
    public void onSuccess(R request, T response) {
        this.transportService.process(this.client.getSession(), this.request, RpcStatus.DELIVERED, TransportServiceCallback.EMPTY);
        this.sendRpcReplyOnSuccess(response);
        if (this.callback != null) {
            this.callback.onSuccess(request, response);
        }
    }

    @Override
    public void onValidationError(String params, String msg) {
        this.sendRpcReplyOnValidationError(msg);
        if (this.callback != null) {
            this.callback.onValidationError(params, msg);
        }
    }

    @Override
    public void onError(String params, Exception e) {
        if (e instanceof TimeoutException || e instanceof org.eclipse.leshan.core.request.exception.TimeoutException) {
            this.client.setLastSentRpcId(null);
            this.transportService.process(this.client.getSession(), this.request, RpcStatus.TIMEOUT, TransportServiceCallback.EMPTY);
        } else if (!(e instanceof ClientSleepingException)) {
            this.sendRpcReplyOnError(e);
        }
        if (this.callback != null) {
            this.callback.onError(params, e);
        }
    }

    protected void reply(LwM2MRpcResponseBody response) {
        TransportProtos.ToDeviceRpcResponseMsg.Builder msg = TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(this.request.getRequestId());
        String responseAsString = JacksonUtil.toString((Object)response);
        if (StringUtils.isEmpty((String)response.getError())) {
            msg.setPayload(responseAsString);
        } else {
            msg.setError(responseAsString);
        }
        this.transportService.process(this.client.getSession(), msg.build(), null);
    }

    protected abstract void sendRpcReplyOnSuccess(T var1);

    protected void sendRpcReplyOnValidationError(String msg) {
        this.reply(LwM2MRpcResponseBody.builder().result(ResponseCode.BAD_REQUEST.getName()).error(msg).build());
    }

    protected void sendRpcReplyOnError(Exception e) {
        String error = e.getMessage();
        if (error == null) {
            error = e.toString();
        }
        this.reply(LwM2MRpcResponseBody.builder().result(ResponseCode.INTERNAL_SERVER_ERROR.getName()).error(error).build());
    }
}

