/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.rpc;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.response.CreateResponse;
import org.eclipse.leshan.core.response.DeleteResponse;
import org.eclipse.leshan.core.response.ExecuteResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.response.WriteAttributesResponse;
import org.eclipse.leshan.core.response.WriteCompositeResponse;
import org.eclipse.leshan.core.response.WriteResponse;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.util.JsonUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.server.LwM2MOperationType;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.downlink.LwM2mDownlinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelAllObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCreateRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCreateResponseCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDeleteCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDeleteRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDiscoverAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDiscoverCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDiscoverRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MExecuteCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MExecuteRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MReadCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MReadRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteAttributesCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteAttributesRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteReplaceRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteResponseCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteUpdateRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.composite.TbLwM2MReadCompositeCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.composite.TbLwM2MReadCompositeRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.composite.TbLwM2MWriteResponseCompositeCallback;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.rpc.LwM2MRpcRequestHandler;
import org.thingsboard.server.transport.lwm2m.server.rpc.LwM2MRpcRequestHeader;
import org.thingsboard.server.transport.lwm2m.server.rpc.LwM2MRpcResponseBody;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcCancelAllObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcCancelObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcCreateRequest;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcCreateResponseCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcDiscoverCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcEmptyResponseCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcLinkSetCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcReadResponseCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcWriteAttributesRequest;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcWriteReplaceRequest;
import org.thingsboard.server.transport.lwm2m.server.rpc.RpcWriteUpdateRequest;
import org.thingsboard.server.transport.lwm2m.server.rpc.composite.RpcReadCompositeRequest;
import org.thingsboard.server.transport.lwm2m.server.rpc.composite.RpcReadResponseCompositeCallback;
import org.thingsboard.server.transport.lwm2m.server.rpc.composite.RpcWriteCompositeRequest;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.utils.LwM2MTransportUtil;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2MRpcRequestHandler
implements LwM2MRpcRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2MRpcRequestHandler.class);
    private final TransportService transportService;
    private final LwM2mClientContext clientContext;
    private final LwM2mUplinkMsgHandler uplinkHandler;
    private final LwM2mDownlinkMsgHandler downlinkHandler;
    private final LwM2MTelemetryLogService logService;
    private final LwM2mModelProvider modelProvider;

    @Override
    public void onToDeviceRpcRequest(TransportProtos.ToDeviceRpcRequestMsg rpcRequest, TransportProtos.SessionInfoProto sessionInfo) {
        block32: {
            log.debug("Received params: {}", (Object)rpcRequest.getParams());
            try {
                LwM2MOperationType operationType = LwM2MOperationType.fromType(rpcRequest.getMethodName());
                if (operationType == null) {
                    this.sendErrorRpcResponse(sessionInfo, rpcRequest.getRequestId(), ResponseCode.METHOD_NOT_ALLOWED, "Unsupported operation type: " + rpcRequest.getMethodName());
                    return;
                }
                LwM2mClient client = this.clientContext.getClientBySessionInfo(sessionInfo);
                if (client == null) {
                    log.warn("Missing client for session: [{}]", (Object)sessionInfo);
                    return;
                }
                if (client.getRegistration() == null) {
                    this.sendErrorRpcResponse(sessionInfo, rpcRequest.getRequestId(), ResponseCode.INTERNAL_SERVER_ERROR, "Registration is empty");
                    return;
                }
                UUID rpcId = new UUID(rpcRequest.getRequestIdMSB(), rpcRequest.getRequestIdLSB());
                if (rpcId.equals(client.getLastSentRpcId())) {
                    log.debug("[{}]][{}] Rpc has already sent!", (Object)client.getEndpoint(), (Object)rpcId);
                    return;
                }
                try {
                    if (operationType.isHasObjectId()) {
                        LwM2MRpcRequestHeader header = (LwM2MRpcRequestHeader)JacksonUtil.fromString((String)rpcRequest.getParams(), LwM2MRpcRequestHeader.class);
                        String objectId = this.getIdFromParameters(client, header);
                        switch (operationType) {
                            case READ: {
                                this.sendReadRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case OBSERVE: {
                                this.sendObserveRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case DISCOVER: {
                                this.sendDiscoverRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case EXECUTE: {
                                this.sendExecuteRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case WRITE_ATTRIBUTES: {
                                this.sendWriteAttributesRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case OBSERVE_CANCEL: {
                                this.sendCancelObserveRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case DELETE: {
                                this.sendDeleteRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case WRITE_UPDATE: {
                                this.sendWriteUpdateRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case WRITE_REPLACE: {
                                this.sendWriteReplaceRequest(client, rpcRequest, objectId);
                                break;
                            }
                            case CREATE: {
                                this.sendCreateRequest(client, rpcRequest, objectId);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported operation: " + operationType.name());
                            }
                        }
                        break block32;
                    }
                    if (operationType.isComposite()) {
                        ContentFormat contentFormatComposite = this.getCompositeContentFormat(client);
                        if (contentFormatComposite != null) {
                            switch (operationType) {
                                case READ_COMPOSITE: {
                                    this.sendReadCompositeRequest(client, rpcRequest, contentFormatComposite);
                                    break block32;
                                }
                                case WRITE_COMPOSITE: {
                                    this.sendWriteCompositeRequest(client, rpcRequest, contentFormatComposite);
                                    break block32;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported operation: " + operationType.name());
                                }
                            }
                        }
                        this.sendErrorRpcResponse(sessionInfo, rpcRequest.getRequestId(), ResponseCode.INTERNAL_SERVER_ERROR, "This device does not support Composite Operation");
                        break block32;
                    }
                    switch (operationType) {
                        case OBSERVE_CANCEL_ALL: {
                            this.sendCancelAllObserveRequest(client, rpcRequest);
                            break;
                        }
                        case OBSERVE_READ_ALL: {
                            this.sendObserveAllRequest(client, rpcRequest);
                            break;
                        }
                        case DISCOVER_ALL: {
                            this.sendDiscoverAllRequest(client, rpcRequest);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported operation: " + operationType.name());
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    this.sendErrorRpcResponse(sessionInfo, rpcRequest.getRequestId(), ResponseCode.BAD_REQUEST, e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("[{}] Failed to send RPC: [{}]", new Object[]{sessionInfo, rpcRequest, e});
                this.sendErrorRpcResponse(sessionInfo, rpcRequest.getRequestId(), ResponseCode.INTERNAL_SERVER_ERROR, ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    private void sendReadRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        TbLwM2MReadRequest request = TbLwM2MReadRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MReadCallback mainCallback = new TbLwM2MReadCallback(this.uplinkHandler, this.logService, client, versionedId);
        RpcReadResponseCallback<ReadRequest, ReadResponse> rpcCallback = new RpcReadResponseCallback<ReadRequest, ReadResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendReadRequest(client, request, rpcCallback);
    }

    private void sendReadCompositeRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, ContentFormat contentFormatComposite) {
        String[] versionedIds = this.getIdsFromParameters(client, requestMsg);
        TbLwM2MReadCompositeRequest request = TbLwM2MReadCompositeRequest.builder().versionedIds(versionedIds).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MReadCompositeCallback mainCallback = new TbLwM2MReadCompositeCallback(this.uplinkHandler, this.logService, client, versionedIds);
        RpcReadResponseCompositeCallback<ReadCompositeRequest, ReadCompositeResponse> rpcCallback = new RpcReadResponseCompositeCallback<ReadCompositeRequest, ReadCompositeResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendReadCompositeRequest(client, request, rpcCallback, contentFormatComposite);
    }

    private void sendObserveRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        TbLwM2MObserveRequest request = TbLwM2MObserveRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MObserveCallback mainCallback = new TbLwM2MObserveCallback(this.uplinkHandler, this.logService, client, versionedId);
        RpcReadResponseCallback<ObserveRequest, ObserveResponse> rpcCallback = new RpcReadResponseCallback<ObserveRequest, ObserveResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendObserveRequest(client, request, rpcCallback);
    }

    private void sendObserveAllRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg) {
        TbLwM2MObserveAllRequest request = TbLwM2MObserveAllRequest.builder().timeout(this.clientContext.getRequestTimeout(client)).build();
        this.downlinkHandler.sendObserveAllRequest(client, request, new RpcLinkSetCallback<TbLwM2MObserveAllRequest, Set<String>>(this.transportService, client, requestMsg, null));
    }

    private void sendDiscoverAllRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg) {
        TbLwM2MDiscoverAllRequest request = TbLwM2MDiscoverAllRequest.builder().timeout(this.clientContext.getRequestTimeout(client)).build();
        this.downlinkHandler.sendDiscoverAllRequest(client, request, new RpcLinkSetCallback<TbLwM2MDiscoverAllRequest, List<Link>>(this.transportService, client, requestMsg, null));
    }

    private void sendDiscoverRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        TbLwM2MDiscoverRequest request = TbLwM2MDiscoverRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MDiscoverCallback mainCallback = new TbLwM2MDiscoverCallback(this.logService, client, versionedId);
        RpcDiscoverCallback rpcCallback = new RpcDiscoverCallback(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendDiscoverRequest(client, request, rpcCallback);
    }

    private void sendExecuteRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        TbLwM2MExecuteRequest downlink = TbLwM2MExecuteRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MExecuteCallback mainCallback = new TbLwM2MExecuteCallback(this.logService, client, versionedId);
        RpcEmptyResponseCallback<ExecuteRequest, ExecuteResponse> rpcCallback = new RpcEmptyResponseCallback<ExecuteRequest, ExecuteResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendExecuteRequest(client, downlink, rpcCallback);
    }

    private void sendWriteAttributesRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        RpcWriteAttributesRequest requestBody = (RpcWriteAttributesRequest)JacksonUtil.fromString((String)requestMsg.getParams(), RpcWriteAttributesRequest.class);
        TbLwM2MWriteAttributesRequest request = TbLwM2MWriteAttributesRequest.builder().versionedId(versionedId).attributes(requestBody.getAttributes()).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MWriteAttributesCallback mainCallback = new TbLwM2MWriteAttributesCallback(this.logService, client, versionedId);
        RpcEmptyResponseCallback<WriteAttributesRequest, WriteAttributesResponse> rpcCallback = new RpcEmptyResponseCallback<WriteAttributesRequest, WriteAttributesResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendWriteAttributesRequest(client, request, rpcCallback);
    }

    private void sendWriteUpdateRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        RpcWriteUpdateRequest requestBody = (RpcWriteUpdateRequest)JacksonUtil.fromString((String)requestMsg.getParams(), RpcWriteUpdateRequest.class);
        TbLwM2MWriteUpdateRequest.TbLwM2MWriteUpdateRequestBuilder builder = TbLwM2MWriteUpdateRequest.builder().versionedId(versionedId);
        builder.value(requestBody.getValue()).timeout(this.clientContext.getRequestTimeout(client));
        TbLwM2MWriteResponseCallback mainCallback = new TbLwM2MWriteResponseCallback(this.uplinkHandler, this.logService, client, versionedId);
        RpcEmptyResponseCallback<WriteRequest, WriteResponse> rpcCallback = new RpcEmptyResponseCallback<WriteRequest, WriteResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendWriteUpdateRequest(client, builder.build(), rpcCallback);
    }

    private void sendCreateRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        RpcCreateRequest requestBody = (RpcCreateRequest)JacksonUtil.fromString((String)requestMsg.getParams(), RpcCreateRequest.class);
        TbLwM2MCreateRequest.TbLwM2MCreateRequestBuilder builder = TbLwM2MCreateRequest.builder().versionedId(versionedId);
        builder.value(requestBody.getValue()).nodes(requestBody.getNodes()).timeout(this.clientContext.getRequestTimeout(client));
        TbLwM2MCreateResponseCallback mainCallback = new TbLwM2MCreateResponseCallback(this.uplinkHandler, this.logService, client, versionedId);
        RpcCreateResponseCallback<CreateRequest, CreateResponse> rpcCallback = new RpcCreateResponseCallback<CreateRequest, CreateResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendCreateRequest(client, builder.build(), rpcCallback);
    }

    private void sendWriteReplaceRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        ResourceModel resourceModel;
        RpcWriteReplaceRequest requestBody = (RpcWriteReplaceRequest)JacksonUtil.fromString((String)requestMsg.getParams(), RpcWriteReplaceRequest.class);
        LwM2mPath path = new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(versionedId));
        if (path.isResource() && (resourceModel = client.getResourceModel(versionedId, this.modelProvider)) != null && resourceModel.multiple.booleanValue()) {
            try {
                Map<Integer, Object> value = LwM2MTransportUtil.convertMultiResourceValuesFromRpcBody(requestBody.getValue(), resourceModel.type, versionedId);
                requestBody.setValue(value);
            }
            catch (Exception value) {
                // empty catch block
            }
        }
        TbLwM2MWriteReplaceRequest request = TbLwM2MWriteReplaceRequest.builder().versionedId(versionedId).value(requestBody.getValue()).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MWriteResponseCallback mainCallback = new TbLwM2MWriteResponseCallback(this.uplinkHandler, this.logService, client, versionedId);
        RpcEmptyResponseCallback<WriteRequest, WriteResponse> rpcCallback = new RpcEmptyResponseCallback<WriteRequest, WriteResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendWriteReplaceRequest(client, request, rpcCallback);
    }

    private void sendWriteCompositeRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, ContentFormat contentFormatComposite) {
        RpcWriteCompositeRequest rpcWriteCompositeRequest = (RpcWriteCompositeRequest)JacksonUtil.fromString((String)requestMsg.getParams(), RpcWriteCompositeRequest.class);
        Map<String, Object> validNodes = this.validateNodes(client, rpcWriteCompositeRequest.getNodes());
        if (validNodes.size() <= 0) {
            throw new IllegalArgumentException(String.format("nodes: %s is not validate value", rpcWriteCompositeRequest.getNodes().toString()));
        }
        rpcWriteCompositeRequest.setNodes(validNodes);
        TbLwM2MWriteResponseCompositeCallback mainCallback = new TbLwM2MWriteResponseCompositeCallback(this.uplinkHandler, this.logService, client, null);
        RpcEmptyResponseCallback<WriteCompositeRequest, WriteCompositeResponse> rpcCallback = new RpcEmptyResponseCallback<WriteCompositeRequest, WriteCompositeResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendWriteCompositeRequest(client, rpcWriteCompositeRequest, rpcCallback, contentFormatComposite);
    }

    private Map<String, Object> validateNodes(LwM2mClient client, Map<String, Object> nodes) {
        LinkedHashMap<String, Object> newNodes = new LinkedHashMap<String, Object>();
        nodes.forEach((key, value) -> {
            block7: {
                String versionedId;
                try {
                    LwM2mPath path = new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(key));
                    if (!path.isResource() && !path.isResourceInstance()) {
                        throw new IllegalArgumentException(String.format("nodes: %s is not validate value. The WriteComposite operation is only used for SingleResources or/and ResourceInstance.", nodes.toString()));
                    }
                    versionedId = key;
                }
                catch (Exception e) {
                    versionedId = this.clientContext.getObjectIdByKeyNameFromProfile(client, (String)key);
                }
                try {
                    JsonElement element = JsonUtils.parse((String)value.toString());
                    if (!element.isJsonNull() && !element.isJsonPrimitive()) {
                        throw new IllegalArgumentException(String.format("nodes: %s is not validate value. The WriteComposite operation is only used for SingleResources or/and ResourceInstance.", nodes.toString()));
                    }
                    if (versionedId != null) {
                        newNodes.put(LwM2MTransportUtil.fromVersionedIdToObjectId(versionedId), value);
                    }
                }
                catch (JsonSyntaxException jse) {
                    if (versionedId == null) break block7;
                    newNodes.put(LwM2MTransportUtil.fromVersionedIdToObjectId(versionedId), value);
                }
            }
        });
        return newNodes;
    }

    private void sendCancelObserveRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        TbLwM2MCancelObserveRequest downlink = TbLwM2MCancelObserveRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MCancelObserveCallback mainCallback = new TbLwM2MCancelObserveCallback(this.logService, client, versionedId);
        RpcCancelObserveCallback rpcCallback = new RpcCancelObserveCallback(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendCancelObserveRequest(client, downlink, rpcCallback);
    }

    private void sendDeleteRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg, String versionedId) {
        TbLwM2MDeleteRequest downlink = TbLwM2MDeleteRequest.builder().versionedId(versionedId).timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MDeleteCallback mainCallback = new TbLwM2MDeleteCallback(this.logService, client, versionedId);
        RpcEmptyResponseCallback<DeleteRequest, DeleteResponse> rpcCallback = new RpcEmptyResponseCallback<DeleteRequest, DeleteResponse>(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendDeleteRequest(client, downlink, rpcCallback);
    }

    private void sendCancelAllObserveRequest(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg requestMsg) {
        TbLwM2MCancelAllRequest downlink = TbLwM2MCancelAllRequest.builder().timeout(this.clientContext.getRequestTimeout(client)).build();
        TbLwM2MCancelAllObserveCallback mainCallback = new TbLwM2MCancelAllObserveCallback(this.logService, client);
        RpcCancelAllObserveCallback rpcCallback = new RpcCancelAllObserveCallback(this.transportService, client, requestMsg, mainCallback);
        this.downlinkHandler.sendCancelAllRequest(client, downlink, rpcCallback);
    }

    private String getIdFromParameters(LwM2mClient client, LwM2MRpcRequestHeader header) {
        String targetId;
        if (StringUtils.isNotEmpty((String)header.getKey())) {
            targetId = this.clientContext.getObjectIdByKeyNameFromProfile(client, header.getKey());
        } else if (StringUtils.isNotEmpty((String)header.getId())) {
            targetId = header.getId();
        } else {
            throw new IllegalArgumentException("Can't find 'key' or 'id' in the requestParams parameters!");
        }
        return targetId;
    }

    private String[] getIdsFromParameters(LwM2mClient client, TransportProtos.ToDeviceRpcRequestMsg rpcRequest) {
        RpcReadCompositeRequest requestParams = (RpcReadCompositeRequest)JacksonUtil.fromString((String)rpcRequest.getParams(), RpcReadCompositeRequest.class);
        if (requestParams.getKeys() != null && requestParams.getKeys().length > 0) {
            ConcurrentHashMap.KeySetView targetIds = ConcurrentHashMap.newKeySet();
            for (String key : requestParams.getKeys()) {
                String targetId = this.clientContext.getObjectIdByKeyNameFromProfile(client, key);
                if (targetId == null) continue;
                targetIds.add(targetId);
            }
            return (String[])targetIds.toArray(String[]::new);
        }
        if (requestParams.getIds() != null && requestParams.getIds().length > 0) {
            return requestParams.getIds();
        }
        throw new IllegalArgumentException("Can't find 'key' or 'id' in the requestParams parameters!");
    }

    private void sendErrorRpcResponse(TransportProtos.SessionInfoProto sessionInfo, int requestId, ResponseCode result, String error) {
        String payload = JacksonUtil.toString((Object)LwM2MRpcResponseBody.builder().result(result.getName()).error(error).build());
        TransportProtos.ToDeviceRpcResponseMsg msg = TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(requestId).setError(payload).build();
        this.transportService.process(sessionInfo, msg, null);
    }

    @Override
    public void onToDeviceRpcResponse(TransportProtos.ToDeviceRpcResponseMsg toDeviceResponse, TransportProtos.SessionInfoProto sessionInfo) {
        log.debug("OnToDeviceRpcResponse: [{}], sessionUUID: [{}]", (Object)toDeviceResponse, (Object)new UUID(sessionInfo.getSessionIdMSB(), sessionInfo.getSessionIdLSB()));
        this.transportService.process(sessionInfo, toDeviceResponse, null);
    }

    @Override
    public void onToServerRpcResponse(TransportProtos.ToServerRpcResponseMsg toServerResponse) {
        log.info("[{}] toServerRpcResponse", (Object)toServerResponse);
    }

    private ContentFormat getCompositeContentFormat(LwM2mClient client) {
        if (client.getClientSupportContentFormats().contains(ContentFormat.SENML_JSON)) {
            return ContentFormat.SENML_JSON;
        }
        if (client.getClientSupportContentFormats().contains(ContentFormat.SENML_CBOR)) {
            return ContentFormat.SENML_CBOR;
        }
        return null;
    }

    @ConstructorProperties(value={"transportService", "clientContext", "uplinkHandler", "downlinkHandler", "logService", "modelProvider"})
    public DefaultLwM2MRpcRequestHandler(TransportService transportService, LwM2mClientContext clientContext, LwM2mUplinkMsgHandler uplinkHandler, LwM2mDownlinkMsgHandler downlinkHandler, LwM2MTelemetryLogService logService, LwM2mModelProvider modelProvider) {
        this.transportService = transportService;
        this.clientContext = clientContext;
        this.uplinkHandler = uplinkHandler;
        this.downlinkHandler = downlinkHandler;
        this.logService = logService;
        this.modelProvider = modelProvider;
    }
}

