/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.ota.software;

public enum LwM2MSoftwareUpdateStrategy {
    BINARY(1, "ObjectId 9, Binary"),
    TEMP_URL(2, "ObjectId 9, URI");

    public int code;
    public String type;

    private LwM2MSoftwareUpdateStrategy(int code, String type) {
        this.code = code;
        this.type = type;
    }

    public static LwM2MSoftwareUpdateStrategy fromStrategySwByType(String type) {
        for (LwM2MSoftwareUpdateStrategy to : LwM2MSoftwareUpdateStrategy.values()) {
            if (!to.type.equals(type)) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported SW Strategy type  : %s", type));
    }

    public static LwM2MSoftwareUpdateStrategy fromStrategySwByCode(int code) {
        for (LwM2MSoftwareUpdateStrategy to : LwM2MSoftwareUpdateStrategy.values()) {
            if (to.code != code) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported SW Strategy code : %s", code));
    }
}

