/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.ota.firmware;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.transport.lwm2m.server.ota.LwM2MClientOtaInfo;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.FirmwareUpdateResult;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.FirmwareUpdateState;
import org.thingsboard.server.transport.lwm2m.server.ota.firmware.LwM2MFirmwareUpdateStrategy;

public class LwM2MClientFwOtaInfo
extends LwM2MClientOtaInfo<LwM2MFirmwareUpdateStrategy, FirmwareUpdateState, FirmwareUpdateResult> {
    private Integer deliveryMethod;

    public LwM2MClientFwOtaInfo(String endpoint, String baseUrl, LwM2MFirmwareUpdateStrategy strategy) {
        super(endpoint, baseUrl, strategy);
    }

    @Override
    @JsonIgnore
    public OtaPackageType getType() {
        return OtaPackageType.FIRMWARE;
    }

    @Override
    public void update(FirmwareUpdateResult result) {
        this.result = result;
        switch (result) {
            case INITIAL: {
                break;
            }
            case UPDATE_SUCCESSFULLY: {
                this.retryAttempts = 0;
                break;
            }
            default: {
                this.failedPackageId = LwM2MClientFwOtaInfo.getPackageId(this.targetName, this.targetVersion);
            }
        }
    }

    public Integer getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(Integer deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2MClientFwOtaInfo)) {
            return false;
        }
        LwM2MClientFwOtaInfo other = (LwM2MClientFwOtaInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$deliveryMethod = this.getDeliveryMethod();
        Integer other$deliveryMethod = other.getDeliveryMethod();
        return !(this$deliveryMethod == null ? other$deliveryMethod != null : !((Object)this$deliveryMethod).equals(other$deliveryMethod));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LwM2MClientFwOtaInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $deliveryMethod = this.getDeliveryMethod();
        result = result * 59 + ($deliveryMethod == null ? 43 : ((Object)$deliveryMethod).hashCode());
        return result;
    }

    public LwM2MClientFwOtaInfo() {
    }

    @Override
    public String toString() {
        return "LwM2MClientFwOtaInfo(super=" + super.toString() + ", deliveryMethod=" + this.getDeliveryMethod() + ")";
    }
}

