/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.ota.firmware;

public enum FirmwareUpdateState {
    IDLE(0, "Idle"),
    DOWNLOADING(1, "Downloading"),
    DOWNLOADED(2, "Downloaded"),
    UPDATING(3, "Updating");

    private int code;
    private String type;

    private FirmwareUpdateState(int code, String type) {
        this.code = code;
        this.type = type;
    }

    public static FirmwareUpdateState fromStateFwByType(String type) {
        for (FirmwareUpdateState to : FirmwareUpdateState.values()) {
            if (!to.type.equals(type)) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported FW State type  : %s", type));
    }

    public static FirmwareUpdateState fromStateFwByCode(int code) {
        for (FirmwareUpdateState to : FirmwareUpdateState.values()) {
            if (to.code != code) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported FW State code : %s", code));
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }
}

