/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.ota.firmware;

public enum FirmwareUpdateResult {
    INITIAL(0, "Initial value", false),
    UPDATE_SUCCESSFULLY(1, "Firmware updated successfully", false),
    NOT_ENOUGH(2, "Not enough flash memory for the new firmware package", false),
    OUT_OFF_MEMORY(3, "Out of RAM during downloading process", false),
    CONNECTION_LOST(4, "Connection lost during downloading process", true),
    INTEGRITY_CHECK_FAILURE(5, "Integrity check failure for new downloaded package", true),
    UNSUPPORTED_TYPE(6, "Unsupported package type", false),
    INVALID_URI(7, "Invalid URI", false),
    UPDATE_FAILED(8, "Firmware update failed", false),
    UNSUPPORTED_PROTOCOL(9, "Unsupported protocol", false);

    private int code;
    private String type;
    private boolean again;

    private FirmwareUpdateResult(int code, String type, boolean isAgain) {
        this.code = code;
        this.type = type;
        this.again = isAgain;
    }

    public static FirmwareUpdateResult fromUpdateResultFwByType(String type) {
        for (FirmwareUpdateResult to : FirmwareUpdateResult.values()) {
            if (!to.type.equals(type)) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported FW Update Result type  : %s", type));
    }

    public static FirmwareUpdateResult fromUpdateResultFwByCode(int code) {
        for (FirmwareUpdateResult to : FirmwareUpdateResult.values()) {
            if (to.code != code) continue;
            return to;
        }
        throw new IllegalArgumentException(String.format("Unsupported FW Update Result code  : %s", code));
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAgain() {
        return this.again;
    }
}

