/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.ota;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.ota.OtaPackageUpdateStatus;

public abstract class LwM2MClientOtaInfo<Strategy, State, Result> {
    private String endpoint;
    private String baseUrl;
    protected String targetName;
    protected String targetVersion;
    protected String targetTag;
    protected String targetUrl;
    protected Strategy strategy;
    protected State updateState;
    protected Result result;
    protected OtaPackageUpdateStatus status;
    protected String failedPackageId;
    protected int retryAttempts;
    protected String currentName;
    protected String currentVersion3;
    protected String currentVersion;

    public LwM2MClientOtaInfo(String endpoint, String baseUrl, Strategy strategy) {
        this.endpoint = endpoint;
        this.baseUrl = baseUrl;
        this.strategy = strategy;
    }

    public void updateTarget(String targetName, String targetVersion, Optional<String> newTargetUrl, Optional<String> newTargetTag) {
        this.targetName = targetName;
        this.targetVersion = targetVersion;
        this.targetUrl = newTargetUrl.orElse(null);
        this.targetTag = newTargetTag.orElse(null);
    }

    @JsonIgnore
    public boolean isUpdateRequired() {
        if (StringUtils.isEmpty((String)this.targetName) || StringUtils.isEmpty((String)this.targetVersion) || !this.isSupported()) {
            return false;
        }
        String targetPackageId = LwM2MClientOtaInfo.getPackageId(this.targetName, this.targetVersion);
        String currentPackageId = LwM2MClientOtaInfo.getPackageId(this.currentName, this.currentVersion);
        if (StringUtils.isNotEmpty((String)this.failedPackageId) && this.failedPackageId.equals(targetPackageId)) {
            return false;
        }
        if (targetPackageId.equals(currentPackageId)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)this.targetTag) && this.targetTag.equals(currentPackageId)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)this.currentVersion3)) {
            if (StringUtils.isNotEmpty((String)this.targetTag) && this.currentVersion3.contains(this.targetTag)) {
                return false;
            }
            return !this.currentVersion3.contains(targetPackageId);
        }
        return true;
    }

    @JsonIgnore
    public boolean isSupported() {
        return StringUtils.isNotEmpty((String)this.currentName) || StringUtils.isNotEmpty((String)this.currentVersion) || StringUtils.isNotEmpty((String)this.currentVersion3);
    }

    @JsonIgnore
    public boolean isAssigned() {
        return StringUtils.isNotEmpty((String)this.targetName) && StringUtils.isNotEmpty((String)this.targetVersion);
    }

    public abstract void update(Result var1);

    protected static String getPackageId(String name, String version) {
        return (StringUtils.isNotEmpty((String)name) ? name : "") + (StringUtils.isNotEmpty((String)version) ? version : "");
    }

    public abstract OtaPackageType getType();

    @JsonIgnore
    public String getTargetPackageId() {
        return LwM2MClientOtaInfo.getPackageId(this.targetName, this.targetVersion);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public String getTargetTag() {
        return this.targetTag;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public State getUpdateState() {
        return this.updateState;
    }

    public Result getResult() {
        return this.result;
    }

    public OtaPackageUpdateStatus getStatus() {
        return this.status;
    }

    public String getFailedPackageId() {
        return this.failedPackageId;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public String getCurrentName() {
        return this.currentName;
    }

    public String getCurrentVersion3() {
        return this.currentVersion3;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public void setTargetTag(String targetTag) {
        this.targetTag = targetTag;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public void setUpdateState(State updateState) {
        this.updateState = updateState;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void setStatus(OtaPackageUpdateStatus status) {
        this.status = status;
    }

    public void setFailedPackageId(String failedPackageId) {
        this.failedPackageId = failedPackageId;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setCurrentName(String currentName) {
        this.currentName = currentName;
    }

    public void setCurrentVersion3(String currentVersion3) {
        this.currentVersion3 = currentVersion3;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2MClientOtaInfo)) {
            return false;
        }
        LwM2MClientOtaInfo other = (LwM2MClientOtaInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$targetName = this.getTargetName();
        String other$targetName = other.getTargetName();
        if (this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName)) {
            return false;
        }
        String this$targetVersion = this.getTargetVersion();
        String other$targetVersion = other.getTargetVersion();
        if (this$targetVersion == null ? other$targetVersion != null : !this$targetVersion.equals(other$targetVersion)) {
            return false;
        }
        String this$targetTag = this.getTargetTag();
        String other$targetTag = other.getTargetTag();
        if (this$targetTag == null ? other$targetTag != null : !this$targetTag.equals(other$targetTag)) {
            return false;
        }
        String this$targetUrl = this.getTargetUrl();
        String other$targetUrl = other.getTargetUrl();
        if (this$targetUrl == null ? other$targetUrl != null : !this$targetUrl.equals(other$targetUrl)) {
            return false;
        }
        Strategy this$strategy = this.getStrategy();
        Strategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy)) {
            return false;
        }
        State this$updateState = this.getUpdateState();
        State other$updateState = other.getUpdateState();
        if (this$updateState == null ? other$updateState != null : !this$updateState.equals(other$updateState)) {
            return false;
        }
        Result this$result = this.getResult();
        Result other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        OtaPackageUpdateStatus this$status = this.getStatus();
        OtaPackageUpdateStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$failedPackageId = this.getFailedPackageId();
        String other$failedPackageId = other.getFailedPackageId();
        if (this$failedPackageId == null ? other$failedPackageId != null : !this$failedPackageId.equals(other$failedPackageId)) {
            return false;
        }
        String this$currentName = this.getCurrentName();
        String other$currentName = other.getCurrentName();
        if (this$currentName == null ? other$currentName != null : !this$currentName.equals(other$currentName)) {
            return false;
        }
        String this$currentVersion3 = this.getCurrentVersion3();
        String other$currentVersion3 = other.getCurrentVersion3();
        if (this$currentVersion3 == null ? other$currentVersion3 != null : !this$currentVersion3.equals(other$currentVersion3)) {
            return false;
        }
        String this$currentVersion = this.getCurrentVersion();
        String other$currentVersion = other.getCurrentVersion();
        return !(this$currentVersion == null ? other$currentVersion != null : !this$currentVersion.equals(other$currentVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2MClientOtaInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryAttempts();
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
        String $targetVersion = this.getTargetVersion();
        result = result * 59 + ($targetVersion == null ? 43 : $targetVersion.hashCode());
        String $targetTag = this.getTargetTag();
        result = result * 59 + ($targetTag == null ? 43 : $targetTag.hashCode());
        String $targetUrl = this.getTargetUrl();
        result = result * 59 + ($targetUrl == null ? 43 : $targetUrl.hashCode());
        Strategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        State $updateState = this.getUpdateState();
        result = result * 59 + ($updateState == null ? 43 : $updateState.hashCode());
        Result $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        OtaPackageUpdateStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $failedPackageId = this.getFailedPackageId();
        result = result * 59 + ($failedPackageId == null ? 43 : $failedPackageId.hashCode());
        String $currentName = this.getCurrentName();
        result = result * 59 + ($currentName == null ? 43 : $currentName.hashCode());
        String $currentVersion3 = this.getCurrentVersion3();
        result = result * 59 + ($currentVersion3 == null ? 43 : $currentVersion3.hashCode());
        String $currentVersion = this.getCurrentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : $currentVersion.hashCode());
        return result;
    }

    public String toString() {
        return "LwM2MClientOtaInfo(endpoint=" + this.getEndpoint() + ", baseUrl=" + this.getBaseUrl() + ", targetName=" + this.getTargetName() + ", targetVersion=" + this.getTargetVersion() + ", targetTag=" + this.getTargetTag() + ", targetUrl=" + this.getTargetUrl() + ", strategy=" + this.getStrategy() + ", updateState=" + this.getUpdateState() + ", result=" + this.getResult() + ", status=" + this.getStatus() + ", failedPackageId=" + this.getFailedPackageId() + ", retryAttempts=" + this.getRetryAttempts() + ", currentName=" + this.getCurrentName() + ", currentVersion3=" + this.getCurrentVersion3() + ", currentVersion=" + this.getCurrentVersion() + ")";
    }

    public LwM2MClientOtaInfo() {
    }
}

