/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.device.profile.lwm2m.ObjectAttributes;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.downlink.DownlinkRequestCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.LwM2mDownlinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MReadCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MReadRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteAttributesCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteAttributesRequest;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.model.LwM2MModelConfig;
import org.thingsboard.server.transport.lwm2m.server.model.LwM2MModelConfigService;
import org.thingsboard.server.transport.lwm2m.server.store.TbLwM2MModelConfigStore;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;

@Service
@TbLwM2mTransportComponent
public class LwM2MModelConfigServiceImpl
implements LwM2MModelConfigService {
    private static final Logger log = LoggerFactory.getLogger(LwM2MModelConfigServiceImpl.class);
    @Autowired
    private TbLwM2MModelConfigStore modelStore;
    @Autowired
    @Lazy
    private LwM2mDownlinkMsgHandler downlinkMsgHandler;
    @Autowired
    @Lazy
    private LwM2mUplinkMsgHandler uplinkMsgHandler;
    @Autowired
    @Lazy
    private LwM2mClientContext clientContext;
    @Autowired
    private LwM2MTelemetryLogService logService;
    private ConcurrentMap<String, LwM2MModelConfig> currentModelConfigs;

    @AfterStartUp(order=2147482646)
    private void init() {
        List<LwM2MModelConfig> models = this.modelStore.getAll();
        log.debug("Fetched model configs: {}", models);
        this.currentModelConfigs = models.stream().collect(Collectors.toConcurrentMap(LwM2MModelConfig::getEndpoint, m -> m));
    }

    @Override
    public void sendUpdates(LwM2mClient lwM2mClient) {
        LwM2MModelConfig modelConfig = (LwM2MModelConfig)this.currentModelConfigs.get(lwM2mClient.getEndpoint());
        if (modelConfig == null || modelConfig.isEmpty()) {
            return;
        }
        this.doSend(lwM2mClient, modelConfig);
    }

    @Override
    public void sendUpdates(LwM2mClient lwM2mClient, LwM2MModelConfig newModelConfig) {
        String endpoint = lwM2mClient.getEndpoint();
        LwM2MModelConfig modelConfig = (LwM2MModelConfig)this.currentModelConfigs.get(endpoint);
        if (modelConfig == null || modelConfig.isEmpty()) {
            modelConfig = newModelConfig;
            this.currentModelConfigs.put(endpoint, modelConfig);
        } else {
            modelConfig.merge(newModelConfig);
        }
        if (lwM2mClient.isAsleep()) {
            this.modelStore.put(modelConfig);
        } else {
            this.doSend(lwM2mClient, modelConfig);
        }
    }

    private void doSend(LwM2mClient lwM2mClient, LwM2MModelConfig modelConfig) {
        log.trace("Send LwM2M Model updates: [{}]", (Object)modelConfig);
        String endpoint = lwM2mClient.getEndpoint();
        Map<String, ObjectAttributes> attrToAdd = modelConfig.getAttributesToAdd();
        attrToAdd.forEach((id, attributes) -> {
            TbLwM2MWriteAttributesRequest request = TbLwM2MWriteAttributesRequest.builder().versionedId((String)id).attributes((ObjectAttributes)attributes).timeout(this.clientContext.getRequestTimeout(lwM2mClient)).build();
            this.downlinkMsgHandler.sendWriteAttributesRequest(lwM2mClient, request, this.createDownlinkProxyCallback(() -> {
                attrToAdd.remove(id);
                if (modelConfig.isEmpty()) {
                    this.modelStore.remove(endpoint);
                }
            }, new TbLwM2MWriteAttributesCallback(this.logService, lwM2mClient, (String)id)));
        });
        Set<String> attrToRemove = modelConfig.getAttributesToRemove();
        attrToRemove.forEach(id -> {
            TbLwM2MWriteAttributesRequest request = TbLwM2MWriteAttributesRequest.builder().versionedId((String)id).attributes(new ObjectAttributes()).timeout(this.clientContext.getRequestTimeout(lwM2mClient)).build();
            this.downlinkMsgHandler.sendWriteAttributesRequest(lwM2mClient, request, this.createDownlinkProxyCallback(() -> {
                attrToRemove.remove(id);
                if (modelConfig.isEmpty()) {
                    this.modelStore.remove(endpoint);
                }
            }, new TbLwM2MWriteAttributesCallback(this.logService, lwM2mClient, (String)id)));
        });
        Set<String> toRead = modelConfig.getToRead();
        toRead.forEach(id -> {
            TbLwM2MReadRequest request = TbLwM2MReadRequest.builder().versionedId((String)id).timeout(this.clientContext.getRequestTimeout(lwM2mClient)).build();
            this.downlinkMsgHandler.sendReadRequest(lwM2mClient, request, this.createDownlinkProxyCallback(() -> {
                toRead.remove(id);
                if (modelConfig.isEmpty()) {
                    this.modelStore.remove(endpoint);
                }
            }, new TbLwM2MReadCallback(this.uplinkMsgHandler, this.logService, lwM2mClient, (String)id)));
        });
        Set<String> toObserve = modelConfig.getToObserve();
        toObserve.forEach(id -> {
            TbLwM2MObserveRequest request = TbLwM2MObserveRequest.builder().versionedId((String)id).timeout(this.clientContext.getRequestTimeout(lwM2mClient)).build();
            this.downlinkMsgHandler.sendObserveRequest(lwM2mClient, request, this.createDownlinkProxyCallback(() -> {
                toObserve.remove(id);
                if (modelConfig.isEmpty()) {
                    this.modelStore.remove(endpoint);
                }
            }, new TbLwM2MObserveCallback(this.uplinkMsgHandler, this.logService, lwM2mClient, (String)id)));
        });
        Set<String> toCancelObserve = modelConfig.getToCancelObserve();
        toCancelObserve.forEach(id -> {
            TbLwM2MCancelObserveRequest request = TbLwM2MCancelObserveRequest.builder().versionedId((String)id).timeout(this.clientContext.getRequestTimeout(lwM2mClient)).build();
            this.downlinkMsgHandler.sendCancelObserveRequest(lwM2mClient, request, this.createDownlinkProxyCallback(() -> {
                toCancelObserve.remove(id);
                if (modelConfig.isEmpty()) {
                    this.modelStore.remove(endpoint);
                }
            }, new TbLwM2MCancelObserveCallback(this.logService, lwM2mClient, (String)id)));
        });
    }

    private <R, T> DownlinkRequestCallback<R, T> createDownlinkProxyCallback(final Runnable processRemove, final DownlinkRequestCallback<R, T> callback) {
        return new DownlinkRequestCallback<R, T>(){

            @Override
            public void onSuccess(R request, T response) {
                processRemove.run();
                callback.onSuccess(request, response);
            }

            @Override
            public void onValidationError(String params, String msg) {
                processRemove.run();
                callback.onValidationError(params, msg);
            }

            @Override
            public void onError(String params, Exception e) {
                try {
                    if (e instanceof TimeoutException) {
                        return;
                    }
                    processRemove.run();
                }
                finally {
                    callback.onError(params, e);
                }
            }
        };
    }

    @Override
    public void persistUpdates(String endpoint) {
        LwM2MModelConfig modelConfig = (LwM2MModelConfig)this.currentModelConfigs.get(endpoint);
        if (modelConfig != null && !modelConfig.isEmpty()) {
            this.modelStore.put(modelConfig);
        }
    }

    @Override
    public void removeUpdates(String endpoint) {
        this.currentModelConfigs.remove(endpoint);
    }

    @PreDestroy
    private void destroy() {
        this.currentModelConfigs.values().forEach(model -> {
            if (model != null && !model.isEmpty()) {
                this.modelStore.put((LwM2MModelConfig)model);
            }
        });
    }
}

