/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.CollectionsUtil;
import org.thingsboard.server.common.data.device.profile.lwm2m.ObjectAttributes;

public class LwM2MModelConfig {
    private static final Logger log = LoggerFactory.getLogger(LwM2MModelConfig.class);
    private String endpoint;
    private Map<String, ObjectAttributes> attributesToAdd;
    private Set<String> attributesToRemove;
    private Set<String> toObserve;
    private Set<String> toCancelObserve;
    private Set<String> toRead;
    @JsonIgnore
    private Set<String> toCancelRead;

    public LwM2MModelConfig(String endpoint) {
        this.endpoint = endpoint;
        this.attributesToAdd = new ConcurrentHashMap<String, ObjectAttributes>();
        this.attributesToRemove = ConcurrentHashMap.newKeySet();
        this.toObserve = ConcurrentHashMap.newKeySet();
        this.toCancelObserve = ConcurrentHashMap.newKeySet();
        this.toRead = ConcurrentHashMap.newKeySet();
        this.toCancelRead = new HashSet<String>();
    }

    public void merge(LwM2MModelConfig modelConfig) {
        if (modelConfig.isEmpty() && modelConfig.getToCancelRead().isEmpty()) {
            return;
        }
        modelConfig.getAttributesToAdd().forEach((k, v) -> {
            if (this.attributesToRemove.contains(k)) {
                this.attributesToRemove.remove(k);
            } else {
                this.attributesToAdd.put((String)k, (ObjectAttributes)v);
            }
        });
        modelConfig.getAttributesToRemove().forEach(k -> {
            if (this.attributesToAdd.containsKey(k)) {
                this.attributesToRemove.remove(k);
            } else {
                this.attributesToRemove.add((String)k);
            }
        });
        this.toObserve.addAll(CollectionsUtil.diffSets(this.toCancelObserve, modelConfig.getToObserve()));
        this.toCancelObserve.addAll(CollectionsUtil.diffSets(this.toObserve, modelConfig.getToCancelObserve()));
        this.toObserve.removeAll(modelConfig.getToCancelObserve());
        this.toCancelObserve.removeAll(modelConfig.getToObserve());
        this.toRead.removeAll(modelConfig.getToObserve());
        this.toRead.removeAll(modelConfig.getToCancelRead());
        this.toRead.addAll(modelConfig.getToRead());
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.attributesToAdd.isEmpty() && this.toObserve.isEmpty() && this.toCancelObserve.isEmpty() && this.toRead.isEmpty();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, ObjectAttributes> getAttributesToAdd() {
        return this.attributesToAdd;
    }

    public Set<String> getAttributesToRemove() {
        return this.attributesToRemove;
    }

    public Set<String> getToObserve() {
        return this.toObserve;
    }

    public Set<String> getToCancelObserve() {
        return this.toCancelObserve;
    }

    public Set<String> getToRead() {
        return this.toRead;
    }

    public Set<String> getToCancelRead() {
        return this.toCancelRead;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAttributesToAdd(Map<String, ObjectAttributes> attributesToAdd) {
        this.attributesToAdd = attributesToAdd;
    }

    public void setAttributesToRemove(Set<String> attributesToRemove) {
        this.attributesToRemove = attributesToRemove;
    }

    public void setToObserve(Set<String> toObserve) {
        this.toObserve = toObserve;
    }

    public void setToCancelObserve(Set<String> toCancelObserve) {
        this.toCancelObserve = toCancelObserve;
    }

    public void setToRead(Set<String> toRead) {
        this.toRead = toRead;
    }

    @JsonIgnore
    public void setToCancelRead(Set<String> toCancelRead) {
        this.toCancelRead = toCancelRead;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LwM2MModelConfig)) {
            return false;
        }
        LwM2MModelConfig other = (LwM2MModelConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        Map<String, ObjectAttributes> this$attributesToAdd = this.getAttributesToAdd();
        Map<String, ObjectAttributes> other$attributesToAdd = other.getAttributesToAdd();
        if (this$attributesToAdd == null ? other$attributesToAdd != null : !((Object)this$attributesToAdd).equals(other$attributesToAdd)) {
            return false;
        }
        Set<String> this$attributesToRemove = this.getAttributesToRemove();
        Set<String> other$attributesToRemove = other.getAttributesToRemove();
        if (this$attributesToRemove == null ? other$attributesToRemove != null : !((Object)this$attributesToRemove).equals(other$attributesToRemove)) {
            return false;
        }
        Set<String> this$toObserve = this.getToObserve();
        Set<String> other$toObserve = other.getToObserve();
        if (this$toObserve == null ? other$toObserve != null : !((Object)this$toObserve).equals(other$toObserve)) {
            return false;
        }
        Set<String> this$toCancelObserve = this.getToCancelObserve();
        Set<String> other$toCancelObserve = other.getToCancelObserve();
        if (this$toCancelObserve == null ? other$toCancelObserve != null : !((Object)this$toCancelObserve).equals(other$toCancelObserve)) {
            return false;
        }
        Set<String> this$toRead = this.getToRead();
        Set<String> other$toRead = other.getToRead();
        if (this$toRead == null ? other$toRead != null : !((Object)this$toRead).equals(other$toRead)) {
            return false;
        }
        Set<String> this$toCancelRead = this.getToCancelRead();
        Set<String> other$toCancelRead = other.getToCancelRead();
        return !(this$toCancelRead == null ? other$toCancelRead != null : !((Object)this$toCancelRead).equals(other$toCancelRead));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LwM2MModelConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        Map<String, ObjectAttributes> $attributesToAdd = this.getAttributesToAdd();
        result = result * 59 + ($attributesToAdd == null ? 43 : ((Object)$attributesToAdd).hashCode());
        Set<String> $attributesToRemove = this.getAttributesToRemove();
        result = result * 59 + ($attributesToRemove == null ? 43 : ((Object)$attributesToRemove).hashCode());
        Set<String> $toObserve = this.getToObserve();
        result = result * 59 + ($toObserve == null ? 43 : ((Object)$toObserve).hashCode());
        Set<String> $toCancelObserve = this.getToCancelObserve();
        result = result * 59 + ($toCancelObserve == null ? 43 : ((Object)$toCancelObserve).hashCode());
        Set<String> $toRead = this.getToRead();
        result = result * 59 + ($toRead == null ? 43 : ((Object)$toRead).hashCode());
        Set<String> $toCancelRead = this.getToCancelRead();
        result = result * 59 + ($toCancelRead == null ? 43 : ((Object)$toCancelRead).hashCode());
        return result;
    }

    public LwM2MModelConfig() {
    }

    public String toString() {
        return "LwM2MModelConfig(endpoint=" + this.getEndpoint() + ", attributesToAdd=" + this.getAttributesToAdd() + ", attributesToRemove=" + this.getAttributesToRemove() + ", toObserve=" + this.getToObserve() + ", toCancelObserve=" + this.getToCancelObserve() + ", toRead=" + this.getToRead() + ")";
    }
}

