/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink;

import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mSingleResource;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MUplinkTargetedCallback;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;

public class TbLwM2MReadCallback
extends TbLwM2MUplinkTargetedCallback<ReadRequest, ReadResponse> {
    private static final Logger log = LoggerFactory.getLogger(TbLwM2MReadCallback.class);

    public TbLwM2MReadCallback(LwM2mUplinkMsgHandler handler, LwM2MTelemetryLogService logService, LwM2mClient client, String targetId) {
        super(handler, logService, client, targetId);
    }

    @Override
    public void onSuccess(ReadRequest request, ReadResponse response) {
        this.logForBadResponse(response.getCode().getCode(), this.responseToString(response), request.getClass().getSimpleName());
        this.handler.onUpdateValueAfterReadResponse(this.client.getRegistration(), this.versionedId, response);
    }

    private String responseToString(ReadResponse response) {
        byte[] valueInBytes;
        int len;
        LwM2mSingleResource singleResource;
        if (response.getContent() instanceof LwM2mSingleResource && ResourceModel.Type.OPAQUE.equals((Object)(singleResource = (LwM2mSingleResource)response.getContent()).getType()) && (len = (valueInBytes = (byte[])singleResource.getValue()).length) > 0) {
            String valueReplace = len + "Bytes";
            String valueStr = Hex.encodeHexString((byte[])valueInBytes);
            return response.toString().replace(valueReplace, valueStr);
        }
        return response.toString();
    }
}

