/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink;

import java.util.Optional;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.thingsboard.server.transport.lwm2m.server.LwM2MOperationType;
import org.thingsboard.server.transport.lwm2m.server.downlink.AbstractTbLwM2MTargetedDownlinkRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.HasContentFormat;

public class TbLwM2MObserveRequest
extends AbstractTbLwM2MTargetedDownlinkRequest<ObserveResponse>
implements HasContentFormat {
    private final Optional<ContentFormat> requestContentFormat;

    private TbLwM2MObserveRequest(String versionedId, long timeout, ContentFormat requestContentFormat) {
        super(versionedId, timeout);
        this.requestContentFormat = Optional.ofNullable(requestContentFormat);
    }

    @Override
    public LwM2MOperationType getType() {
        return LwM2MOperationType.OBSERVE;
    }

    @Override
    public Optional<ContentFormat> getRequestContentFormat() {
        return this.requestContentFormat;
    }

    public static TbLwM2MObserveRequestBuilder builder() {
        return new TbLwM2MObserveRequestBuilder();
    }

    public static class TbLwM2MObserveRequestBuilder {
        private String versionedId;
        private long timeout;
        private ContentFormat requestContentFormat;

        TbLwM2MObserveRequestBuilder() {
        }

        public TbLwM2MObserveRequestBuilder versionedId(String versionedId) {
            this.versionedId = versionedId;
            return this;
        }

        public TbLwM2MObserveRequestBuilder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public TbLwM2MObserveRequestBuilder requestContentFormat(ContentFormat requestContentFormat) {
            this.requestContentFormat = requestContentFormat;
            return this;
        }

        public TbLwM2MObserveRequest build() {
            return new TbLwM2MObserveRequest(this.versionedId, this.timeout, this.requestContentFormat);
        }

        public String toString() {
            return "TbLwM2MObserveRequest.TbLwM2MObserveRequestBuilder(versionedId=" + this.versionedId + ", timeout=" + this.timeout + ", requestContentFormat=" + this.requestContentFormat + ")";
        }
    }
}

