/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink;

import java.beans.ConstructorProperties;
import java.util.concurrent.CountDownLatch;
import org.thingsboard.server.transport.lwm2m.server.downlink.DownlinkRequestCallback;

public class TbLwM2MLatchCallback<R, T>
implements DownlinkRequestCallback<R, T> {
    private final CountDownLatch countDownLatch;
    private final DownlinkRequestCallback<R, T> callback;

    @Override
    public void onSuccess(R request, T response) {
        this.callback.onSuccess(request, response);
        this.countDownLatch.countDown();
    }

    @Override
    public void onValidationError(String params, String msg) {
        this.callback.onValidationError(params, msg);
        this.countDownLatch.countDown();
    }

    @Override
    public void onError(String params, Exception e) {
        this.callback.onError(params, e);
        this.countDownLatch.countDown();
    }

    @ConstructorProperties(value={"countDownLatch", "callback"})
    public TbLwM2MLatchCallback(CountDownLatch countDownLatch, DownlinkRequestCallback<R, T> callback) {
        this.countDownLatch = countDownLatch;
        this.callback = callback;
    }
}

