/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.downlink;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.leshan.core.LwM2m;
import org.eclipse.leshan.core.attributes.Attribute;
import org.eclipse.leshan.core.attributes.AttributeSet;
import org.eclipse.leshan.core.link.Link;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mObjectInstance;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.ObjectLink;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.request.CompositeDownlinkRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.SimpleDownlinkRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.request.exception.ClientSleepingException;
import org.eclipse.leshan.core.request.exception.InvalidRequestException;
import org.eclipse.leshan.core.request.exception.TimeoutException;
import org.eclipse.leshan.core.response.CreateResponse;
import org.eclipse.leshan.core.response.DeleteResponse;
import org.eclipse.leshan.core.response.DiscoverResponse;
import org.eclipse.leshan.core.response.ExecuteResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.response.WriteAttributesResponse;
import org.eclipse.leshan.core.response.WriteCompositeResponse;
import org.eclipse.leshan.core.response.WriteResponse;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.device.profile.lwm2m.ObjectAttributes;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mVersionedModelProvider;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.common.LwM2MExecutorAwareService;
import org.thingsboard.server.transport.lwm2m.server.downlink.DownlinkRequestCallback;
import org.thingsboard.server.transport.lwm2m.server.downlink.HasContentFormat;
import org.thingsboard.server.transport.lwm2m.server.downlink.HasVersionedId;
import org.thingsboard.server.transport.lwm2m.server.downlink.LwM2mDownlinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCancelObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MCreateRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDeleteRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDiscoverAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDiscoverRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MDownlinkRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MExecuteRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveAllRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MObserveRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MReadRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteAttributesRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteReplaceRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteUpdateRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.composite.TbLwM2MReadCompositeRequest;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.rpc.composite.RpcWriteCompositeRequest;
import org.thingsboard.server.transport.lwm2m.utils.LwM2MTransportUtil;
import org.thingsboard.server.transport.lwm2m.utils.LwM2mValueConverterImpl;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2mDownlinkMsgHandler
extends LwM2MExecutorAwareService
implements LwM2mDownlinkMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2mDownlinkMsgHandler.class);
    public LwM2mValueConverterImpl converter;
    private final LwM2mTransportContext context;
    private final LwM2MTransportServerConfig config;
    private final LwM2MTelemetryLogService logService;
    private final LwM2mClientContext clientContext;
    private final LwM2mVersionedModelProvider modelProvider;

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.converter = LwM2mValueConverterImpl.getInstance();
    }

    @Override
    @PreDestroy
    public void destroy() {
        super.destroy();
    }

    @Override
    protected int getExecutorSize() {
        return this.config.getDownlinkPoolSize();
    }

    @Override
    protected String getExecutorName() {
        return "LwM2M Downlink";
    }

    @Override
    public void sendReadRequest(LwM2mClient client, TbLwM2MReadRequest request, DownlinkRequestCallback<ReadRequest, ReadResponse> callback) {
        LwM2MTransportUtil.validateVersionedId(client, request);
        ReadRequest downlink = new ReadRequest(DefaultLwM2mDownlinkMsgHandler.getRequestContentFormat(client, request.getVersionedId(), this.modelProvider), request.getObjectId());
        this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
    }

    @Override
    public void sendReadCompositeRequest(LwM2mClient client, TbLwM2MReadCompositeRequest request, DownlinkRequestCallback<ReadCompositeRequest, ReadCompositeResponse> callback, ContentFormat compositeContentFormat) {
        try {
            ReadCompositeRequest downlink = new ReadCompositeRequest(compositeContentFormat, compositeContentFormat, request.getObjectIds());
            this.sendCompositeRequest(client, downlink, this.config.getTimeout(), callback);
        }
        catch (InvalidRequestException e) {
            callback.onValidationError(request.toString(), e.getMessage());
        }
    }

    @Override
    public void sendObserveRequest(LwM2mClient client, TbLwM2MObserveRequest request, DownlinkRequestCallback<ObserveRequest, ObserveResponse> callback) {
        try {
            LwM2MTransportUtil.validateVersionedId(client, request);
            LwM2mPath resultIds = new LwM2mPath(request.getObjectId());
            Set observations = this.context.getServer().getObservationService().getObservations(client.getRegistration());
            if (observations.stream().noneMatch(observation -> ((SingleObservation)observation).getPath().equals((Object)resultIds))) {
                ContentFormat contentFormat = DefaultLwM2mDownlinkMsgHandler.getReadRequestContentFormat(client, request, this.modelProvider);
                ObserveRequest downlink = resultIds.isResource() ? new ObserveRequest(contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue(), resultIds.getResourceId().intValue()) : (resultIds.isObjectInstance() ? new ObserveRequest(contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue()) : new ObserveRequest(contentFormat, resultIds.getObjectId().intValue()));
                log.info("[{}] Send observation: {}.", (Object)client.getEndpoint(), (Object)request.getVersionedId());
                this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
            } else {
                callback.onValidationError(resultIds.toString(), "Observation is already registered!");
            }
        }
        catch (InvalidRequestException e) {
            callback.onValidationError(request.toString(), e.getMessage());
        }
    }

    @Override
    public void sendObserveAllRequest(LwM2mClient client, TbLwM2MObserveAllRequest request, DownlinkRequestCallback<TbLwM2MObserveAllRequest, Set<String>> callback) {
        Set observations = this.context.getServer().getObservationService().getObservations(client.getRegistration());
        Set paths = observations.stream().map(observation -> ((SingleObservation)observation).getPath().toString()).collect(Collectors.toUnmodifiableSet());
        callback.onSuccess(request, paths);
    }

    @Override
    public void sendDiscoverAllRequest(LwM2mClient client, TbLwM2MDiscoverAllRequest request, DownlinkRequestCallback<TbLwM2MDiscoverAllRequest, List<Link>> callback) {
        callback.onSuccess(request, Arrays.asList(client.getRegistration().getSortedObjectLinks()));
    }

    @Override
    public void sendExecuteRequest(LwM2mClient client, TbLwM2MExecuteRequest request, DownlinkRequestCallback<ExecuteRequest, ExecuteResponse> callback) {
        try {
            LwM2MTransportUtil.validateVersionedId(client, request);
            LwM2mPath pathIds = new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(request.getVersionedId()));
            ResourceModel resourceModelExecute = client.getResourceModel(request.getVersionedId(), this.modelProvider);
            if (resourceModelExecute == null) {
                LwM2mModel model = LwM2MTransportUtil.createModelsDefault();
                if (pathIds.isResource()) {
                    resourceModelExecute = model.getResourceModel(pathIds.getObjectId().intValue(), pathIds.getResourceId().intValue());
                }
            }
            if (resourceModelExecute == null) {
                callback.onValidationError(request.toString(), "ResourceModel with " + request.getVersionedId() + " is absent in system. Need ddd Lwm2m Model with id=" + pathIds.getObjectId() + " ver=" + LwM2MTransportUtil.getVerFromPathIdVerOrId(request.getVersionedId()) + " to profile.");
            } else if (resourceModelExecute.operations.isExecutable()) {
                ExecuteRequest downlink = request.getParams() != null && resourceModelExecute.multiple == false ? new ExecuteRequest(request.getObjectId(), (String)this.converter.convertValue(request.getParams(), resourceModelExecute.type, ResourceModel.Type.STRING, new LwM2mPath(request.getObjectId()))) : new ExecuteRequest(request.getObjectId());
                this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
            } else {
                callback.onValidationError(request.toString(), "Resource with " + request.getVersionedId() + " is not executable.");
            }
        }
        catch (InvalidRequestException e) {
            callback.onValidationError(request.toString(), e.getMessage());
        }
    }

    @Override
    public void sendDeleteRequest(LwM2mClient client, TbLwM2MDeleteRequest request, DownlinkRequestCallback<DeleteRequest, DeleteResponse> callback) {
        try {
            LwM2MTransportUtil.validateVersionedId(client, request);
            this.sendSimpleRequest(client, new DeleteRequest(request.getObjectId()), request.getTimeout(), callback);
        }
        catch (InvalidRequestException e) {
            callback.onValidationError(request.toString(), e.getMessage());
        }
    }

    @Override
    public void sendCancelObserveRequest(LwM2mClient client, TbLwM2MCancelObserveRequest request, DownlinkRequestCallback<TbLwM2MCancelObserveRequest, Integer> callback) {
        LwM2MTransportUtil.validateVersionedId(client, request);
        int observeCancelCnt = this.context.getServer().getObservationService().cancelObservations(client.getRegistration(), request.getObjectId());
        callback.onSuccess(request, observeCancelCnt);
    }

    @Override
    public void sendCancelAllRequest(LwM2mClient client, TbLwM2MCancelAllRequest request, DownlinkRequestCallback<TbLwM2MCancelAllRequest, Integer> callback) {
        int observeCancelCnt = this.context.getServer().getObservationService().cancelObservations(client.getRegistration());
        callback.onSuccess(request, observeCancelCnt);
    }

    @Override
    public void sendDiscoverRequest(LwM2mClient client, TbLwM2MDiscoverRequest request, DownlinkRequestCallback<DiscoverRequest, DiscoverResponse> callback) {
        LwM2MTransportUtil.validateVersionedId(client, request);
        this.sendSimpleRequest(client, new DiscoverRequest(request.getObjectId()), request.getTimeout(), callback);
    }

    @Override
    public void sendWriteAttributesRequest(LwM2mClient client, TbLwM2MWriteAttributesRequest request, DownlinkRequestCallback<WriteAttributesRequest, WriteAttributesResponse> callback) {
        try {
            LwM2MTransportUtil.validateVersionedId(client, request);
            if (request.getAttributes() == null) {
                throw new IllegalArgumentException("Attributes to write are not specified!");
            }
            ObjectAttributes params = request.getAttributes();
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "pmax", params.getPmax());
            DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "pmin", params.getPmin());
            DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "gt", params.getGt());
            DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "lt", params.getLt());
            DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, "st", params.getSt());
            AttributeSet attributeSet = new AttributeSet(attributes);
            this.sendSimpleRequest(client, new WriteAttributesRequest(request.getObjectId(), attributeSet), request.getTimeout(), callback);
        }
        catch (InvalidRequestException e) {
            callback.onValidationError(request.toString(), e.getMessage());
        }
    }

    @Override
    public void sendWriteReplaceRequest(LwM2mClient client, TbLwM2MWriteReplaceRequest request, DownlinkRequestCallback<WriteRequest, WriteResponse> callback) {
        block13: {
            LwM2mPath resultIds = new LwM2mPath(request.getObjectId());
            if (resultIds.isResource() || resultIds.isResourceInstance()) {
                LwM2MTransportUtil.validateVersionedId(client, request);
                ResourceModel resourceModelWrite = client.getResourceModel(request.getVersionedId(), this.modelProvider);
                if (resourceModelWrite != null) {
                    ContentFormat contentFormat = DefaultLwM2mDownlinkMsgHandler.getWriteRequestContentFormat(client, request, this.modelProvider);
                    try {
                        WriteRequest downlink = null;
                        Object msgError = "";
                        if (resourceModelWrite.multiple.booleanValue()) {
                            try {
                                Map<Integer, Object> value = LwM2MTransportUtil.convertMultiResourceValuesFromRpcBody(request.getValue(), resourceModelWrite.type, request.getObjectId());
                                downlink = new WriteRequest(contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue(), resultIds.getResourceId().intValue(), value, resourceModelWrite.type);
                            }
                            catch (Exception value) {
                                // empty catch block
                            }
                        }
                        if (downlink == null) {
                            try {
                                downlink = this.getWriteRequestSingleResource(resourceModelWrite.type, contentFormat, resultIds.getObjectId(), resultIds.getObjectInstanceId(), resultIds.getResourceId(), request.getValue());
                            }
                            catch (Exception e) {
                                msgError = "Resource id=" + resultIds.toString() + ", value = " + request.getValue() + ", class = " + request.getValue().getClass().getSimpleName() + ". Format value is bad. Value for this Single Resource must be " + resourceModelWrite.type + "!";
                            }
                        }
                        if (downlink != null) {
                            this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
                            break block13;
                        }
                        callback.onValidationError(this.toString(request), (String)msgError);
                    }
                    catch (Exception e) {
                        callback.onError(this.toString(request), e);
                    }
                } else {
                    callback.onValidationError(this.toString(request), "Resource " + request.getVersionedId() + " is not configured in the device profile!");
                }
            } else {
                callback.onValidationError(this.toString(request), "Resource " + request.getVersionedId() + ". This operation can only be used for Resource or ResourceInstance!");
            }
        }
    }

    @Override
    public void sendWriteCompositeRequest(LwM2mClient client, RpcWriteCompositeRequest rpcWriteCompositeRequest, DownlinkRequestCallback<WriteCompositeRequest, WriteCompositeResponse> callback, ContentFormat contentFormatComposite) {
        try {
            WriteCompositeRequest downlink = new WriteCompositeRequest(contentFormatComposite, rpcWriteCompositeRequest.getNodes());
            this.sendWriteCompositeRequest(client, downlink, this.config.getTimeout(), callback);
        }
        catch (InvalidRequestException e) {
            callback.onValidationError(rpcWriteCompositeRequest.toString(), e.getMessage());
        }
        catch (Exception e) {
            callback.onError(this.toString(rpcWriteCompositeRequest), e);
        }
    }

    @Override
    public void sendWriteUpdateRequest(LwM2mClient client, TbLwM2MWriteUpdateRequest request, DownlinkRequestCallback<WriteRequest, WriteResponse> callback) {
        try {
            LwM2mPath resultIds = new LwM2mPath(request.getObjectId());
            if (resultIds.isObjectInstance() || resultIds.isResource()) {
                LwM2MTransportUtil.validateVersionedId(client, request);
                WriteRequest downlink = null;
                ContentFormat contentFormat = DefaultLwM2mDownlinkMsgHandler.getWriteRequestContentFormat(client, request, this.modelProvider);
                Object msgError = "";
                if (resultIds.isObjectInstance()) {
                    Collection<LwM2mResource> resources = client.getNewResourcesForInstance(request.getVersionedId(), request.getValue(), this.modelProvider, this.converter);
                    if (resources.size() > 0) {
                        downlink = new WriteRequest(WriteRequest.Mode.UPDATE, contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue(), resources);
                    } else {
                        msgError = " No resources to update!";
                    }
                } else if (resultIds.isResource()) {
                    ResourceModel resourceModelWrite = client.getResourceModel(request.getVersionedId(), this.modelProvider);
                    if (resourceModelWrite != null) {
                        if (resourceModelWrite.multiple.booleanValue()) {
                            try {
                                Map<Integer, Object> value = LwM2MTransportUtil.convertMultiResourceValuesFromRpcBody(request.getValue(), resourceModelWrite.type, request.getObjectId());
                                downlink = new WriteRequest(WriteRequest.Mode.UPDATE, contentFormat, resultIds.getObjectId().intValue(), resultIds.getObjectInstanceId().intValue(), resultIds.getResourceId().intValue(), value, resourceModelWrite.type);
                            }
                            catch (Exception e1) {
                                msgError = " Resource id=" + resultIds.toString() + ", class = " + request.getValue().getClass().getSimpleName() + ", value = " + request.getValue() + " is bad. Value of Multi-Instance Resource must be in Json format!";
                            }
                        }
                    } else {
                        msgError = " Resource " + request.getVersionedId() + " is not configured in the device profile!";
                    }
                }
                if (downlink != null) {
                    this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
                } else {
                    callback.onValidationError(this.toString(request), "Resource " + request.getVersionedId() + ". This operation can only be used for ObjectInstance or Multi-Instance Resource !" + (String)msgError);
                }
            } else {
                callback.onValidationError(this.toString(request), "Resource " + request.getVersionedId() + ". This operation can only be used for ObjectInstance or Resource (multiple)");
            }
        }
        catch (Exception e) {
            callback.onValidationError(this.toString(request), e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendCreateRequest(LwM2mClient client, TbLwM2MCreateRequest request, DownlinkRequestCallback<CreateRequest, CreateResponse> callback) {
        LwM2MTransportUtil.validateVersionedId(client, request);
        CreateRequest downlink = null;
        LwM2mPath resultIds = new LwM2mPath(request.getObjectId());
        ObjectModel objectModel = client.getObjectModel(request.getVersionedId(), this.modelProvider);
        if (objectModel != null) {
            if (!objectModel.multiple.booleanValue()) throw new IllegalArgumentException("Path " + request.getVersionedId() + ". Object must be Multiple !");
            ContentFormat contentFormat = DefaultLwM2mDownlinkMsgHandler.getWriteRequestContentFormat(client, request, this.modelProvider);
            if (resultIds.isObject() || resultIds.isObjectInstance()) {
                if (resultIds.isObject()) {
                    if (request.getValue() != null) {
                        Collection<LwM2mResource> resources = client.getNewResourcesForInstance(request.getVersionedId(), request.getValue(), this.modelProvider, this.converter);
                        downlink = new CreateRequest(contentFormat, resultIds.getObjectId().intValue(), resources);
                    } else if (request.getNodes() != null && request.getNodes().size() > 0) {
                        ConcurrentHashMap.KeySetView instances = ConcurrentHashMap.newKeySet();
                        request.getNodes().forEach((key, value) -> {
                            Collection<LwM2mResource> resourcesForInstance = client.getNewResourcesForInstance(request.getVersionedId(), value, this.modelProvider, this.converter);
                            LwM2mObjectInstance instance = new LwM2mObjectInstance(Integer.parseInt(key), resourcesForInstance);
                            instances.add(instance);
                        });
                        LwM2mObjectInstance[] instanceArrays = instances.toArray(new LwM2mObjectInstance[instances.size()]);
                        downlink = new CreateRequest(contentFormat, resultIds.getObjectId().intValue(), instanceArrays);
                    }
                } else {
                    Collection<LwM2mResource> resources = client.getNewResourcesForInstance(request.getVersionedId(), request.getValue(), this.modelProvider, this.converter);
                    LwM2mObjectInstance instance = new LwM2mObjectInstance(resultIds.getObjectInstanceId().intValue(), resources);
                    downlink = new CreateRequest(contentFormat, resultIds.getObjectId().intValue(), new LwM2mObjectInstance[]{instance});
                }
            }
            if (downlink != null) {
                this.sendSimpleRequest(client, downlink, request.getTimeout(), callback);
                return;
            } else {
                callback.onValidationError(this.toString(request), "Path " + request.getVersionedId() + ". Object must be Multiple !");
            }
            return;
        } else {
            callback.onValidationError(this.toString(request), "Resource " + request.getVersionedId() + " is not configured in the device profile!");
        }
    }

    private <R extends SimpleDownlinkRequest<T>, T extends LwM2mResponse> void sendSimpleRequest(LwM2mClient client, R request, long timeoutInMs, DownlinkRequestCallback<R, T> callback) {
        this.sendRequest(client, request, timeoutInMs, callback, r -> request.getPath().toString());
    }

    private <R extends CompositeDownlinkRequest<T>, T extends LwM2mResponse> void sendCompositeRequest(LwM2mClient client, R request, long timeoutInMs, DownlinkRequestCallback<R, T> callback) {
        this.sendRequest(client, request, timeoutInMs, callback, r -> request.getPaths().toString());
    }

    private <R extends DownlinkRequest<T>, T extends LwM2mResponse> void sendRequest(LwM2mClient client, R request, long timeoutInMs, DownlinkRequestCallback<R, T> callback, Function<R, String> pathToStringFunction) {
        if (!this.clientContext.isDownlinkAllowed(client)) {
            log.trace("[{}] ignore downlink request cause client is sleeping.", (Object)client.getEndpoint());
            return;
        }
        Registration registration = client.getRegistration();
        try {
            this.logService.log(client, String.format("[%s][%s] Sending request: %s to %s", registration.getId(), registration.getSocketAddress(), request.getClass().getSimpleName(), pathToStringFunction.apply(request)));
            if (!callback.onSent(request)) {
                return;
            }
            this.context.getServer().send(registration, request, timeoutInMs, response -> this.executor.submit(() -> {
                try {
                    callback.onSuccess(request, response);
                }
                catch (Exception e) {
                    log.error("[{}] failed to process successful response [{}] ", new Object[]{registration.getEndpoint(), response, e});
                }
                finally {
                    this.clientContext.awake(client);
                }
            }), e -> this.handleDownlinkError(client, request, callback, e));
        }
        catch (Exception e2) {
            this.handleDownlinkError(client, request, callback, e2);
        }
    }

    private <R extends SimpleDownlinkRequest<T>, T extends LwM2mResponse> void sendWriteCompositeRequest(LwM2mClient client, WriteCompositeRequest request, long timeoutInMs, DownlinkRequestCallback<WriteCompositeRequest, WriteCompositeResponse> callback) {
        if (!this.clientContext.isDownlinkAllowed(client)) {
            log.trace("[{}] ignore downlink request cause client is sleeping.", (Object)client.getEndpoint());
            return;
        }
        Registration registration = client.getRegistration();
        try {
            this.logService.log(client, String.format("[%s][%s] Sending request: %s to %s", registration.getId(), registration.getSocketAddress(), request.getClass().getSimpleName(), request.getPaths()));
            this.context.getServer().send(registration, (DownlinkRequest)request, timeoutInMs, response -> this.executor.submit(() -> {
                try {
                    if (response.isSuccess()) {
                        callback.onSuccess(request, (WriteCompositeResponse)response);
                    } else {
                        callback.onValidationError(request.getNodes().values().toString(), response.getErrorMessage());
                    }
                }
                catch (Exception e) {
                    log.error("[{}] failed to process successful response [{}] ", new Object[]{registration.getEndpoint(), response, e});
                }
                finally {
                    this.clientContext.awake(client);
                }
            }), e -> this.handleDownlinkError(client, request, callback, e));
        }
        catch (Exception e2) {
            this.handleDownlinkError(client, request, callback, e2);
        }
    }

    private <R extends DownlinkRequest<T>, T extends LwM2mResponse> void handleDownlinkError(LwM2mClient client, R request, DownlinkRequestCallback<R, T> callback, Exception e) {
        log.trace("[{}] Received downlink error: {}.", (Object)client.getEndpoint(), (Object)e);
        client.updateLastUplinkTime();
        this.executor.submit(() -> {
            if (e instanceof TimeoutException || e instanceof ClientSleepingException) {
                log.trace("[{}] Received {}, client is probably sleeping", (Object)client.getEndpoint(), (Object)e.getClass().getSimpleName());
                this.clientContext.asleep(client);
            } else {
                log.trace("[{}] Received {}", (Object)client.getEndpoint(), (Object)e.getClass().getSimpleName());
            }
            callback.onError(this.toString(request), e);
        });
    }

    private WriteRequest getWriteRequestSingleResource(ResourceModel.Type type, ContentFormat contentFormat, int objectId, int instanceId, int resourceId, Object value) {
        switch (type) {
            case STRING: {
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, value.toString());
            }
            case INTEGER: {
                long valueInt = Integer.toUnsignedLong(Integer.parseInt(value.toString()));
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, valueInt);
            }
            case OBJLNK: {
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, ObjectLink.fromPath((String)value.toString()));
            }
            case BOOLEAN: {
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, Boolean.parseBoolean(value.toString()));
            }
            case FLOAT: {
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, Double.parseDouble(value.toString()));
            }
            case TIME: {
                Date date = new Date(Long.decode(value.toString()));
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, date);
            }
            case OPAQUE: {
                byte[] valueRequest = value instanceof byte[] ? (byte[])value : Hex.decodeHex((char[])value.toString().toCharArray());
                return new WriteRequest(contentFormat, objectId, instanceId, resourceId, valueRequest);
            }
        }
        throw new IllegalArgumentException("Not supported type:" + type.name());
    }

    private static <T> void addAttribute(List<Attribute> attributes, String attributeName, T value) {
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, attributeName, value, null, null);
    }

    private static <T> void addAttribute(List<Attribute> attributes, String attributeName, T value, Function<T, ?> converter) {
        DefaultLwM2mDownlinkMsgHandler.addAttribute(attributes, attributeName, value, null, converter);
    }

    private static <T> void addAttribute(List<Attribute> attributes, String attributeName, T value, Predicate<T> filter, Function<T, ?> converter) {
        if (value != null && (filter == null || filter.test(value))) {
            attributes.add(new Attribute(attributeName, converter != null ? converter.apply(value) : value));
        }
    }

    private static <T extends HasContentFormat & HasVersionedId> ContentFormat getReadRequestContentFormat(LwM2mClient client, T request, LwM2mModelProvider modelProvider) {
        if (request.getRequestContentFormat().isPresent()) {
            return request.getRequestContentFormat().get();
        }
        return DefaultLwM2mDownlinkMsgHandler.getRequestContentFormat(client, ((HasVersionedId)request).getVersionedId(), modelProvider);
    }

    private static ContentFormat getWriteRequestContentFormat(LwM2mClient client, TbLwM2MDownlinkRequest request, LwM2mModelProvider modelProvider) {
        if (request instanceof TbLwM2MWriteReplaceRequest && ((TbLwM2MWriteReplaceRequest)request).getContentFormat() != null) {
            return ((TbLwM2MWriteReplaceRequest)request).getContentFormat();
        }
        if (request instanceof TbLwM2MWriteUpdateRequest && ((TbLwM2MWriteUpdateRequest)request).getObjectContentFormat() != null) {
            return ((TbLwM2MWriteUpdateRequest)request).getObjectContentFormat();
        }
        String versionedId = null;
        if (request instanceof TbLwM2MWriteReplaceRequest) {
            versionedId = ((TbLwM2MWriteReplaceRequest)request).getVersionedId();
        } else if (request instanceof TbLwM2MWriteUpdateRequest) {
            versionedId = ((TbLwM2MWriteUpdateRequest)request).getVersionedId();
        } else if (request instanceof TbLwM2MCreateRequest) {
            versionedId = ((TbLwM2MCreateRequest)request).getVersionedId();
        }
        return DefaultLwM2mDownlinkMsgHandler.getRequestContentFormat(client, versionedId, modelProvider);
    }

    private static ContentFormat getRequestContentFormat(LwM2mClient client, String versionedId, LwM2mModelProvider modelProvider) {
        LwM2mPath pathIds = new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(versionedId));
        if (pathIds.isResource() || pathIds.isResourceInstance()) {
            ResourceModel resourceModel = client.getResourceModel(versionedId, modelProvider);
            if (resourceModel != null && (pathIds.isResourceInstance() || pathIds.isResource() && !resourceModel.multiple.booleanValue())) {
                if (ResourceModel.Type.OBJLNK.equals((Object)resourceModel.type)) {
                    return ContentFormat.LINK;
                }
                if (ResourceModel.Type.OPAQUE.equals((Object)resourceModel.type)) {
                    return ContentFormat.OPAQUE;
                }
                return DefaultLwM2mDownlinkMsgHandler.findFirst(client.getClientSupportContentFormats(), client.getDefaultContentFormat(), ContentFormat.CBOR, ContentFormat.SENML_CBOR, ContentFormat.SENML_JSON);
            }
            return DefaultLwM2mDownlinkMsgHandler.getContentFormatForComplex(client);
        }
        return DefaultLwM2mDownlinkMsgHandler.getContentFormatForComplex(client);
    }

    private static ContentFormat getContentFormatForComplex(LwM2mClient client) {
        if (LwM2m.LwM2mVersion.V1_0.equals((Object)client.getRegistration().getLwM2mVersion())) {
            return ContentFormat.TLV;
        }
        if (LwM2m.LwM2mVersion.V1_1.equals((Object)client.getRegistration().getLwM2mVersion())) {
            ContentFormat result = DefaultLwM2mDownlinkMsgHandler.findFirst(client.getClientSupportContentFormats(), null, ContentFormat.SENML_CBOR, ContentFormat.SENML_JSON, ContentFormat.TLV, ContentFormat.JSON);
            if (result != null) {
                return result;
            }
            throw new RuntimeException("The client does not support any of SenML CBOR, SenML JSON, TLV or JSON formats. Can't send complex requests. Try using singe-instance requests.");
        }
        throw new RuntimeException("The version " + client.getRegistration().getLwM2mVersion() + " is not supported!");
    }

    private static ContentFormat findFirst(Set<ContentFormat> supported, ContentFormat defaultValue, ContentFormat ... desiredFormats) {
        for (ContentFormat contentFormat : desiredFormats) {
            if (!supported.contains(contentFormat)) continue;
            return contentFormat;
        }
        return defaultValue;
    }

    private <R> String toString(R request) {
        try {
            return request != null ? request.toString() : "";
        }
        catch (Exception e) {
            log.debug("Failed to convert request to string", (Throwable)e);
            return request.getClass().getSimpleName();
        }
    }

    @ConstructorProperties(value={"context", "config", "logService", "clientContext", "modelProvider"})
    public DefaultLwM2mDownlinkMsgHandler(LwM2mTransportContext context, LwM2MTransportServerConfig config, LwM2MTelemetryLogService logService, LwM2mClientContext clientContext, LwM2mVersionedModelProvider modelProvider) {
        this.context = context;
        this.config = config;
        this.logService = logService;
        this.clientContext = clientContext;
        this.modelProvider = modelProvider;
    }
}

