/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.client;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mMultipleResource;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.LwM2mResourceInstance;
import org.eclipse.leshan.core.node.LwM2mSingleResource;
import org.eclipse.leshan.core.request.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceValue {
    private static final Logger log = LoggerFactory.getLogger(ResourceValue.class);
    private LwM2mResource lwM2mResource;
    private ResourceModel resourceModel;

    public ResourceValue(LwM2mResource lwM2mResource, ResourceModel resourceModel) {
        this.resourceModel = resourceModel;
        this.updateLwM2mResource(lwM2mResource, WriteRequest.Mode.UPDATE);
    }

    public void updateLwM2mResource(LwM2mResource lwM2mResource, WriteRequest.Mode mode) {
        if (lwM2mResource instanceof LwM2mSingleResource) {
            this.lwM2mResource = LwM2mSingleResource.newResource((int)lwM2mResource.getId(), (Object)lwM2mResource.getValue(), (ResourceModel.Type)lwM2mResource.getType());
        } else if (lwM2mResource instanceof LwM2mMultipleResource && lwM2mResource.getInstances().values().size() > 0) {
            HashSet instancesSet = new HashSet(lwM2mResource.getInstances().values());
            if (WriteRequest.Mode.REPLACE.equals((Object)mode) && this.lwM2mResource != null) {
                Map oldInstances = this.lwM2mResource.getInstances();
                oldInstances.values().forEach(v -> {
                    if (instancesSet.stream().noneMatch(vIns -> v.getId() == vIns.getId())) {
                        instancesSet.add(v);
                    }
                });
            }
            LwM2mResourceInstance[] instances = instancesSet.toArray(new LwM2mResourceInstance[0]);
            this.lwM2mResource = new LwM2mMultipleResource(lwM2mResource.getId(), lwM2mResource.getType(), instances);
        }
    }

    public LwM2mResource getLwM2mResource() {
        return this.lwM2mResource;
    }

    public ResourceModel getResourceModel() {
        return this.resourceModel;
    }

    public void setLwM2mResource(LwM2mResource lwM2mResource) {
        this.lwM2mResource = lwM2mResource;
    }

    public void setResourceModel(ResourceModel resourceModel) {
        this.resourceModel = resourceModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceValue)) {
            return false;
        }
        ResourceValue other = (ResourceValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LwM2mResource this$lwM2mResource = this.getLwM2mResource();
        LwM2mResource other$lwM2mResource = other.getLwM2mResource();
        if (this$lwM2mResource == null ? other$lwM2mResource != null : !this$lwM2mResource.equals(other$lwM2mResource)) {
            return false;
        }
        ResourceModel this$resourceModel = this.getResourceModel();
        ResourceModel other$resourceModel = other.getResourceModel();
        return !(this$resourceModel == null ? other$resourceModel != null : !this$resourceModel.equals(other$resourceModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LwM2mResource $lwM2mResource = this.getLwM2mResource();
        result = result * 59 + ($lwM2mResource == null ? 43 : $lwM2mResource.hashCode());
        ResourceModel $resourceModel = this.getResourceModel();
        result = result * 59 + ($resourceModel == null ? 43 : $resourceModel.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceValue(lwM2mResource=" + this.getLwM2mResource() + ", resourceModel=" + this.getResourceModel() + ")";
    }
}

