/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.client;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.eclipse.leshan.server.registration.Registration;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.device.profile.Lwm2mDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2MClientStateException;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;

public interface LwM2mClientContext {
    public LwM2mClient getClientByEndpoint(String var1);

    public LwM2mClient getClientBySessionInfo(TransportProtos.SessionInfoProto var1);

    public Optional<TransportProtos.SessionInfoProto> register(LwM2mClient var1, Registration var2) throws LwM2MClientStateException;

    public void updateRegistration(LwM2mClient var1, Registration var2) throws LwM2MClientStateException;

    public void unregister(LwM2mClient var1, Registration var2) throws LwM2MClientStateException;

    public Collection<LwM2mClient> getLwM2mClients();

    public Lwm2mDeviceProfileTransportConfiguration getProfile(UUID var1);

    public Lwm2mDeviceProfileTransportConfiguration getProfile(Registration var1);

    public Lwm2mDeviceProfileTransportConfiguration profileUpdate(DeviceProfile var1);

    public Set<String> getSupportedIdVerInClient(LwM2mClient var1);

    public LwM2mClient getClientByDeviceId(UUID var1);

    public String getObjectIdByKeyNameFromProfile(LwM2mClient var1, String var2);

    public void registerClient(Registration var1, ValidateDeviceCredentialsResponse var2);

    public void update(LwM2mClient var1);

    public void sendMsgsAfterSleeping(LwM2mClient var1);

    public void onUplink(LwM2mClient var1);

    public Long getRequestTimeout(LwM2mClient var1);

    public boolean asleep(LwM2mClient var1);

    public boolean awake(LwM2mClient var1);

    public boolean isDownlinkAllowed(LwM2mClient var1);
}

