/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server.attributes;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.JsonElement;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.LwM2mResourceInstance;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.response.WriteResponse;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.attributes.LwM2MAttributesService;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClient;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;
import org.thingsboard.server.transport.lwm2m.server.downlink.LwM2mDownlinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteReplaceRequest;
import org.thingsboard.server.transport.lwm2m.server.downlink.TbLwM2MWriteResponseCallback;
import org.thingsboard.server.transport.lwm2m.server.log.LwM2MTelemetryLogService;
import org.thingsboard.server.transport.lwm2m.server.ota.DefaultLwM2MOtaUpdateService;
import org.thingsboard.server.transport.lwm2m.server.ota.LwM2MOtaUpdateService;
import org.thingsboard.server.transport.lwm2m.server.uplink.LwM2mUplinkMsgHandler;
import org.thingsboard.server.transport.lwm2m.utils.LwM2MTransportUtil;
import org.thingsboard.server.transport.lwm2m.utils.LwM2mValueConverterImpl;

@Service
@TbLwM2mTransportComponent
public class DefaultLwM2MAttributesService
implements LwM2MAttributesService {
    private static final Logger log = LoggerFactory.getLogger(DefaultLwM2MAttributesService.class);
    private final AtomicInteger reqIdSeq = new AtomicInteger();
    private final Map<Integer, SettableFuture<List<TransportProtos.TsKvProto>>> futures;
    private final TransportService transportService;
    private final LwM2mTransportServerHelper helper;
    private final LwM2mClientContext clientContext;
    private final LwM2MTransportServerConfig config;
    private final LwM2mUplinkMsgHandler uplinkHandler;
    private final LwM2mDownlinkMsgHandler downlinkHandler;
    private final LwM2MTelemetryLogService logService;
    private final LwM2MOtaUpdateService otaUpdateService;
    private final LwM2mModelProvider modelProvider;

    @Override
    public ListenableFuture<List<TransportProtos.TsKvProto>> getSharedAttributes(LwM2mClient client, Collection<String> keys) {
        SettableFuture future = SettableFuture.create();
        final int requestId = this.reqIdSeq.incrementAndGet();
        this.futures.put(requestId, (SettableFuture<List<TransportProtos.TsKvProto>>)future);
        this.transportService.process(client.getSession(), TransportProtos.GetAttributeRequestMsg.newBuilder().setRequestId(requestId).addAllSharedAttributeNames(keys).build(), (TransportServiceCallback)new TransportServiceCallback<Void>(){

            public void onSuccess(Void msg) {
            }

            public void onError(Throwable e) {
                SettableFuture<List<TransportProtos.TsKvProto>> callback = DefaultLwM2MAttributesService.this.futures.remove(requestId);
                if (callback != null) {
                    callback.setException(e);
                }
            }
        });
        return future;
    }

    @Override
    public void onGetAttributesResponse(TransportProtos.GetAttributeResponseMsg getAttributesResponse, TransportProtos.SessionInfoProto sessionInfo) {
        SettableFuture<List<TransportProtos.TsKvProto>> callback = this.futures.remove(getAttributesResponse.getRequestId());
        if (callback != null) {
            callback.set((Object)getAttributesResponse.getSharedAttributeListList());
        }
    }

    @Override
    public void onAttributesUpdate(TransportProtos.AttributeUpdateNotificationMsg msg, TransportProtos.SessionInfoProto sessionInfo) {
        LwM2mClient lwM2MClient = this.clientContext.getClientBySessionInfo(sessionInfo);
        if (msg.getSharedUpdatedCount() > 0 && lwM2MClient != null) {
            String newFirmwareTitle = null;
            String newFirmwareVersion = null;
            String newFirmwareTag = null;
            String newFirmwareUrl = null;
            String newSoftwareTitle = null;
            String newSoftwareVersion = null;
            String newSoftwareTag = null;
            String newSoftwareUrl = null;
            ArrayList<TransportProtos.TsKvProto> otherAttributes = new ArrayList<TransportProtos.TsKvProto>();
            for (TransportProtos.TsKvProto tsKvProto : msg.getSharedUpdatedList()) {
                String attrName = tsKvProto.getKv().getKey();
                if (LwM2MTransportUtil.compareAttNameKeyOta(attrName)) {
                    if (DefaultLwM2MOtaUpdateService.FIRMWARE_TITLE.equals(attrName)) {
                        newFirmwareTitle = this.getStrValue(tsKvProto);
                        continue;
                    }
                    if (DefaultLwM2MOtaUpdateService.FIRMWARE_VERSION.equals(attrName)) {
                        newFirmwareVersion = this.getStrValue(tsKvProto);
                        continue;
                    }
                    if (DefaultLwM2MOtaUpdateService.FIRMWARE_TAG.equals(attrName)) {
                        newFirmwareTag = this.getStrValue(tsKvProto);
                        continue;
                    }
                    if (DefaultLwM2MOtaUpdateService.FIRMWARE_URL.equals(attrName)) {
                        newFirmwareUrl = this.getStrValue(tsKvProto);
                        continue;
                    }
                    if (DefaultLwM2MOtaUpdateService.SOFTWARE_TITLE.equals(attrName)) {
                        newSoftwareTitle = this.getStrValue(tsKvProto);
                        continue;
                    }
                    if (DefaultLwM2MOtaUpdateService.SOFTWARE_VERSION.equals(attrName)) {
                        newSoftwareVersion = this.getStrValue(tsKvProto);
                        continue;
                    }
                    if (DefaultLwM2MOtaUpdateService.SOFTWARE_TAG.equals(attrName)) {
                        newSoftwareTag = this.getStrValue(tsKvProto);
                        continue;
                    }
                    if (!DefaultLwM2MOtaUpdateService.SOFTWARE_URL.equals(attrName)) continue;
                    newSoftwareUrl = this.getStrValue(tsKvProto);
                    continue;
                }
                otherAttributes.add(tsKvProto);
            }
            if (newFirmwareTitle != null || newFirmwareVersion != null) {
                this.otaUpdateService.onTargetFirmwareUpdate(lwM2MClient, newFirmwareTitle, newFirmwareVersion, Optional.ofNullable(newFirmwareUrl), Optional.ofNullable(newFirmwareTag));
            }
            if (newSoftwareTitle != null || newSoftwareVersion != null) {
                this.otaUpdateService.onTargetSoftwareUpdate(lwM2MClient, newSoftwareTitle, newSoftwareVersion, Optional.ofNullable(newSoftwareUrl), Optional.ofNullable(newSoftwareTag));
            }
            if (!otherAttributes.isEmpty()) {
                this.onAttributesUpdate(lwM2MClient, otherAttributes, true);
            }
        } else if (lwM2MClient == null) {
            log.error("OnAttributeUpdate, lwM2MClient is null");
        }
    }

    @Override
    public void onAttributesUpdate(LwM2mClient lwM2MClient, List<TransportProtos.TsKvProto> tsKvProtos, boolean logFailedUpdateOfNonChangedValue) {
        log.trace("[{}] onAttributesUpdate [{}]", (Object)lwM2MClient.getEndpoint(), tsKvProtos);
        ConcurrentHashMap<String, TransportProtos.TsKvProto> attributesUpdate = new ConcurrentHashMap<String, TransportProtos.TsKvProto>();
        tsKvProtos.forEach(tsKvProto -> {
            try {
                String pathIdVer = this.clientContext.getObjectIdByKeyNameFromProfile(lwM2MClient, tsKvProto.getKv().getKey());
                if (pathIdVer != null) {
                    if (lwM2MClient.getSharedAttributes().containsKey(pathIdVer)) {
                        if (tsKvProto.getTs() > lwM2MClient.getSharedAttributes().get(pathIdVer).getTs()) {
                            attributesUpdate.put(pathIdVer, (TransportProtos.TsKvProto)tsKvProto);
                        }
                    } else {
                        attributesUpdate.put(pathIdVer, (TransportProtos.TsKvProto)tsKvProto);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                log.error("Failed update resource [" + lwM2MClient.getEndpoint() + "] onAttributesUpdate:", (Throwable)e);
                String logMsg = String.format("%s: Failed update resource onAttributesUpdate %s.", "error", e.getMessage());
                this.logService.log(lwM2MClient, logMsg);
            }
        });
        this.clientContext.update(lwM2MClient);
        attributesUpdate.forEach((pathIdVer, tsKvProto) -> {
            ResourceModel resourceModel = lwM2MClient.getResourceModel((String)pathIdVer, this.modelProvider);
            Object newValProto = LwM2mTransportServerHelper.getValueFromKvProto(tsKvProto.getKv());
            Object oldResourceValue = this.getResourceValueFormatKv(lwM2MClient, (String)pathIdVer);
            if (!resourceModel.multiple.booleanValue() || !(newValProto instanceof JsonElement)) {
                this.pushUpdateToClientIfNeeded(lwM2MClient, oldResourceValue, newValProto, (String)pathIdVer, (TransportProtos.TsKvProto)tsKvProto, logFailedUpdateOfNonChangedValue);
            } else {
                try {
                    this.pushUpdateMultiToClientIfNeeded(lwM2MClient, resourceModel, (JsonElement)newValProto, (Map)oldResourceValue, (String)pathIdVer, (TransportProtos.TsKvProto)tsKvProto, logFailedUpdateOfNonChangedValue);
                }
                catch (Exception e) {
                    log.error("Failed update resource [" + lwM2MClient.getEndpoint() + "] onAttributesUpdate:", (Throwable)e);
                    String logMsg = String.format("%s: Failed update resource onAttributesUpdate %s.", "error", e.getMessage());
                    this.logService.log(lwM2MClient, logMsg);
                }
            }
        });
    }

    private void pushUpdateToClientIfNeeded(LwM2mClient lwM2MClient, Object oldValue, Object newValue, String versionedId, final TransportProtos.TsKvProto tsKvProto, boolean logFailedUpdateOfNonChangedValue) {
        if (newValue == null) {
            String logMsg = String.format("%s: Failed update resource versionedId - %s value - %s. New value is  bad", "error", versionedId, "null");
            this.logService.log(lwM2MClient, logMsg);
            log.error("Failed update resource [{}] [{}]", (Object)versionedId, (Object)"null");
        } else if (oldValue == null || !LwM2MTransportUtil.valueEquals(newValue, oldValue)) {
            TbLwM2MWriteReplaceRequest request = TbLwM2MWriteReplaceRequest.builder().versionedId(versionedId).value(newValue).timeout(this.clientContext.getRequestTimeout(lwM2MClient)).build();
            this.downlinkHandler.sendWriteReplaceRequest(lwM2MClient, request, new TbLwM2MWriteResponseCallback(this.uplinkHandler, this.logService, lwM2MClient, versionedId){

                @Override
                public void onSuccess(WriteRequest request, WriteResponse response) {
                    this.client.getSharedAttributes().put(this.versionedId, tsKvProto);
                    super.onSuccess(request, response);
                }
            });
        } else if (logFailedUpdateOfNonChangedValue) {
            String logMsg = String.format("%s: Didn't update the versionedId resource - %s value - %s. Value is not changed", "warn", versionedId, newValue);
            this.logService.log(lwM2MClient, logMsg);
            log.warn("Didn't update resource [{}] [{}]. Value is not changed", (Object)versionedId, newValue);
        }
    }

    private void pushUpdateMultiToClientIfNeeded(LwM2mClient client, ResourceModel resourceModel, JsonElement newValProto, Map<Integer, LwM2mResourceInstance> valueOld, String versionedId, final TransportProtos.TsKvProto tsKvProto, boolean logFailedUpdateOfNonChangedValue) {
        Map<Integer, Object> newValues = LwM2MTransportUtil.convertMultiResourceValuesFromJson(newValProto, resourceModel.type, versionedId);
        if (newValues.size() > 0 && valueOld != null && valueOld.size() > 0) {
            valueOld.values().forEach(v -> {
                if (newValues.containsKey(v.getId()) && LwM2MTransportUtil.valueEquals(newValues.get(v.getId()), v.getValue())) {
                    newValues.remove(v.getId());
                }
            });
        }
        if (newValues.size() > 0) {
            TbLwM2MWriteReplaceRequest request = TbLwM2MWriteReplaceRequest.builder().versionedId(versionedId).value(newValues).timeout(this.config.getTimeout()).build();
            this.downlinkHandler.sendWriteReplaceRequest(client, request, new TbLwM2MWriteResponseCallback(this.uplinkHandler, this.logService, client, versionedId){

                @Override
                public void onSuccess(WriteRequest request, WriteResponse response) {
                    this.client.getSharedAttributes().put(this.versionedId, tsKvProto);
                    super.onSuccess(request, response);
                }
            });
        } else if (logFailedUpdateOfNonChangedValue) {
            log.warn("Didn't update resource [{}] [{}]", (Object)versionedId, (Object)newValProto);
            String logMsg = String.format("%s: Didn't update resource versionedId - %s value - %s. Value is not changed", "warn", versionedId, newValProto);
            this.logService.log(client, logMsg);
        }
    }

    private Object getResourceValueFormatKv(LwM2mClient lwM2MClient, String pathIdVer) {
        LwM2mResource resourceValue = LwM2MTransportUtil.getResourceValueFromLwM2MClient(lwM2MClient, pathIdVer);
        if (resourceValue != null) {
            ResourceModel.Type currentType = resourceValue.getType();
            ResourceModel.Type expectedType = LwM2mTransportServerHelper.getResourceModelTypeEqualsKvProtoValueType(currentType, pathIdVer);
            if (!resourceValue.isMultiInstances()) {
                return LwM2mValueConverterImpl.getInstance().convertValue(resourceValue.getValue(), currentType, expectedType, new LwM2mPath(LwM2MTransportUtil.fromVersionedIdToObjectId(pathIdVer)));
            }
            if (resourceValue.getInstances().size() > 0) {
                return resourceValue.getInstances();
            }
            return null;
        }
        return null;
    }

    private String getStrValue(TransportProtos.TsKvProto tsKvProto) {
        return tsKvProto.getKv().getStringV();
    }

    @ConstructorProperties(value={"futures", "transportService", "helper", "clientContext", "config", "uplinkHandler", "downlinkHandler", "logService", "otaUpdateService", "modelProvider"})
    public DefaultLwM2MAttributesService(Map<Integer, SettableFuture<List<TransportProtos.TsKvProto>>> futures, TransportService transportService, LwM2mTransportServerHelper helper, LwM2mClientContext clientContext, LwM2MTransportServerConfig config, LwM2mUplinkMsgHandler uplinkHandler, LwM2mDownlinkMsgHandler downlinkHandler, LwM2MTelemetryLogService logService, LwM2MOtaUpdateService otaUpdateService, LwM2mModelProvider modelProvider) {
        this.futures = futures;
        this.transportService = transportService;
        this.helper = helper;
        this.clientContext = clientContext;
        this.config = config;
        this.uplinkHandler = uplinkHandler;
        this.downlinkHandler = downlinkHandler;
        this.logService = logService;
        this.otaUpdateService = otaUpdateService;
        this.modelProvider = modelProvider;
    }
}

