/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.leshan.core.model.DefaultDDFFileValidator;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.registration.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportServerHelper;
import org.thingsboard.server.transport.lwm2m.server.client.LwM2mClientContext;

@Service
@TbLwM2mTransportComponent
public class LwM2mVersionedModelProvider
implements LwM2mModelProvider {
    private static final Logger log = LoggerFactory.getLogger(LwM2mVersionedModelProvider.class);
    private final LwM2mClientContext lwM2mClientContext;
    private final LwM2mTransportServerHelper helper;
    private final LwM2mTransportContext context;
    private final ConcurrentMap<TenantId, ConcurrentMap<String, ObjectModel>> models;

    public LwM2mVersionedModelProvider(@Lazy LwM2mClientContext lwM2mClientContext, LwM2mTransportServerHelper helper, LwM2mTransportContext context) {
        this.lwM2mClientContext = lwM2mClientContext;
        this.helper = helper;
        this.context = context;
        this.models = new ConcurrentHashMap<TenantId, ConcurrentMap<String, ObjectModel>>();
    }

    private String getKeyIdVer(Integer objectId, String version) {
        return objectId != null ? objectId + "_" + (version == null || version.isEmpty() ? "1.0" : version) : null;
    }

    public LwM2mModel getObjectModel(Registration registration) {
        return new DynamicModel(registration);
    }

    public void evict(TenantId tenantId, String key) {
        if (tenantId.isNullUid()) {
            this.models.values().forEach(m -> m.remove(key));
        } else {
            ((ConcurrentMap)this.models.get(tenantId)).remove(key);
        }
    }

    private class DynamicModel
    implements LwM2mModel {
        private final Registration registration;
        private final TenantId tenantId;
        private final Lock modelsLock;

        public DynamicModel(Registration registration) {
            this.registration = registration;
            this.tenantId = LwM2mVersionedModelProvider.this.lwM2mClientContext.getClientByEndpoint(registration.getEndpoint()).getTenantId();
            this.modelsLock = new ReentrantLock();
            if (this.tenantId != null) {
                LwM2mVersionedModelProvider.this.models.computeIfAbsent(this.tenantId, t -> new ConcurrentHashMap());
            }
        }

        public ResourceModel getResourceModel(int objectId, int resourceId) {
            try {
                ObjectModel objectModel = this.getObjectModel(objectId);
                if (objectModel != null) {
                    return (ResourceModel)objectModel.resources.get(resourceId);
                }
                log.trace("Tenant hasn't such the TbResources: Object model with id [{}/0/{}].", (Object)objectId, (Object)resourceId);
                return null;
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return null;
            }
        }

        public ObjectModel getObjectModel(int objectId) {
            String version = this.registration.getSupportedVersion(Integer.valueOf(objectId));
            if (version != null) {
                return this.getObjectModelDynamic(objectId, version);
            }
            return null;
        }

        public Collection<ObjectModel> getObjectModels() {
            Map supportedObjects = this.registration.getSupportedObject();
            ArrayList<ObjectModel> result = new ArrayList<ObjectModel>(supportedObjects.size());
            for (Map.Entry supportedObject : supportedObjects.entrySet()) {
                ObjectModel objectModel = this.getObjectModelDynamic((Integer)supportedObject.getKey(), (String)supportedObject.getValue());
                if (objectModel == null) continue;
                result.add(objectModel);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectModel getObjectModelDynamic(Integer objectId, String version) {
            ObjectModel objectModel;
            String key = LwM2mVersionedModelProvider.this.getKeyIdVer(objectId, version);
            ObjectModel objectModel2 = objectModel = this.tenantId != null ? (ObjectModel)((ConcurrentMap)LwM2mVersionedModelProvider.this.models.get(this.tenantId)).get(key) : null;
            if (this.tenantId != null && objectModel == null) {
                this.modelsLock.lock();
                try {
                    objectModel = (ObjectModel)((ConcurrentMap)LwM2mVersionedModelProvider.this.models.get(this.tenantId)).get(key);
                    if (objectModel == null) {
                        objectModel = this.getObjectModel(key);
                    }
                    if (objectModel != null) {
                        ((ConcurrentMap)LwM2mVersionedModelProvider.this.models.get(this.tenantId)).put(key, objectModel);
                    } else {
                        log.error("Tenant hasn't such the resource: Object model with id [{}] version [{}].", (Object)objectId, (Object)version);
                    }
                }
                finally {
                    this.modelsLock.unlock();
                }
            }
            return objectModel;
        }

        private ObjectModel getObjectModel(String key) {
            Optional tbResource = LwM2mVersionedModelProvider.this.context.getTransportResourceCache().get(this.tenantId, ResourceType.LWM2M_MODEL, key);
            return tbResource.map(resource -> LwM2mVersionedModelProvider.this.helper.parseFromXmlToObjectModel(Base64.getDecoder().decode(resource.getData()), key + ".xml", new DefaultDDFFileValidator())).orElse(null);
        }
    }
}

