/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

import com.google.gson.JsonParser;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.leshan.core.model.DDFFileParser;
import org.eclipse.leshan.core.model.DDFFileValidator;
import org.eclipse.leshan.core.model.DefaultDDFFileValidator;
import org.eclipse.leshan.core.model.InvalidDDFFileException;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.ResourceModel;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbLwM2mTransportComponent;
import org.thingsboard.server.transport.lwm2m.server.LwM2mTransportContext;

@Component
@TbLwM2mTransportComponent
public class LwM2mTransportServerHelper {
    private static final Logger log = LoggerFactory.getLogger(LwM2mTransportServerHelper.class);
    private final LwM2mTransportContext context;
    private static final JsonParser JSON_PARSER = new JsonParser();

    public void sendParametersOnThingsboardAttribute(List<TransportProtos.KeyValueProto> result, TransportProtos.SessionInfoProto sessionInfo) {
        TransportProtos.PostAttributeMsg.Builder request = TransportProtos.PostAttributeMsg.newBuilder();
        request.addAllKv(result);
        TransportProtos.PostAttributeMsg postAttributeMsg = request.build();
        this.context.getTransportService().process(sessionInfo, postAttributeMsg, TransportServiceCallback.EMPTY);
    }

    public void sendParametersOnThingsboardTelemetry(List<TransportProtos.KeyValueProto> kvList, TransportProtos.SessionInfoProto sessionInfo) {
        this.sendParametersOnThingsboardTelemetry(kvList, sessionInfo, null);
    }

    public void sendParametersOnThingsboardTelemetry(List<TransportProtos.KeyValueProto> kvList, TransportProtos.SessionInfoProto sessionInfo, @Nullable Map<String, AtomicLong> keyTsLatestMap) {
        TransportProtos.TsKvListProto tsKvList = this.toTsKvList(kvList, keyTsLatestMap);
        TransportProtos.PostTelemetryMsg postTelemetryMsg = TransportProtos.PostTelemetryMsg.newBuilder().addTsKvList(tsKvList).build();
        this.context.getTransportService().process(sessionInfo, postTelemetryMsg, TransportServiceCallback.EMPTY);
    }

    TransportProtos.TsKvListProto toTsKvList(List<TransportProtos.KeyValueProto> kvList, Map<String, AtomicLong> keyTsLatestMap) {
        return TransportProtos.TsKvListProto.newBuilder().setTs(this.getTs(kvList, keyTsLatestMap)).addAllKv(kvList).build();
    }

    long getTs(List<TransportProtos.KeyValueProto> kvList, Map<String, AtomicLong> keyTsLatestMap) {
        if (keyTsLatestMap == null || kvList == null || kvList.isEmpty()) {
            return this.getCurrentTimeMillis();
        }
        return this.getTsByKey(kvList.get(0).getKey(), keyTsLatestMap, this.getCurrentTimeMillis());
    }

    long getTsByKey(@Nonnull String key, @Nonnull Map<String, AtomicLong> keyTsLatestMap, long tsNow) {
        AtomicLong tsLatestAtomic = keyTsLatestMap.putIfAbsent(key, new AtomicLong(tsNow));
        if (tsLatestAtomic == null) {
            return tsNow;
        }
        return this.compareAndSwapOrIncrementTsAtomically(tsLatestAtomic, tsNow);
    }

    long compareAndSwapOrIncrementTsAtomically(AtomicLong tsLatestAtomic, long tsNow) {
        long tsLatest;
        while ((tsLatest = tsLatestAtomic.get()) < tsNow) {
            if (!tsLatestAtomic.compareAndSet(tsLatest, tsNow)) continue;
            return tsNow;
        }
        return tsLatestAtomic.incrementAndGet();
    }

    long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public TransportProtos.SessionInfoProto getValidateSessionInfo(ValidateDeviceCredentialsResponse msg, long mostSignificantBits, long leastSignificantBits) {
        return TransportProtos.SessionInfoProto.newBuilder().setNodeId(this.context.getNodeId()).setSessionIdMSB(mostSignificantBits).setSessionIdLSB(leastSignificantBits).setDeviceIdMSB(msg.getDeviceInfo().getDeviceId().getId().getMostSignificantBits()).setDeviceIdLSB(msg.getDeviceInfo().getDeviceId().getId().getLeastSignificantBits()).setTenantIdMSB(msg.getDeviceInfo().getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(msg.getDeviceInfo().getTenantId().getId().getLeastSignificantBits()).setCustomerIdMSB(msg.getDeviceInfo().getCustomerId().getId().getMostSignificantBits()).setCustomerIdLSB(msg.getDeviceInfo().getCustomerId().getId().getLeastSignificantBits()).setDeviceName(msg.getDeviceInfo().getDeviceName()).setDeviceType(msg.getDeviceInfo().getDeviceType()).setDeviceProfileIdMSB(msg.getDeviceInfo().getDeviceProfileId().getId().getMostSignificantBits()).setDeviceProfileIdLSB(msg.getDeviceInfo().getDeviceProfileId().getId().getLeastSignificantBits()).build();
    }

    public ObjectModel parseFromXmlToObjectModel(byte[] xmlByte, String streamName, DefaultDDFFileValidator ddfValidator) {
        try {
            DDFFileParser ddfFileParser = new DDFFileParser((DDFFileValidator)ddfValidator);
            return (ObjectModel)ddfFileParser.parse((InputStream)new ByteArrayInputStream(xmlByte), streamName).get(0);
        }
        catch (IOException | InvalidDDFFileException e) {
            log.error("Could not parse the XML file [{}]", (Object)streamName, (Object)e);
            return null;
        }
    }

    public List<TransportProtos.KeyValueProto> getKvStringtoThingsboard(String key, String value) {
        ArrayList<TransportProtos.KeyValueProto> result = new ArrayList<TransportProtos.KeyValueProto>();
        value = value.replaceAll("<", "").replaceAll(">", "");
        result.add(TransportProtos.KeyValueProto.newBuilder().setKey(key).setType(TransportProtos.KeyValueType.STRING_V).setStringV(value).build());
        return result;
    }

    public TransportProtos.KeyValueProto getKvAttrTelemetryToThingsboard(ResourceModel.Type resourceType, String resourceName, Object value, boolean isMultiInstances) {
        TransportProtos.KeyValueProto.Builder kvProto = TransportProtos.KeyValueProto.newBuilder().setKey(resourceName);
        if (isMultiInstances) {
            kvProto.setType(TransportProtos.KeyValueType.JSON_V).setJsonV((String)value);
        } else {
            switch (resourceType) {
                case BOOLEAN: {
                    kvProto.setType(TransportProtos.KeyValueType.BOOLEAN_V).setBoolV(((Boolean)value).booleanValue()).build();
                    break;
                }
                case STRING: 
                case TIME: 
                case OPAQUE: 
                case OBJLNK: {
                    kvProto.setType(TransportProtos.KeyValueType.STRING_V).setStringV((String)value);
                    break;
                }
                case INTEGER: {
                    kvProto.setType(TransportProtos.KeyValueType.LONG_V).setLongV(((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    kvProto.setType(TransportProtos.KeyValueType.DOUBLE_V).setDoubleV(((Double)value).doubleValue());
                }
            }
        }
        return kvProto.build();
    }

    public static ResourceModel.Type getResourceModelTypeEqualsKvProtoValueType(ResourceModel.Type currentType, String resourcePath) {
        switch (currentType) {
            case BOOLEAN: {
                return ResourceModel.Type.BOOLEAN;
            }
            case STRING: 
            case TIME: 
            case OPAQUE: 
            case OBJLNK: {
                return ResourceModel.Type.STRING;
            }
            case INTEGER: {
                return ResourceModel.Type.INTEGER;
            }
            case FLOAT: {
                return ResourceModel.Type.FLOAT;
            }
        }
        throw new CodecException("Invalid ResourceModel_Type for resource %s, got %s", new Object[]{resourcePath, currentType});
    }

    public static Object getValueFromKvProto(TransportProtos.KeyValueProto kv) {
        switch (kv.getType()) {
            case BOOLEAN_V: {
                return kv.getBoolV();
            }
            case LONG_V: {
                return kv.getLongV();
            }
            case DOUBLE_V: {
                return kv.getDoubleV();
            }
            case STRING_V: {
                return kv.getStringV();
            }
            case JSON_V: {
                try {
                    return JSON_PARSER.parse(kv.getJsonV());
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    @ConstructorProperties(value={"context"})
    public LwM2mTransportServerHelper(LwM2mTransportContext context) {
        this.context = context;
    }
}

