/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.lwm2m.server;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.springframework.util.CollectionUtils;
import org.thingsboard.server.transport.lwm2m.config.LwM2MTransportServerConfig;

public class LwM2MNetworkConfig {
    public static Configuration getCoapConfig(Integer serverPortNoSec, Integer serverSecurePort, LwM2MTransportServerConfig config) {
        Configuration coapConfig = new Configuration();
        coapConfig.set((BasicDefinition)CoapConfig.COAP_PORT, (Object)serverPortNoSec);
        coapConfig.set((BasicDefinition)CoapConfig.COAP_SECURE_PORT, (Object)serverSecurePort);
        coapConfig.set((BasicDefinition)CoapConfig.BLOCKWISE_STRICT_BLOCK2_OPTION, (Object)true);
        coapConfig.set((BasicDefinition)CoapConfig.BLOCKWISE_ENTITY_TOO_LARGE_AUTO_FAILOVER, (Object)true);
        coapConfig.set(CoapConfig.BLOCKWISE_STATUS_LIFETIME, 300, TimeUnit.SECONDS);
        coapConfig.set((BasicDefinition)CoapConfig.MAX_RESOURCE_BODY_SIZE, (Object)0x10000000);
        coapConfig.set((BasicDefinition)CoapConfig.RESPONSE_MATCHING, (Object)CoapConfig.MatcherMode.RELAXED);
        coapConfig.set((BasicDefinition)CoapConfig.PREFERRED_BLOCK_SIZE, (Object)1024);
        coapConfig.set((BasicDefinition)CoapConfig.MAX_MESSAGE_SIZE, (Object)1024);
        coapConfig.set((BasicDefinition)CoapConfig.MAX_RETRANSMIT, (Object)10);
        if (!CollectionUtils.isEmpty(config.getNetworkConfig())) {
            Properties networkProps = new Properties();
            config.getNetworkConfig().forEach(p -> networkProps.put(p.getKey(), p.getValue()));
            coapConfig.add(networkProps);
        }
        return coapConfig;
    }
}

